/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.membership.pse;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import net.jxta.id.ID;
import net.jxta.impl.cm.Cm;
import net.jxta.impl.membership.pse.KeyStoreManager;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class CMKeyStoreManager
implements KeyStoreManager {
    private static final transient Logger LOG = Logger.getLogger((String)CMKeyStoreManager.class.getName());
    private static final String DEFAULT_KEYSTORE_TYPE = "jks";
    private String keystore_type;
    private String keystore_provider;
    private Cm keystore_cm;
    private ID keystore_location;

    public CMKeyStoreManager(String type, String provider, Cm cm, ID location) throws NoSuchProviderException, KeyStoreException {
        if (null == type) {
            type = DEFAULT_KEYSTORE_TYPE;
            provider = null;
        }
        if ("pkcs12".equalsIgnoreCase(type)) {
            if ("BC".equals(provider)) {
                provider = null;
            }
            boolean hasJDK15 = System.getProperty("java.specification.version", "0.0").compareTo("1.5") >= 0;
            provider = hasJDK15 ? null : "BC";
        }
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)("pse location = " + location + " in " + cm));
        }
        this.keystore_type = type;
        this.keystore_provider = provider;
        this.keystore_cm = cm;
        this.keystore_location = location;
        if (null == this.keystore_provider) {
            KeyStore.getInstance(this.keystore_type);
        } else {
            KeyStore.getInstance(this.keystore_type, this.keystore_provider);
        }
    }

    public boolean isInitialized() {
        return this.isInitialized(null);
    }

    public boolean isInitialized(char[] store_password) {
        try {
            KeyStore store = null == this.keystore_provider ? KeyStore.getInstance(this.keystore_type) : KeyStore.getInstance(this.keystore_type, this.keystore_provider);
            InputStream is = this.keystore_cm.getInputStream("Raw", this.keystore_location.toString());
            if (null == is) {
                return false;
            }
            store.load(is, store_password);
            return true;
        }
        catch (Exception failed) {
            return false;
        }
    }

    public void createKeyStore(char[] store_password) throws KeyStoreException, IOException {
        try {
            KeyStore store = null == this.keystore_provider ? KeyStore.getInstance(this.keystore_type) : KeyStore.getInstance(this.keystore_type, this.keystore_provider);
            store.load(null, store_password);
            this.saveKeyStore(store, store_password);
        }
        catch (NoSuchProviderException failed) {
            KeyStoreException failure = new KeyStoreException("NoSuchProviderException during keystore processing");
            failure.initCause(failed);
            throw failure;
        }
        catch (NoSuchAlgorithmException failed) {
            KeyStoreException failure = new KeyStoreException("NoSuchAlgorithmException during keystore processing");
            failure.initCause(failed);
            throw failure;
        }
        catch (CertificateException failed) {
            KeyStoreException failure = new KeyStoreException("CertificateException during keystore processing");
            failure.initCause(failed);
            throw failure;
        }
    }

    public KeyStore loadKeyStore(char[] password) throws KeyStoreException, IOException {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Loading (" + this.keystore_type + "," + this.keystore_provider + ") store from " + this.keystore_location));
        }
        try {
            KeyStore store = null == this.keystore_provider ? KeyStore.getInstance(this.keystore_type) : KeyStore.getInstance(this.keystore_type, this.keystore_provider);
            InputStream is = this.keystore_cm.getInputStream("Raw", this.keystore_location.toString());
            store.load(is, password);
            return store;
        }
        catch (NoSuchAlgorithmException failed) {
            KeyStoreException failure = new KeyStoreException("NoSuchAlgorithmException during keystore processing");
            failure.initCause(failed);
            throw failure;
        }
        catch (CertificateException failed) {
            KeyStoreException failure = new KeyStoreException("CertificateException during keystore processing");
            failure.initCause(failed);
            throw failure;
        }
        catch (NoSuchProviderException failed) {
            KeyStoreException failure = new KeyStoreException("NoSuchProviderException during keystore processing");
            failure.initCause(failed);
            throw failure;
        }
    }

    public void saveKeyStore(KeyStore store, char[] password) throws IOException, KeyStoreException {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Writing " + store + " to " + this.keystore_location));
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            store.store(bos, password);
            bos.close();
            this.keystore_cm.save("Raw", this.keystore_location.toString(), bos.toByteArray(), 0L, Long.MAX_VALUE);
        }
        catch (NoSuchAlgorithmException failed) {
            KeyStoreException failure = new KeyStoreException("NoSuchAlgorithmException during keystore processing");
            failure.initCause(failed);
            throw failure;
        }
        catch (CertificateException failed) {
            KeyStoreException failure = new KeyStoreException("CertificateException during keystore processing");
            failure.initCause(failed);
            throw failure;
        }
    }

    public void eraseKeyStore() throws IOException {
        this.keystore_cm.remove("Raw", this.keystore_location.toString());
    }
}

