/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.id.UUID;

import java.security.SecureRandom;
import java.util.GregorianCalendar;
import java.util.Random;
import java.util.TimeZone;
import net.jxta.impl.id.UUID.UUID;
import org.apache.log4j.Logger;

public final class UUIDFactory {
    private static final transient Logger LOG = Logger.getLogger((String)UUIDFactory.class.getName());
    static final long GREGORIAN_MILLIS_OFFSET = 12219292800000L;
    private long utc_offset = 0L;
    private long lastTimeSequence = 0L;
    private long inSequenceCounter = 0L;
    private long clock_seq = 0L;
    private long node = 0L;
    private Random randNum = new SecureRandom();
    private static UUIDFactory factory = new UUIDFactory();

    public static synchronized UUID newUUID() {
        return UUIDFactory.newUUID(UUIDFactory.factory.randNum.nextLong(), UUIDFactory.factory.randNum.nextLong());
    }

    private synchronized long getTimeSequence() {
        long now = (System.currentTimeMillis() - 12219292800000L + this.utc_offset) * 10000L;
        if (now > this.lastTimeSequence) {
            this.lastTimeSequence = now;
            this.inSequenceCounter = 0L;
        } else {
            ++this.inSequenceCounter;
            if (this.inSequenceCounter >= 10000L) {
                ++this.lastTimeSequence;
                this.inSequenceCounter = 0L;
            }
        }
        return now + this.inSequenceCounter;
    }

    public static UUID newSeqUUID() {
        long mostSig = 0L;
        long leastSig = 0L;
        long timeSeq = factory.getTimeSequence();
        mostSig |= (timeSeq & 0xFFFFFFFFL) << 32;
        mostSig |= (timeSeq >> 32 & 0xFFFFL) << 16;
        mostSig |= 0x1000L;
        leastSig |= Long.MIN_VALUE;
        leastSig |= (UUIDFactory.factory.clock_seq >> 8 & 0x3FL) << 56;
        leastSig |= (UUIDFactory.factory.clock_seq & 0xFFL) << 48;
        return new UUID(mostSig |= timeSeq >> 48 & 0xFFFL, leastSig |= UUIDFactory.factory.node & 0xFFFFFFFFFFFFL);
    }

    public static UUID newUUID(byte[] bytes) {
        if (bytes.length != 16) {
            throw new IllegalArgumentException("bytes must be 16 bytes in length");
        }
        long mostSig = 0L;
        for (int i = 0; i < 8; ++i) {
            mostSig = mostSig << 8 | (long)(bytes[i] & 0xFF);
        }
        long leastSig = 0L;
        for (int i = 8; i < 16; ++i) {
            leastSig = leastSig << 8 | (long)(bytes[i] & 0xFF);
        }
        return UUIDFactory.newUUID(mostSig, leastSig);
    }

    public static UUID newHashUUID(long mostSig, long leastSig) {
        mostSig &= 0xFFFFFFFFFFFF0FFFL;
        leastSig &= 0x3FFFFFFFFFFFFFFFL;
        return new UUID(mostSig |= 0x3000L, leastSig |= Long.MIN_VALUE);
    }

    public static UUID newUUID(long mostSig, long leastSig) {
        mostSig &= 0xFFFFFFFFFFFF0FFFL;
        leastSig &= 0x3FFFFFFFFFFFFFFFL;
        leastSig |= Long.MIN_VALUE;
        leastSig &= 0xFFFF7FFFFFFFFFFFL;
        return new UUID(mostSig |= 0x4000L, leastSig |= 0x800000000000L);
    }

    private UUIDFactory() {
        String[] tz_ids = TimeZone.getAvailableIDs(0);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        this.utc_offset = gregorianCalendar.get(15) + gregorianCalendar.get(16);
        this.clock_seq = (long)this.randNum.nextInt() & 0x3FFL;
        this.node = this.randNum.nextLong() & 0xFFFFFFFFFFFFL;
        this.node |= 0x800000000000L;
    }
}

