/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.id.UUID;

import java.net.URI;
import java.net.URL;
import net.jxta.impl.id.UUID.IDBytes;
import net.jxta.impl.id.UUID.IDFormat;
import net.jxta.impl.id.UUID.UUID;
import net.jxta.impl.id.UUID.UUIDFactory;
import org.apache.log4j.Logger;

public class PeerGroupID
extends net.jxta.peergroup.PeerGroupID {
    private static final transient Logger LOG = Logger.getLogger((String)PeerGroupID.class.getName());
    protected static final int groupIdOffset = 0;
    protected static final int parentgroupIdOffset = 16;
    protected static final int padOffset = 32;
    protected static final int padSize = 31;
    protected IDBytes id;

    protected PeerGroupID(IDBytes id) {
        this.id = id;
    }

    protected PeerGroupID(UUID groupUUID) {
        this.id = new IDBytes();
        this.id.bytes[63] = 2;
        this.id.longIntoBytes(0, groupUUID.getMostSignificantBits());
        this.id.longIntoBytes(8, groupUUID.getLeastSignificantBits());
    }

    public PeerGroupID() {
        this(UUIDFactory.newUUID());
    }

    public PeerGroupID(PeerGroupID parent) {
        this(UUIDFactory.newUUID());
        for (int eachByte = 0; eachByte < 16; ++eachByte) {
            this.id.bytes[16 + eachByte] = parent.id.bytes[0 + eachByte];
        }
    }

    public PeerGroupID(byte[] seed) {
        this.id = new IDBytes();
        this.id.bytes[63] = 2;
        for (int copySeed = Math.min(16, seed.length) - 1; copySeed >= 0; --copySeed) {
            this.id.bytes[copySeed + 0] = seed[copySeed];
        }
        this.id.bytes[6] = (byte)(this.id.bytes[6] & 0xF);
        this.id.bytes[6] = (byte)(this.id.bytes[6] | 0x40);
        this.id.bytes[8] = (byte)(this.id.bytes[8] & 0x3F);
        this.id.bytes[8] = (byte)(this.id.bytes[8] | 0x80);
        this.id.bytes[10] = (byte)(this.id.bytes[10] & 0x3F);
        this.id.bytes[10] = (byte)(this.id.bytes[10] | 0x80);
    }

    public PeerGroupID(PeerGroupID parent, byte[] seed) {
        this(seed);
        for (int eachByte = 0; eachByte < 16; ++eachByte) {
            this.id.bytes[16 + eachByte] = parent.id.bytes[0 + eachByte];
        }
    }

    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (target instanceof PeerGroupID) {
            PeerGroupID peergroupTarget = (PeerGroupID)target;
            if (!this.getIDFormat().equals(peergroupTarget.getIDFormat())) {
                return false;
            }
            if (this.id == peergroupTarget.id) {
                return true;
            }
            boolean result = this.id.equals(peergroupTarget.id);
            if (result) {
                peergroupTarget.id = this.id;
            }
            return result;
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String getIDFormat() {
        return IDFormat.INSTANTIATOR.getSupportedIDFormat();
    }

    public Object getUniqueValue() {
        return this.getIDFormat() + "-" + (String)this.id.getUniqueValue();
    }

    public URL getURL() {
        return IDFormat.getURL((String)this.getUniqueValue());
    }

    public net.jxta.peergroup.PeerGroupID getParentPeerGroupID() {
        boolean zero = true;
        for (int eachByte = 0; eachByte < 16; ++eachByte) {
            if (this.id.bytes[eachByte + 16] == 0) continue;
            zero = false;
            break;
        }
        if (zero) {
            return null;
        }
        UUID groupUUID = new UUID(this.id.bytesIntoLong(16), this.id.bytesIntoLong(24));
        PeerGroupID groupID = new PeerGroupID(groupUUID);
        return (net.jxta.peergroup.PeerGroupID)IDFormat.translateToWellKnown(groupID);
    }

    protected UUID getUUID() {
        return new UUID(this.id.bytesIntoLong(0), this.id.bytesIntoLong(8));
    }

    public URI toURI() {
        return IDFormat.toURI((String)this.getUniqueValue());
    }
}

