/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.transportMeter;

import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.Message;
import net.jxta.impl.endpoint.transportMeter.TransportBindingMetric;
import net.jxta.peer.PeerID;

public class TransportBindingMeter {
    private PeerID peerID;
    private EndpointAddress endpointAddress;
    private TransportBindingMetric cumulativeMetrics;
    private TransportBindingMetric deltaMetrics;

    public TransportBindingMeter(PeerID peerID, EndpointAddress endpointAddress) {
        this(peerID, endpointAddress, false, false);
    }

    public TransportBindingMeter(PeerID peerID, EndpointAddress endpointAddress, boolean initiatorConnected, boolean acceptorConnected) {
        this.peerID = peerID;
        this.endpointAddress = endpointAddress;
        this.cumulativeMetrics = new TransportBindingMetric(this, initiatorConnected, acceptorConnected);
    }

    public String toString() {
        return "TransportBindingMeter(" + this.endpointAddress + ";" + this.peerID + ")";
    }

    public synchronized TransportBindingMetric collectMetrics() {
        TransportBindingMetric prevDelta = this.deltaMetrics;
        this.deltaMetrics = null;
        return prevDelta;
    }

    private void createDeltaMetric() {
        this.deltaMetrics = new TransportBindingMetric(this.cumulativeMetrics);
    }

    public TransportBindingMetric getCumulativeMetrics() {
        return this.cumulativeMetrics;
    }

    public PeerID getPeerID() {
        return this.peerID;
    }

    public EndpointAddress getEndpointAddress() {
        return this.endpointAddress;
    }

    public void setPeerID(PeerID peerID) {
        this.peerID = peerID;
        this.cumulativeMetrics.setPeerID(peerID);
        if (this.deltaMetrics != null) {
            this.deltaMetrics.setPeerID(peerID);
        }
    }

    public synchronized void connectionEstablished(boolean initator, long timeToConnect) {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        long now = System.currentTimeMillis();
        this.deltaMetrics.connectionEstablished(initator, timeToConnect, now);
        this.cumulativeMetrics.connectionEstablished(initator, timeToConnect, now);
    }

    public synchronized void connectionFailed(boolean initator, long timeToConnect) {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        long now = System.currentTimeMillis();
        this.deltaMetrics.connectionFailed(initator, timeToConnect, now);
        this.cumulativeMetrics.connectionFailed(initator, timeToConnect, now);
    }

    public synchronized void connectionClosed(boolean initator, long connectionLife) {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        long now = System.currentTimeMillis();
        this.deltaMetrics.connectionClosed(initator, now);
        this.cumulativeMetrics.connectionClosed(initator, now);
    }

    public synchronized void connectionDropped(boolean initator, long connectionLife) {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        long now = System.currentTimeMillis();
        this.deltaMetrics.connectionDropped(initator, now);
        this.cumulativeMetrics.connectionDropped(initator, now);
    }

    public synchronized void pingReceived() {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.pingReceived();
        this.cumulativeMetrics.pingReceived();
    }

    public synchronized void ping(long time) {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.ping(time);
        this.cumulativeMetrics.ping(time);
    }

    public synchronized void pingFailed(long time) {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.pingFailed(time);
        this.cumulativeMetrics.pingFailed(time);
    }

    public synchronized void dataReceived(boolean initator, int size) {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.dataReceived(initator, size);
        this.cumulativeMetrics.dataReceived(initator, size);
    }

    public synchronized void messageReceived(boolean initator, Message message, long time, long size) {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.messageReceived(initator, message, time, size);
        this.cumulativeMetrics.messageReceived(initator, message, time, size);
    }

    public synchronized void receiveFailure(boolean initator, long time, long size) {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.receiveFailure(initator, time, size);
        this.cumulativeMetrics.receiveFailure(initator, time, size);
    }

    public synchronized void dataSent(boolean initator, long size) {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.dataSent(initator, size);
        this.cumulativeMetrics.dataSent(initator, size);
    }

    public synchronized void sendFailure(boolean initator, Message message, long time, long size) {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.sendFailure(initator, message, time, size);
        this.cumulativeMetrics.sendFailure(initator, message, time, size);
    }

    public synchronized void messageSent(boolean initator, Message message, long time, long size) {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.messageSent(initator, message, time, size);
        this.cumulativeMetrics.messageSent(initator, message, time, size);
    }
}

