/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.tcp;

import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import net.jxta.document.MimeMediaType;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.Message;
import net.jxta.id.ID;
import net.jxta.impl.endpoint.IPUtils;
import net.jxta.impl.endpoint.WireFormatMessage;
import net.jxta.impl.endpoint.WireFormatMessageFactory;
import net.jxta.impl.endpoint.msgframing.MessagePackageHeader;
import net.jxta.impl.endpoint.msgframing.WelcomeMessage;
import net.jxta.impl.endpoint.tcp.TcpTransport;
import net.jxta.impl.endpoint.transportMeter.TransportBindingMeter;
import net.jxta.util.LimitInputStream;
import net.jxta.util.WatchedInputStream;
import net.jxta.util.WatchedOutputStream;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

class TcpConnection
implements Runnable {
    private static final Logger LOG = Logger.getLogger((String)TcpConnection.class.getName());
    private TcpTransport proto = null;
    private EndpointAddress dstAddress = null;
    private EndpointAddress fullDstAddress = null;
    private transient InetAddress inetAddress = null;
    private transient int port = 0;
    private volatile transient boolean closed = false;
    private transient Thread recvThread = null;
    private transient WelcomeMessage myWelcome = null;
    private transient WelcomeMessage itsWelcome = null;
    private transient long lastUsed = System.currentTimeMillis();
    private transient Socket sharedSocket = null;
    private transient WatchedOutputStream woutputStream = null;
    private transient WatchedInputStream winputStream = null;
    private transient OutputStream outputStream = null;
    private transient InputStream inputStream = null;
    private TransportBindingMeter transportBindingMeter;
    private boolean initiator;
    private long connectionBegunTime;
    private boolean closingDueToFailure = false;
    private transient Object writeLock = new Object();
    private static final MimeMediaType appMsg = new MimeMediaType("application/x-jxta-msg");

    TcpConnection(EndpointAddress destaddr, TcpTransport p) throws IOException {
        String tmp;
        int portIndex;
        this.initiator = true;
        this.proto = p;
        this.fullDstAddress = destaddr;
        this.dstAddress = new EndpointAddress(destaddr, null, null);
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)("New TCP Connection to : " + this.dstAddress));
        }
        if ((portIndex = (tmp = destaddr.getProtocolAddress()).lastIndexOf(":")) == -1) {
            throw new IllegalArgumentException("Invalid EndpointAddress (port # missing) ");
        }
        try {
            this.port = Integer.valueOf(tmp.substring(portIndex + 1));
        }
        catch (NumberFormatException caught) {
            throw new IllegalArgumentException("Invalid EndpointAddress (port # invalid) ");
        }
        if (this.port <= 0 || this.port > 65535) {
            throw new IllegalArgumentException("Invalid port number in EndpointAddress: " + this.port);
        }
        this.inetAddress = InetAddress.getByName(tmp.substring(0, portIndex));
        if (this.inetAddress.isLoopbackAddress() != this.proto.usingInterface.isLoopbackAddress()) {
            throw new IOException("Network unreachable");
        }
        try {
            int rp = this.proto.getRestrictionPort();
            if (rp != -1 && (this.port < rp - 1 || this.port > rp + 1)) {
                throw new IOException("Simulated separate networks killed outgoing cnx.");
            }
            this.sharedSocket = IPUtils.connectToFrom(this.inetAddress, this.port, this.proto.usingInterface, 0, TcpTransport.connectionTimeOut);
            this.startSocket();
        }
        catch (IOException e) {
            if (this.sharedSocket != null) {
                this.sharedSocket.close();
            }
            throw e;
        }
    }

    TcpConnection(Socket incSocket, TcpTransport p) throws IOException {
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)("Connection from " + incSocket.getInetAddress().getHostAddress() + ":" + incSocket.getPort()));
        }
        this.proto = p;
        this.initiator = false;
        this.inetAddress = incSocket.getInetAddress();
        this.port = incSocket.getPort();
        this.fullDstAddress = this.dstAddress = new EndpointAddress(this.proto.getProtocolName(), this.inetAddress.getHostAddress() + ":" + this.port, null, null);
        this.sharedSocket = incSocket;
        this.startSocket();
        this.fullDstAddress = this.dstAddress = this.itsWelcome.getPublicAddress();
        this.setThreadName();
    }

    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (null == target) {
            return false;
        }
        if (target instanceof TcpConnection) {
            TcpConnection likeMe = (TcpConnection)target;
            return this.getDestinationAddress().equals(likeMe.getDestinationAddress()) && this.getDestinationPeerID().equals(likeMe.getDestinationPeerID());
        }
        return false;
    }

    protected void finalize() {
        this.closingDueToFailure = false;
        this.close();
    }

    public int hashCode() {
        return this.getDestinationPeerID().hashCode() + this.getDestinationAddress().hashCode();
    }

    public String toString() {
        return super.toString() + ":" + (null != this.itsWelcome ? this.itsWelcome.getPeerID().toString() : "unknown") + " on address " + (null != this.dstAddress ? this.dstAddress.toString() : "unknown");
    }

    private synchronized void setThreadName() {
        block3: {
            if (this.recvThread != null) {
                try {
                    this.recvThread.setName("TCP receive : " + this.itsWelcome.getPeerID() + " on address " + this.dstAddress);
                }
                catch (Exception ez1) {
                    if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block3;
                    LOG.error((Object)"Cannot change thread name", (Throwable)ez1);
                }
            }
        }
    }

    public EndpointAddress getDestinationAddress() {
        return (EndpointAddress)this.dstAddress.clone();
    }

    public EndpointAddress getConnectionAddress() {
        return this.itsWelcome.getDestinationAddress();
    }

    public ID getDestinationPeerID() {
        return this.itsWelcome.getPeerID();
    }

    private void startSocket() throws IOException {
        this.sharedSocket.setKeepAlive(true);
        int useBufferSize = Math.max(8192, this.sharedSocket.getSendBufferSize());
        this.sharedSocket.setSendBufferSize(useBufferSize);
        useBufferSize = Math.max(65536, this.sharedSocket.getReceiveBufferSize());
        this.sharedSocket.setReceiveBufferSize(useBufferSize);
        this.sharedSocket.setSoLinger(true, 120000);
        this.sharedSocket.setTcpNoDelay(true);
        this.woutputStream = new WatchedOutputStream(this.sharedSocket.getOutputStream(), 8192);
        this.woutputStream.setWatchList(this.proto.ShortCycle);
        this.winputStream = new WatchedInputStream(this.sharedSocket.getInputStream(), 8192);
        this.winputStream.setWatchList(this.proto.LongCycle);
        if (this.winputStream == null || this.woutputStream == null) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"   failed getting streams.");
            }
            throw new IOException("Could not get streams");
        }
        this.outputStream = new BufferedOutputStream(this.woutputStream, 65536);
        this.inputStream = this.winputStream;
        this.myWelcome = new WelcomeMessage(this.fullDstAddress, this.proto.getPublicAddress(), this.proto.group.getPeerID(), false);
        this.myWelcome.sendToStream(this.outputStream);
        this.outputStream.flush();
        this.inputActive(true);
        this.itsWelcome = new WelcomeMessage(this.inputStream);
        this.inputActive(false);
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("startSocket : Hello from " + this.itsWelcome.getPublicAddress() + " [" + this.itsWelcome.getPeerID() + "]"));
        }
        this.recvThread = new Thread(this.proto.myThreadGroup, this);
        this.setThreadName();
        this.recvThread.setDaemon(true);
    }

    protected void start() {
        this.recvThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(Message msg) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            if (this.closed) {
                if (LOG.isEnabledFor((Priority)Level.INFO)) {
                    LOG.info((Object)("Connection was closed to : " + this.dstAddress));
                }
                throw new IOException("Connection was closed to : " + this.dstAddress);
            }
            boolean success = false;
            long sendBeginTime = 0L;
            long size = 0L;
            try {
                WireFormatMessage serialed = WireFormatMessageFactory.toWire(msg, appMsg, null);
                MessagePackageHeader header = new MessagePackageHeader();
                header.setContentTypeHeader(serialed.getMimeType());
                size = serialed.getByteLength();
                header.setContentLengthHeader(size);
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("sendMessage (" + serialed.getByteLength() + ") to " + this.dstAddress + " via " + this.inetAddress.getHostAddress() + ":" + this.port));
                }
                header.sendToStream(this.outputStream);
                serialed.sendToStream(this.outputStream);
                this.outputStream.flush();
                success = true;
                this.setLastUsed(System.currentTimeMillis());
            }
            catch (Throwable failure) {
                if (LOG.isEnabledFor((Priority)Level.INFO)) {
                    LOG.info((Object)("tcp send - message send failed for " + this.inetAddress.getHostAddress() + ":" + this.port), failure);
                }
                this.closingDueToFailure = true;
                this.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block31: {
            long receiveBeginTime = 0L;
            long size = 0L;
            try {
                if (LOG.isEnabledFor((Priority)Level.INFO)) {
                    LOG.info((Object)("tcp receive - starts for " + this.inetAddress.getHostAddress() + ":" + this.port));
                }
                try {
                    try {
                        while (this.isConnected() && !this.closed) {
                            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                                LOG.debug((Object)("tcp receive - message starts for " + this.inetAddress.getHostAddress() + ":" + this.port));
                            }
                            MessagePackageHeader header = new MessagePackageHeader(this.inputStream);
                            MimeMediaType msgMime = header.getContentTypeHeader();
                            long msglength = header.getContentLengthHeader();
                            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                                LOG.debug((Object)("tcp receive - message body (" + msglength + ") starts for " + this.inetAddress.getHostAddress() + ":" + this.port));
                            }
                            this.inputActive(true);
                            Message msg = null;
                            try {
                                msg = WireFormatMessageFactory.fromWire(new LimitInputStream(this.inputStream, msglength, true), msgMime, null);
                            }
                            catch (IOException failed) {
                                if (LOG.isEnabledFor((Priority)Level.INFO)) {
                                    LOG.info((Object)("tcp receive - failed reading msg from " + this.inetAddress.getHostAddress() + ":" + this.port));
                                }
                                throw failed;
                            }
                            finally {
                                this.inputActive(false);
                            }
                            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                                LOG.debug((Object)("tcp receive - handing incoming message from " + this.inetAddress.getHostAddress() + ":" + this.port + " to EndpointService"));
                            }
                            this.proto.endpoint.demux(msg);
                            this.setLastUsed(System.currentTimeMillis());
                        }
                        Object var13_14 = null;
                        if (!this.closed) {
                            this.recvThread = null;
                            this.close();
                        }
                    }
                    catch (InterruptedIOException woken) {
                        this.closingDueToFailure = true;
                        if (LOG.isEnabledFor((Priority)Level.WARN)) {
                            LOG.warn((Object)("tcp receive - Error : read() timeout after " + woken.bytesTransferred + " on connection " + this.inetAddress.getHostAddress() + ":" + this.port));
                        }
                        Object var13_15 = null;
                        if (!this.closed) {
                            this.recvThread = null;
                            this.close();
                        }
                    }
                    catch (EOFException finished) {
                        if (LOG.isEnabledFor((Priority)Level.INFO)) {
                            LOG.info((Object)("tcp receive - Connection was closed by " + this.inetAddress.getHostAddress() + ":" + this.port));
                        }
                        Object var13_16 = null;
                        if (!this.closed) {
                            this.recvThread = null;
                            this.close();
                        }
                    }
                    catch (SocketException finished) {
                        this.closingDueToFailure = true;
                        if (LOG.isEnabledFor((Priority)Level.INFO)) {
                            LOG.info((Object)("tcp receive - Connection was closed by " + this.inetAddress.getHostAddress() + ":" + this.port));
                        }
                        Object var13_17 = null;
                        if (!this.closed) {
                            this.recvThread = null;
                            this.close();
                        }
                    }
                    catch (Throwable e) {
                        this.closingDueToFailure = true;
                        if (LOG.isEnabledFor((Priority)Level.WARN)) {
                            LOG.warn((Object)("tcp receive - Error on connection " + this.inetAddress.getHostAddress() + ":" + this.port), e);
                        }
                        Object var13_18 = null;
                        if (!this.closed) {
                            this.recvThread = null;
                            this.close();
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var13_19 = null;
                    if (!this.closed) {
                        this.recvThread = null;
                        this.close();
                    }
                    throw throwable;
                }
            }
            catch (Throwable all) {
                if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block31;
                LOG.error((Object)("Uncaught Throwable in thread :" + Thread.currentThread().getName()), all);
            }
        }
    }

    private void closeIOs() {
        block11: {
            block10: {
                block9: {
                    if (this.inputStream != null) {
                        try {
                            this.inputStream.close();
                            this.inputStream = null;
                        }
                        catch (Exception ez1) {
                            if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block9;
                            LOG.debug((Object)"could not close inputStream ", (Throwable)ez1);
                        }
                    }
                }
                if (this.outputStream != null) {
                    try {
                        this.outputStream.close();
                        this.outputStream = null;
                    }
                    catch (Exception ez1) {
                        if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block10;
                        LOG.debug((Object)"Error : could not close outputStream ", (Throwable)ez1);
                    }
                }
            }
            if (this.sharedSocket != null) {
                try {
                    this.sharedSocket.close();
                    this.sharedSocket = null;
                }
                catch (Exception ez1) {
                    if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block11;
                    LOG.debug((Object)"Error : could not close socket ", (Throwable)ez1);
                }
            }
        }
    }

    public synchronized void close() {
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)((this.closingDueToFailure ? "Failure" : "Normal") + " close of socket to : " + this.dstAddress + " / " + this.inetAddress.getHostAddress() + ":" + this.port));
            if (LOG.isEnabledFor((Priority)Level.DEBUG) && this.closingDueToFailure) {
                LOG.debug((Object)"stack trace", new Throwable("stack trace"));
            }
        }
        if (!this.closed) {
            this.setLastUsed(0L);
            this.closeIOs();
            this.closed = true;
            if (this.recvThread != null) {
                this.recvThread.interrupt();
            }
        }
    }

    public boolean isConnected() {
        return this.recvThread != null && !this.closed;
    }

    public long getLastUsed() {
        return this.lastUsed;
    }

    private void setLastUsed(long time) {
        this.lastUsed = time;
    }

    TransportBindingMeter getTransportBindingMeter() {
        return this.transportBindingMeter;
    }

    private void inputActive(boolean active) {
        if (active) {
            this.winputStream.setWatchList(this.proto.ShortCycle);
        } else {
            this.winputStream.setWatchList(this.proto.LongCycle);
        }
    }
}

