/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.servlethttp;

import java.io.IOException;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.StringMessageElement;
import net.jxta.impl.endpoint.BlockingMessenger;
import net.jxta.impl.endpoint.servlethttp.HttpMessageReceiver;
import net.jxta.impl.util.TimeUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class HttpServletMessenger
extends BlockingMessenger {
    private static final Logger LOG = Logger.getLogger((String)HttpServletMessenger.class.getName());
    private static final int SEND_IDLE = 0;
    private static final int SEND_INPROGRESS = 1;
    private static final int SEND_SUCCESS = 2;
    private static final int SEND_FAIL = 3;
    private static final int SEND_TOOLONG = 4;
    private static final int MAX_SENDING_BLOCK = 120000;
    private static final int MAX_SENDING_WAIT = 3000;
    private static final EndpointAddress nullEndpointAddr = new EndpointAddress("http", "0.0.0.0:0", null, null);
    private final EndpointAddress logicalAddress;
    private final MessageElement srcAddressElement;
    private Message outgoingMessage = null;
    private int sendResult = 0;
    private long sendingSince = 0L;

    public HttpServletMessenger(HttpMessageReceiver transport, EndpointAddress srcAddress, EndpointAddress logicalAddress) {
        super(transport.getEndpointService().getGroup().getPeerGroupID(), nullEndpointAddr, false);
        this.logicalAddress = logicalAddress;
        this.srcAddressElement = new StringMessageElement("EndpointSourceAddress", srcAddress.toString(), null);
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("HttpServletMessenger\n\t" + this.toString()));
        }
    }

    public EndpointAddress getLogicalDestinationImpl() {
        return (EndpointAddress)this.logicalAddress.clone();
    }

    public boolean isIdleImpl() {
        return false;
    }

    public synchronized boolean sendMessageBImpl(Message message, String service, String serviceParam) throws IOException {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Send " + message + " to " + this.dstAddress.toString() + "\n\t" + this.toString()));
        }
        if (this.isClosed()) {
            IOException failure = new IOException("Messenger was closed, it cannot be used to send messages.");
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)failure, (Throwable)failure);
            }
            throw failure;
        }
        message.replaceMessageElement("jxta", this.srcAddressElement);
        EndpointAddress destAddressToUse = this.getDestAddressToUse(service, serviceParam);
        StringMessageElement dstAddressElement = new StringMessageElement("EndpointDestinationAddress", destAddressToUse.toString(), (MessageElement)null);
        message.replaceMessageElement("jxta", dstAddressElement);
        if (!this.doSend(message)) {
            IOException failure = new IOException("Messenger was closed, it cannot be used to send messages.");
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("sendMessage failed (messenger closed).\n\t" + this.toString()), (Throwable)failure);
            }
            throw failure;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("sendMessage successful for " + message + "\n\t" + this.toString()));
        }
        return false;
    }

    public synchronized void closeImpl() {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("close\n\t" + this.toString()));
        }
        super.close();
        this.notifyAll();
    }

    private boolean doSend(Message message) {
        boolean result;
        long waitfor;
        if (this.isClosed()) {
            return false;
        }
        long now = System.currentTimeMillis();
        if (this.sendResult != 0) {
            if (this.sendResult == 4 && now > this.sendingSince + 120000L) {
                this.close();
            }
            return true;
        }
        this.outgoingMessage = message;
        this.sendResult = 1;
        this.sendingSince = now;
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Queued " + message));
        }
        this.notifyAll();
        long absoluteTimeOut = TimeUtils.toAbsoluteTimeMillis(3000L);
        while (!this.isClosed() && this.sendResult == 1 && (waitfor = TimeUtils.toRelativeTimeMillis(absoluteTimeOut)) > 0L) {
            try {
                this.wait(waitfor);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
                LOG.debug((Object)("InterruptedException timeout = 3000\n\t" + this.toString()), (Throwable)e);
            }
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Got result\n\t" + this.toString()));
        }
        if (this.isClosed() && 1 == this.sendResult) {
            return false;
        }
        boolean bl = result = this.sendResult != 3;
        if (this.sendResult == 1) {
            this.sendResult = 4;
            this.outgoingMessage = null;
        } else {
            this.sendResult = 0;
        }
        this.notifyAll();
        return result;
    }

    protected synchronized Message waitForMessage(long timeout) {
        long waitfor;
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Waiting (" + (0L == timeout ? "forever" : Long.toString(timeout)) + ") for message\n\t" + this.toString()));
        }
        if (0L == timeout) {
            timeout = Long.MAX_VALUE;
        }
        long absoluteTimeOut = TimeUtils.toAbsoluteTimeMillis(timeout);
        while (null == this.outgoingMessage && !this.isClosed() && (waitfor = TimeUtils.toRelativeTimeMillis(absoluteTimeOut)) > 0L) {
            try {
                this.wait(waitfor);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
                LOG.debug((Object)("InterruptedException timeout = " + timeout + "\n\t" + this.toString()), (Throwable)e);
            }
        }
        Message result = this.outgoingMessage;
        this.outgoingMessage = null;
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Got message  " + result));
        }
        if (!this.isClosed() && result == null) {
            this.sendResult = 0;
            this.notifyAll();
        }
        return result;
    }

    protected synchronized void messageSent(boolean wasSuccessful) {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("messageSent(" + wasSuccessful + ")\n\t" + this.toString()));
        }
        this.sendResult = 4 == this.sendResult ? 0 : (wasSuccessful ? 2 : 3);
        this.notifyAll();
    }

    public String toString() {
        return "[" + super.toString() + "] isClosed=" + this.isClosed() + " sendResult=" + this.sendResult + " outmsg=" + this.outgoingMessage;
    }
}

