/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.router;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Messenger;
import net.jxta.impl.util.TimeUtils;

public class Destinations
implements Runnable {
    private HashMap wisdoms = new HashMap(64);
    private volatile boolean stopped = false;
    private Thread gcThread = null;
    private EndpointService endpoint;

    private Wisdom getWisdom(EndpointAddress destination) {
        if (destination.getServiceName() != null) {
            destination = new EndpointAddress(destination, null, null);
        }
        return (Wisdom)this.wisdoms.get(destination);
    }

    private void addWisdom(EndpointAddress destination, Wisdom wisdom) {
        destination = new EndpointAddress(destination, null, null);
        this.wisdoms.put(destination, wisdom);
    }

    public Destinations(EndpointService endpoint) {
        this.endpoint = endpoint;
        ThreadGroup threadGroup = endpoint.getGroup().getHomeThreadGroup();
        this.gcThread = new Thread(threadGroup, this, "Destinations gc thread");
        this.gcThread.setDaemon(true);
        this.gcThread.start();
    }

    public synchronized void close() {
        this.stopped = true;
        this.gcThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.stopped) {
            try {
                Destinations destinations = this;
                synchronized (destinations) {
                    Iterator i = this.wisdoms.values().iterator();
                    while (i.hasNext()) {
                        Wisdom w = (Wisdom)i.next();
                        if (!w.isExpired()) continue;
                        i.remove();
                    }
                }
                Thread.sleep(60000L);
            }
            catch (InterruptedException ie) {
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public synchronized List allDestinations() {
        Set allKeys = this.wisdoms.keySet();
        ArrayList res = new ArrayList(allKeys.size());
        res.addAll(allKeys);
        return res;
    }

    public synchronized Messenger getCurrentMessenger(EndpointAddress destination) {
        Wisdom wisdom = this.getWisdom(destination);
        if (wisdom == null) {
            return null;
        }
        return wisdom.getCurrentMessenger();
    }

    public synchronized boolean isNormallyReachable(EndpointAddress destination) {
        Wisdom wisdom = this.getWisdom(destination);
        return wisdom != null && wisdom.isNormallyReachable();
    }

    public synchronized boolean isCurrentlyReachable(EndpointAddress destination) {
        Wisdom wisdom = this.getWisdom(destination);
        return wisdom != null && wisdom.isCurrentlyReachable();
    }

    public synchronized boolean isWelcomeNeeded(EndpointAddress destination) {
        Wisdom wisdom = this.getWisdom(destination);
        return wisdom != null && wisdom.isWelcomeNeeded();
    }

    public synchronized boolean addOutgoingMessenger(EndpointAddress destination, Messenger messenger) {
        Wisdom wisdom = this.getWisdom(destination);
        if (wisdom != null) {
            return wisdom.addOutgoingMessenger(messenger);
        }
        this.addWisdom(destination, new Wisdom(messenger, false));
        return true;
    }

    public synchronized boolean addIncomingMessenger(EndpointAddress destination, Messenger messenger) {
        Wisdom wisdom = this.getWisdom(destination);
        if (wisdom != null) {
            return wisdom.addIncomingMessenger(messenger);
        }
        this.addWisdom(destination, new Wisdom(messenger, true));
        return true;
    }

    public synchronized void noOutgoingMessenger(EndpointAddress destination) {
        Wisdom wisdom = this.getWisdom(destination);
        if (wisdom != null) {
            wisdom.noOutgoingMessenger();
        }
    }

    class Wisdom {
        static final long expiration = 600000L;
        private SoftReference messenger;
        private Messenger incomingMessenger;
        private EndpointAddress xportDest;
        private long expiresAt = 0L;
        private boolean welcomeNeeded = true;

        Wisdom(Messenger messenger, boolean incoming) {
            if (incoming) {
                this.addIncomingMessenger(messenger);
            } else {
                this.addOutgoingMessenger(messenger);
            }
        }

        boolean isWelcomeNeeded() {
            boolean res = this.welcomeNeeded;
            this.welcomeNeeded = false;
            return res;
        }

        boolean addIncomingMessenger(Messenger m) {
            boolean currentReachable;
            EndpointAddress logDest;
            Messenger currentIncoming = this.getIncoming();
            if (currentIncoming == null) {
                this.incomingMessenger = m;
                return true;
            }
            String originAddr = m.getDestinationAddress().getProtocolAddress();
            if (originAddr.equals((logDest = m.getLogicalDestinationAddress()).getProtocolAddress())) {
                this.incomingMessenger = m;
                return true;
            }
            int srcPort = Integer.parseInt(originAddr.substring(originAddr.lastIndexOf(58) + 1));
            boolean reachable = srcPort != 0;
            originAddr = currentIncoming.getDestinationAddress().getProtocolAddress();
            if (originAddr.equals((logDest = currentIncoming.getLogicalDestinationAddress()).getProtocolAddress())) {
                return false;
            }
            srcPort = Integer.parseInt(originAddr.substring(originAddr.lastIndexOf(58) + 1));
            boolean bl = currentReachable = srcPort != 0;
            if (currentReachable && !reachable) {
                return false;
            }
            this.incomingMessenger = m;
            return true;
        }

        boolean addOutgoingMessenger(Messenger m) {
            if (this.getOutgoing() != null) {
                return false;
            }
            this.messenger = new SoftReference<Messenger>(m);
            this.xportDest = m.getDestinationAddress();
            this.expiresAt = TimeUtils.toAbsoluteTimeMillis(600000L);
            return true;
        }

        void noOutgoingMessenger() {
            this.messenger = null;
            this.xportDest = null;
            this.expiresAt = 0L;
        }

        private Messenger getIncoming() {
            if (this.incomingMessenger != null) {
                if ((this.incomingMessenger.getState() & 0x3FF) != 0) {
                    return this.incomingMessenger;
                }
                this.incomingMessenger = null;
            }
            return null;
        }

        private Messenger getOutgoing() {
            if (this.messenger == null) {
                return null;
            }
            Messenger m = (Messenger)this.messenger.get();
            if (m == null || (m.getState() & 0x3FF) == 0) {
                m = Destinations.this.endpoint.getMessengerImmediate(this.xportDest, null);
                if (m == null) {
                    this.messenger = null;
                    this.xportDest = null;
                    this.expiresAt = 0L;
                    return null;
                }
                this.messenger = new SoftReference<Messenger>(m);
            }
            if ((m.getState() & 0x3CC) == 0) {
                this.messenger = null;
                this.xportDest = null;
                return null;
            }
            this.expiresAt = TimeUtils.toAbsoluteTimeMillis(600000L);
            return m;
        }

        Messenger getCurrentMessenger() {
            Messenger res = this.getOutgoing();
            if (res != null) {
                return res;
            }
            return this.getIncoming();
        }

        boolean isNormallyReachable() {
            return this.getOutgoing() != null || TimeUtils.toRelativeTimeMillis(this.expiresAt) >= 0L;
        }

        boolean isCurrentlyReachable() {
            return this.getIncoming() != null || this.getOutgoing() != null || TimeUtils.toRelativeTimeMillis(this.expiresAt) >= 0L;
        }

        boolean isExpired() {
            return !this.isCurrentlyReachable();
        }
    }
}

