/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.relay;

import java.io.IOException;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.Messenger;
import net.jxta.endpoint.StringMessageElement;
import net.jxta.impl.endpoint.BlockingMessenger;
import net.jxta.impl.endpoint.relay.RelayServer;
import net.jxta.impl.util.UnbiasedQueue;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

class RelayServerClient
implements Runnable {
    private static final Logger LOG = Logger.getLogger((String)RelayServerClient.class.getName());
    private static long stallTimeout = 0L;
    private EndpointService endpointService = null;
    private RelayServer server = null;
    private String clientPeerId = null;
    private long leaseLength = 0L;
    private EndpointAddress clientAddr = null;
    private volatile long expireTime = 0L;
    private boolean isClosed = false;
    private UnbiasedQueue messageList = null;
    private EndpointService endpoint = null;
    private Messenger messenger = null;
    private Thread thread = null;
    private boolean thread_idle = false;
    private MessageElement clientDestElement = null;
    private Message outOfBandMessage = null;

    protected RelayServerClient(RelayServer server, String clientPeerId, long leaseLength, long stallTimeout, int clientQueueSize) {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("new Client peerId=" + clientPeerId + " lease=" + leaseLength));
        }
        this.server = server;
        this.clientPeerId = clientPeerId;
        this.leaseLength = leaseLength;
        RelayServerClient.stallTimeout = stallTimeout;
        this.clientAddr = new EndpointAddress("jxta", clientPeerId, null, null);
        this.endpoint = server.getEndpointService();
        this.messageList = new UnbiasedQueue(clientQueueSize, false);
        this.renewLease();
    }

    protected void finalize() {
        this.closeClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("send queued messages to " + this.clientAddr));
        }
        try {
            try {
                Message message = null;
                int failedInARow = 0;
                while (true) {
                    message = null;
                    Messenger holdIt = null;
                    boolean wasOOB = false;
                    RelayServerClient relayServerClient = this;
                    // MONITORENTER : relayServerClient
                    if (this.messenger == null || this.messenger.isClosed()) {
                        long newExpireTime;
                        this.messenger = null;
                        if ((this.outOfBandMessage != null || this.messageList.getCurrentInQueue() > 0) && this.expireTime > (newExpireTime = System.currentTimeMillis() + stallTimeout)) {
                            this.expireTime = newExpireTime;
                        }
                        this.thread = null;
                        // MONITOREXIT : relayServerClient
                        break;
                    }
                    if (this.outOfBandMessage != null) {
                        message = this.outOfBandMessage;
                        this.outOfBandMessage = null;
                        wasOOB = true;
                    } else {
                        message = (Message)this.messageList.pop();
                        if (message == null) {
                            try {
                                this.thread_idle = true;
                                this.wait(4000L);
                                if (this.outOfBandMessage != null) {
                                    message = this.outOfBandMessage;
                                    this.outOfBandMessage = null;
                                    wasOOB = true;
                                } else {
                                    message = (Message)this.messageList.pop();
                                }
                            }
                            catch (InterruptedException ie) {
                                // empty catch block
                            }
                            if (message == null) {
                                this.thread = null;
                                // MONITOREXIT : relayServerClient
                                break;
                            }
                        }
                    }
                    holdIt = this.messenger;
                    this.thread_idle = false;
                    // MONITOREXIT : relayServerClient
                    MessageElement dstAddressElement = message.getMessageElement("jxta", "EndpointDestinationAddress");
                    if (null == dstAddressElement) {
                        if (!LOG.isEnabledFor((Priority)Level.WARN)) continue;
                        LOG.warn((Object)"message destination was not set");
                        continue;
                    }
                    EndpointAddress destAddr = new EndpointAddress(dstAddressElement.toString());
                    try {
                        holdIt.sendMessageB(message, destAddr.getServiceName(), destAddr.getServiceParameter());
                        RelayServerClient relayServerClient2 = this;
                        // MONITORENTER : relayServerClient2
                        failedInARow = 0;
                        if (!this.isClosed) {
                            this.expireTime = System.currentTimeMillis() + this.leaseLength;
                        }
                        // MONITOREXIT : relayServerClient2
                    }
                    catch (Exception e) {
                        RelayServerClient relayServerClient3 = this;
                        // MONITORENTER : relayServerClient3
                        if (++failedInARow >= 3) {
                            failedInARow = 0;
                            if (!this.isClosed) {
                                this.expireTime = System.currentTimeMillis() + this.leaseLength;
                            }
                            // MONITOREXIT : relayServerClient3
                            continue;
                        }
                        if (wasOOB) {
                            if (this.outOfBandMessage == null) {
                                this.outOfBandMessage = message;
                            }
                        } else {
                            this.messageList.pushBack(message);
                        }
                        // MONITOREXIT : relayServerClient3
                        if (LOG.isEnabledFor((Priority)Level.INFO)) {
                            LOG.info((Object)("closing messenger after exception :" + this.clientAddr), (Throwable)e);
                        }
                        holdIt.close();
                    }
                }
                Object var12_13 = null;
            }
            catch (Throwable all) {
                if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                    LOG.error((Object)("Uncaught Throwable in thread :" + Thread.currentThread().getName()), all);
                }
                Object var12_14 = null;
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) return;
                LOG.debug((Object)("stopped sending queued messages for " + this.clientAddr));
                return;
            }
            if (!LOG.isEnabledFor((Priority)Level.DEBUG)) return;
            LOG.debug((Object)("stopped sending queued messages for " + this.clientAddr));
            return;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            if (!LOG.isEnabledFor((Priority)Level.DEBUG)) throw throwable;
            LOG.debug((Object)("stopped sending queued messages for " + this.clientAddr));
            throw throwable;
        }
    }

    public String toString() {
        return this.clientPeerId + "," + (this.messageList == null ? -1 : this.messageList.getCurrentInQueue()) + "," + (this.messenger == null ? "-m" : "+m") + "," + (this.expireTime - System.currentTimeMillis());
    }

    protected int getQueueSize() {
        return this.messageList.getCurrentInQueue();
    }

    public long getLeaseRemaining() {
        return this.expireTime - System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeClient() {
        Messenger messengerToClose = null;
        RelayServerClient relayServerClient = this;
        synchronized (relayServerClient) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                LOG.info((Object)("Terminating client:\n\tclient=" + this.clientAddr + "\tnbMessages=" + this.messageList.getCurrentInQueue() + "\tmessenger=" + this.messenger + (this.messenger == null ? "" : "(c:" + this.messenger.isClosed() + ")") + "\tlease-left=" + (this.expireTime - System.currentTimeMillis()) + "\tt=" + (this.thread != null)));
            }
            messengerToClose = this.messenger;
            this.expireTime = 0L;
            this.messenger = null;
            this.thread = null;
            this.messageList.clear();
        }
        this.server.removeClient(this.clientPeerId, this);
        if (messengerToClose != null) {
            messengerToClose.close();
        }
    }

    synchronized void flushQueue() {
        this.messageList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addMessenger(Messenger newMessenger) {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("addMessenger() " + newMessenger));
        }
        if (newMessenger == null || newMessenger.isClosed()) {
            return false;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("messenger (" + this.messenger + ") thread=" + this.thread));
        }
        Messenger messengerToClose = newMessenger;
        RelayServerClient relayServerClient = this;
        synchronized (relayServerClient) {
            if (!this.isClosed) {
                if (LOG.isEnabledFor((Priority)Level.INFO) && this.messenger != null) {
                    LOG.info((Object)("closing messenger replaced by a new one : " + this.clientAddr));
                }
                messengerToClose = this.messenger;
                this.messenger = newMessenger;
                if (!(this.thread != null && !this.thread_idle || this.messageList.getCurrentInQueue() <= 0 && this.outOfBandMessage == null)) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("messageList.getCurrentInQueue() = " + this.messageList.getCurrentInQueue() + " client=" + this.clientAddr));
                    }
                    if (this.thread != null) {
                        this.notify();
                    } else {
                        this.thread = new Thread(this.server.group.getHomeThreadGroup(), this, "Draining queue to " + this.clientAddr);
                        this.thread.setDaemon(true);
                        this.thread.start();
                    }
                }
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("messenger (" + this.messenger + ") thread=" + this.thread));
                }
            }
        }
        if (messengerToClose != null) {
            messengerToClose.close();
        }
        return true;
    }

    public boolean isExpired() {
        boolean isExpired;
        boolean bl = isExpired = System.currentTimeMillis() > this.expireTime;
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("isExpired() = " + isExpired + " client=" + this.clientAddr));
        }
        if (isExpired) {
            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                LOG.info((Object)("Closing expired client : " + this.clientAddr));
            }
            this.closeClient();
        }
        return isExpired;
    }

    public synchronized boolean renewLease() {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("renewLease() old expireTime = " + this.expireTime));
        }
        if (this.isClosed) {
            return false;
        }
        if (this.messageList.getCurrentInQueue() > 0) {
            return true;
        }
        this.expireTime = System.currentTimeMillis() + this.leaseLength;
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("renewLease() new expireTime = " + this.expireTime));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueMessage(Message message, boolean outOfBand) throws IOException {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("queueMessage (" + this.messageList.getCurrentInQueue() + ") client=" + this.clientAddr));
        }
        RelayServerClient relayServerClient = this;
        synchronized (relayServerClient) {
            if (this.isClosed) {
                throw new IOException("Client has been disconnected");
            }
            if (outOfBand) {
                this.outOfBandMessage = message;
            } else {
                this.messageList.push(message);
            }
            if (this.thread == null || this.thread_idle) {
                if (this.messenger == null) {
                    long newExpireTime = System.currentTimeMillis() + stallTimeout;
                    if (this.expireTime > newExpireTime) {
                        this.expireTime = newExpireTime;
                    }
                } else if (this.thread != null) {
                    this.notify();
                } else {
                    this.thread = new Thread(this.server.group.getHomeThreadGroup(), this, "Draining queue to " + this.clientAddr);
                    this.thread.start();
                }
            }
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("done queueMessage (" + this.messageList.getCurrentInQueue() + ") client=" + this.clientAddr));
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("messenger (" + this.messenger + ") thread=" + this.thread));
        }
    }

    protected EndpointAddress getClientAddress() {
        return (EndpointAddress)this.clientAddr.clone();
    }

    protected Messenger getMessenger(EndpointAddress srcAddr, EndpointAddress destAddr, boolean outOfBand) {
        return new RelayMessenger(srcAddr, destAddr, this, outOfBand);
    }

    protected static class RelayMessenger
    extends BlockingMessenger {
        private MessageElement srcAddressElement = null;
        private RelayServerClient handler = null;
        private boolean outOfBand = false;
        private String defaultServiceName;
        private String defaultServiceParam;

        public RelayMessenger(EndpointAddress srcAddress, EndpointAddress destAddress, RelayServerClient handler, boolean outOfBand) {
            super(((RelayServerClient)handler).server.group.getPeerGroupID(), destAddress, false);
            this.defaultServiceName = destAddress.getServiceName();
            this.defaultServiceParam = destAddress.getServiceParameter();
            this.handler = handler;
            this.outOfBand = outOfBand;
            this.srcAddressElement = new StringMessageElement("EndpointSourceAddress", srcAddress.toString(), null);
        }

        public boolean isIdleImpl() {
            return false;
        }

        public void closeImpl() {
        }

        public EndpointAddress getLogicalDestinationImpl() {
            return this.handler.getClientAddress();
        }

        public boolean sendMessageBImpl(Message message, String serviceName, String serviceParam) throws IOException {
            message.replaceMessageElement("jxta", this.srcAddressElement);
            EndpointAddress destAddressToUse = this.getDestAddressToUse(serviceName, serviceParam);
            StringMessageElement dstAddressElement = new StringMessageElement("EndpointDestinationAddress", destAddressToUse.toString(), (MessageElement)null);
            message.replaceMessageElement("jxta", dstAddressElement);
            this.handler.queueMessage((Message)message.clone(), this.outOfBand);
            return true;
        }
    }
}

