/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.MissingResourceException;
import net.jxta.document.MimeMediaType;
import net.jxta.endpoint.Message;
import net.jxta.impl.endpoint.WireFormatMessage;
import net.jxta.util.ClassFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class WireFormatMessageFactory
extends ClassFactory {
    private static final Logger LOG = Logger.getLogger((String)WireFormatMessageFactory.class.getName());
    private Map encodings = new Hashtable();
    private volatile boolean loadedProperty = false;
    private static WireFormatMessageFactory factory = new WireFormatMessageFactory();

    private WireFormatMessageFactory() {
    }

    private synchronized boolean doLoadProperty() {
        if (this.loadedProperty) {
            return true;
        }
        try {
            return this.registerFromResources("net.jxta.impl.config", "MsgWireFmtsInstanceTypes");
        }
        catch (MissingResourceException notFound) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Could not find net.jxta.impl.config properties file!");
            }
            return false;
        }
    }

    protected Map getAssocTable() {
        return this.encodings;
    }

    public Class getClassOfInstantiators() {
        return Instantiator.class;
    }

    public Class getClassForKey() {
        return String.class;
    }

    protected boolean registerAssoc(String className) {
        boolean registeredSomething;
        block5: {
            registeredSomething = false;
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Registering : " + className));
            }
            try {
                Class<?> msgClass = Class.forName(className);
                Instantiator instantiator = (Instantiator)msgClass.getField("INSTANTIATOR").get(null);
                MimeMediaType[] mimeTypes = instantiator.getSupportedMimeTypes();
                for (int eachType = 0; eachType < mimeTypes.length; ++eachType) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("   Registering Type : " + mimeTypes[eachType].getMimeMediaType()));
                    }
                    registeredSomething |= WireFormatMessageFactory.registerInstantiator(mimeTypes[eachType], instantiator);
                }
            }
            catch (Exception all) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block5;
                LOG.warn((Object)("Failed to register '" + className + "'"), (Throwable)all);
            }
        }
        return registeredSomething;
    }

    public static boolean registerInstantiator(MimeMediaType mimetype, Instantiator instantiator) {
        boolean registered = factory.registerAssoc(mimetype.getMimeMediaType(), instantiator);
        return registered;
    }

    public static WireFormatMessage toWire(Message msg, MimeMediaType type, MimeMediaType[] preferedEncodings) {
        if (!WireFormatMessageFactory.factory.loadedProperty) {
            WireFormatMessageFactory.factory.loadedProperty = factory.doLoadProperty();
        }
        Instantiator instantiator = (Instantiator)factory.getInstantiator(type.getMimeMediaType());
        return instantiator.toWire(msg, type, preferedEncodings);
    }

    public static Message fromWire(InputStream is, MimeMediaType type, MimeMediaType contentEncoding) throws IOException {
        if (!WireFormatMessageFactory.factory.loadedProperty) {
            WireFormatMessageFactory.factory.loadedProperty = factory.doLoadProperty();
        }
        Instantiator instantiator = (Instantiator)factory.getInstantiator(type.getMimeMediaType());
        return instantiator.fromWire(is, type, contentEncoding);
    }

    public static interface Instantiator {
        public MimeMediaType[] getSupportedMimeTypes();

        public MimeMediaType[] getSupportedContentEncodings();

        public WireFormatMessage toWire(Message var1, MimeMediaType var2, MimeMediaType[] var3);

        public Message fromWire(InputStream var1, MimeMediaType var2, MimeMediaType var3) throws IOException;
    }
}

