/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Random;
import javax.net.ServerSocketFactory;
import net.jxta.impl.endpoint.SocketFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public final class IPUtils {
    private static final Logger LOG;
    static final Random random;
    static final String IPV4ANYADDRESS = "0.0.0.0";
    static final String IPV6ANYADDRESS = "::";
    static final String IPV4LOOPBACK = "127.0.0.1";
    static final String IPV6LOOPBACK = "::1";
    public static InetAddress ANYADDRESS;
    public static InetAddress ANYADDRESSV4;
    public static InetAddress ANYADDRESSV6;
    public static InetAddress LOOPBACK;
    public static InetAddress LOOPBACKV4;
    public static InetAddress LOOPBACKV6;
    private static SocketFactory socketFactory;
    private static ServerSocketFactory serverSocketFactory;
    static final int rangesize = 200;

    private IPUtils() {
    }

    public static Iterator getAllLocalAddresses() {
        ArrayList<InetAddress> allAddr = new ArrayList<InetAddress>();
        try {
            Enumeration<NetworkInterface> allInterfaces = NetworkInterface.getNetworkInterfaces();
            while (allInterfaces.hasMoreElements()) {
                NetworkInterface anInterface = allInterfaces.nextElement();
                Enumeration<InetAddress> allIntfAddr = anInterface.getInetAddresses();
                while (allIntfAddr.hasMoreElements()) {
                    InetAddress anAddr = allIntfAddr.nextElement();
                    if (anAddr.isLoopbackAddress() || allAddr.contains(anAddr)) continue;
                    allAddr.add(anAddr);
                }
            }
            if (0 == allAddr.size() || "true".equals(System.getProperty("net.jxta.impl.IPUtils.localOnly"))) {
                return Collections.singletonList(LOOPBACK).iterator();
            }
            return allAddr.iterator();
        }
        catch (Throwable caught) {
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.error((Object)"Could not get local address list", caught);
            }
            return Collections.singletonList(LOOPBACK).iterator();
        }
    }

    public static Socket connectToFrom(InetAddress inetAddress, int port, InetAddress usingInterface, int localPort, int timeout) throws IOException {
        if (socketFactory != null) {
            return socketFactory.createConnection(inetAddress, port, usingInterface, localPort, timeout);
        }
        return IPUtils.connectToFromNoFactory(inetAddress, port, usingInterface, localPort, timeout);
    }

    public static Socket connectToFromNoFactory(InetAddress inetAddress, int port, InetAddress usingInterface, int localPort, int timeout) throws IOException {
        Socket socket = new Socket();
        InetSocketAddress src = new InetSocketAddress(usingInterface, localPort);
        InetSocketAddress dst = new InetSocketAddress(inetAddress, port);
        socket.bind(src);
        socket.connect(dst, timeout);
        return socket;
    }

    public static void setSocketFactory(SocketFactory sf) {
        socketFactory = sf;
    }

    public static SocketFactory getSocketFactory() {
        return socketFactory;
    }

    public static void setServerSocketFactory(ServerSocketFactory sf) {
        serverSocketFactory = sf;
    }

    public static ServerSocketFactory getServerSocketFactory() {
        return serverSocketFactory;
    }

    public static ServerSocket openServerSocketInRange(int start, int end, int backlog, InetAddress bindAddress) throws IOException {
        ServerSocketFactory factory = IPUtils.getServerSocketFactory();
        if (start < 1 || start > 65535) {
            throw new IllegalArgumentException("Invalid start port");
        }
        if (end < 1 || end > 65535 || end < start) {
            throw new IllegalArgumentException("Invalid end port");
        }
        ArrayList<Integer> inRange = new ArrayList<Integer>(200);
        for (int eachInRange = 0; eachInRange < 200; ++eachInRange) {
            inRange.add(eachInRange, new Integer(eachInRange));
        }
        ArrayList<Integer> ranges = new ArrayList<Integer>();
        for (int starts = start; starts <= end; starts += 200) {
            ranges.add(new Integer(starts));
        }
        Collections.shuffle(ranges);
        while (!ranges.isEmpty()) {
            int range = (Integer)ranges.remove(0);
            Collections.shuffle(inRange);
            for (int eachInRange = 0; eachInRange < 200; ++eachInRange) {
                int tryPort = range + (Integer)inRange.get(eachInRange);
                if (tryPort > end) continue;
                try {
                    ServerSocket result = null == factory ? new ServerSocket(tryPort, backlog, bindAddress) : factory.createServerSocket(tryPort, backlog, bindAddress);
                    return result;
                }
                catch (BindException failed) {
                    // empty catch block
                }
            }
        }
        throw new BindException("All ports in range are in use.");
    }

    static {
        block13: {
            block12: {
                block11: {
                    block10: {
                        LOG = Logger.getLogger((String)IPUtils.class.getName());
                        random = new Random();
                        try {
                            ANYADDRESSV4 = InetAddress.getByName(IPV4ANYADDRESS);
                        }
                        catch (Throwable ignored) {
                            if (!LOG.isEnabledFor((Priority)Level.WARN)) break block10;
                            LOG.warn((Object)"failed to intialize ANYADDRESSV4. Not fatal");
                        }
                    }
                    try {
                        ANYADDRESSV6 = InetAddress.getByName(IPV6ANYADDRESS);
                    }
                    catch (Throwable ignored) {
                        if (!LOG.isEnabledFor((Priority)Level.WARN)) break block11;
                        LOG.warn((Object)"failed to intialize IPV6ANYADDRESS. Not fatal");
                    }
                }
                ANYADDRESS = ANYADDRESSV4 == null ? ANYADDRESSV6 : ANYADDRESSV4;
                try {
                    LOOPBACKV4 = InetAddress.getByName(IPV4LOOPBACK);
                }
                catch (Throwable ignored) {
                    if (!LOG.isEnabledFor((Priority)Level.WARN)) break block12;
                    LOG.warn((Object)"failed to intialize IPV4LOOPBACK. Not fatal");
                }
            }
            try {
                LOOPBACKV6 = InetAddress.getByName(IPV4LOOPBACK);
            }
            catch (Throwable ignored) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block13;
                LOG.warn((Object)"failed to intialize ANYADDRESSV4. Not fatal");
            }
        }
        LOOPBACK = LOOPBACKV4 == null ? LOOPBACKV6 : LOOPBACKV4;
        if (LOOPBACK == null || ANYADDRESS == null) {
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.error((Object)"failure initializing statics. Neither IPV4 nor IPV6 seem to work.");
            }
            throw new IllegalStateException("failure initializing statics. Neither IPV4 nor IPV6 seem to work.");
        }
    }
}

