/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.cm;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import net.jxta.impl.util.Dlink;
import net.jxta.impl.util.Dlist;
import net.jxta.impl.util.TimeUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class SrdiCache
implements Runnable {
    private static final Logger LOG = Logger.getLogger((String)SrdiCache.class.getName());
    private Hashtable caches = new Hashtable();
    private long maxSize;
    private long size;
    private long interval;
    private Dlist lru;
    private boolean stop = false;

    public SrdiCache(long maxSize) {
        this.maxSize = maxSize;
        this.size = 0L;
        this.lru = new Dlist();
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("SrdiCache initialized with maxSize : " + maxSize));
        }
    }

    public SrdiCache(long maxSize, long interval) {
        this.maxSize = maxSize;
        this.size = 0L;
        this.interval = interval;
        this.lru = new Dlist();
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("SrdiCache initialized with maxSize : " + maxSize));
        }
        new Thread((Runnable)this, "SrdiCache Garbage collection Thread").start();
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public synchronized long setMaxSize(long maxSize) {
        if (maxSize > this.size) {
            this.maxSize = maxSize;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("SrdiCache maxSize : " + this.maxSize));
        }
        return this.maxSize;
    }

    public long getSize() {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("SrdiCache size : " + this.size));
        }
        return this.size;
    }

    public Enumeration getPrimaryKeys() {
        return this.caches.keys();
    }

    public Enumeration getSecondaryKeys(String primaryKey) {
        Hashtable tbl = (Hashtable)this.caches.get(primaryKey);
        if (tbl == null) {
            return null;
        }
        return tbl.keys();
    }

    public Enumeration getEntries(String primaryKey, String secondaryKey) {
        Hashtable tbl = (Hashtable)this.caches.get(primaryKey);
        if (tbl == null) {
            return null;
        }
        return ((Vector)tbl.get(secondaryKey)).elements();
    }

    public synchronized void add(String primaryKey, String attribute, String value, Object path, long expiration, boolean sticky) {
        Hashtable secondaryTbl;
        Hashtable ptbl;
        if (value != null) {
            value = value.toUpperCase();
        }
        if ((ptbl = (Hashtable)this.caches.get(primaryKey)) == null) {
            ptbl = new Hashtable();
            this.caches.put(primaryKey, ptbl);
        }
        if ((secondaryTbl = (Hashtable)ptbl.get(attribute)) == null) {
            secondaryTbl = new Hashtable();
            ptbl.put(attribute, secondaryTbl);
        }
        if (this.size == this.maxSize) {
            this.purge(0);
        }
        SrdiEntry entry = new SrdiEntry(path, expiration);
        if (!sticky) {
            this.lru.putLast(entry);
        }
        if (value != null) {
            if (!secondaryTbl.containsKey(value)) {
                Vector<SrdiEntry> vec = new Vector<SrdiEntry>();
                vec.add(entry);
                secondaryTbl.put(value, vec);
            } else {
                Vector vec = (Vector)secondaryTbl.get(value);
                if (!vec.contains(entry)) {
                    vec.add(entry);
                }
            }
        }
        ++this.size;
    }

    public boolean containsKey(String primaryKey, String secondaryKey) {
        Hashtable ptbl = (Hashtable)this.caches.get(primaryKey);
        if (ptbl != null) {
            return this.caches.containsKey(secondaryKey);
        }
        return false;
    }

    public synchronized void remove(Object path) {
        Enumeration pkeys = this.caches.elements();
        while (pkeys.hasMoreElements()) {
            Enumeration caTbl = ((Hashtable)pkeys.nextElement()).elements();
            while (caTbl.hasMoreElements()) {
                Hashtable tbl = (Hashtable)caTbl.nextElement();
                Iterator values = tbl.values().iterator();
                while (values.hasNext()) {
                    Vector vec = (Vector)values.next();
                    for (int i = 0; i < vec.size(); ++i) {
                        SrdiEntry entry = (SrdiEntry)vec.elementAt(i);
                        if (!entry.getPath().equals(path)) continue;
                        vec.remove(i);
                        --i;
                        --this.size;
                    }
                }
            }
        }
    }

    public synchronized Enumeration query(String primaryKey, String attribute, String value) {
        boolean endswith = false;
        boolean startswith = false;
        boolean allvalues = false;
        if (primaryKey == null || primaryKey.length() == 0) {
            throw new IllegalArgumentException("primaryKey is mandatory");
        }
        if (value == null || value.length() == 0 || attribute == null || attribute.length() == 0) {
            allvalues = true;
        } else {
            if ((value = value.toUpperCase()).charAt(0) == '*') {
                endswith = true;
                value = value.substring(1, value.length());
            }
            if (value.length() == 0) {
                allvalues = true;
            } else if (value.charAt(value.length() - 1) == '*') {
                startswith = true;
                value = value.substring(0, value.indexOf("*"));
            }
        }
        Hashtable ptbl = (Hashtable)this.caches.get(primaryKey);
        if (ptbl == null) {
            return new Vector().elements();
        }
        if (attribute == null) {
            Hashtable tb;
            Enumeration vecs;
            Vector result = new Vector();
            Enumeration enumeration = ptbl.elements();
            if (enumeration.hasMoreElements() && (vecs = (tb = (Hashtable)enumeration.nextElement()).elements()).hasMoreElements()) {
                Vector tmp = (Vector)vecs.nextElement();
                this.addTo(result, this.getPaths(tmp));
            }
            return result.elements();
        }
        Hashtable tbl = (Hashtable)ptbl.get(attribute);
        if (tbl == null) {
            return new Vector().elements();
        }
        if (allvalues) {
            Enumeration values = tbl.elements();
            Vector result = new Vector();
            while (values.hasMoreElements()) {
                Vector tmp = (Vector)values.nextElement();
                this.addTo(result, this.getPaths(tmp));
            }
            return result.elements();
        }
        if (!endswith && !startswith) {
            Vector res = (Vector)tbl.get(value);
            if (res != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(attribute + " Found " + res.size()));
                }
                return this.getPaths(res);
            }
        } else {
            Vector result = new Vector();
            Enumeration keys = tbl.keys();
            while (keys.hasMoreElements()) {
                String val = (String)keys.nextElement();
                if (startswith && !endswith) {
                    if (!val.startsWith(value)) continue;
                    this.addTo(result, ((Vector)tbl.get(val)).elements());
                    continue;
                }
                if (endswith && !startswith) {
                    if (!val.endsWith(value)) continue;
                    this.addTo(result, ((Vector)tbl.get(val)).elements());
                    continue;
                }
                if (!startswith || !endswith || val.indexOf(value) < 0) continue;
                this.addTo(result, ((Vector)tbl.get(val)).elements());
            }
            return this.getPaths(result);
        }
        return new Vector().elements();
    }

    private Enumeration getPaths(Vector entries) {
        Vector<Object> result = new Vector<Object>();
        for (int i = 0; i < entries.size(); ++i) {
            SrdiEntry entry = (SrdiEntry)entries.elementAt(i);
            if (this.isExpired(entry)) continue;
            result.addElement(entry.path);
        }
        return result.elements();
    }

    private void addTo(Vector to, Enumeration from) {
        while (from.hasMoreElements()) {
            Object obj = from.nextElement();
            if (to.contains(obj)) continue;
            to.add(obj);
        }
    }

    public void purge(int fraction) {
        long nbToPurge;
        if (this.size == 0L) {
            return;
        }
        if (fraction == 0) {
            fraction = 1;
        }
        if ((nbToPurge = this.size / (long)fraction) == 0L) {
            nbToPurge = 1L;
        }
        while (nbToPurge-- > 0L) {
            SrdiEntry entry = (SrdiEntry)this.lru.next();
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("SrdiCache Purging : " + entry.getPath()));
            }
            this.remove(entry.getPath());
            entry.unlink();
            --this.size;
        }
    }

    public void clear() {
        this.lru.clear();
        this.caches.clear();
    }

    public void garbageCollect() {
        Enumeration primaryKeyTbl = this.caches.elements();
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)"SrdiCache garbage collect");
        }
        while (primaryKeyTbl.hasMoreElements()) {
            Hashtable attributes = (Hashtable)primaryKeyTbl.nextElement();
            Iterator secondaryKeyTbl = attributes.values().iterator();
            while (secondaryKeyTbl.hasNext()) {
                Hashtable secondaryEntries = (Hashtable)secondaryKeyTbl.next();
                Iterator values = secondaryEntries.values().iterator();
                while (values.hasNext()) {
                    Vector entries = (Vector)values.next();
                    for (int i = 0; i < entries.size(); ++i) {
                        if (!this.isExpired((SrdiEntry)entries.elementAt(i))) continue;
                        entries.removeElementAt(i);
                    }
                }
            }
        }
    }

    public void removeKey(String primaryKey, String secondaryKey) {
        Hashtable caTbl = (Hashtable)this.caches.get(primaryKey);
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("SrdiCache removing entries of pkey [" + primaryKey + "] skey[" + secondaryKey + "]"));
        }
        caTbl.remove(secondaryKey);
    }

    private boolean isExpired(SrdiEntry entry) {
        return entry.expiration < System.currentTimeMillis();
    }

    public synchronized void stop() {
        this.stop = true;
        this.notify();
    }

    public synchronized void run() {
        while (!this.stop) {
            try {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("waiting for " + this.interval + " before garbage collection"));
                }
                this.wait(this.interval);
                if (this.stop) {
                    return;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"Garbage collection started");
            }
            this.garbageCollect();
            if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
            LOG.debug((Object)"Garbage collection completed");
        }
    }

    class SrdiEntry
    extends Dlink {
        private Object path;
        private long expiration;

        public SrdiEntry(Object path, long expiration) {
            this.path = path;
            this.expiration = TimeUtils.toAbsoluteTimeMillis(expiration);
        }

        public Object getPath() {
            return this.path;
        }

        public long getExpiration() {
            return this.expiration;
        }
    }
}

