/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.cm;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.jxta.impl.xindice.core.DBException;
import net.jxta.impl.xindice.core.data.Key;
import net.jxta.impl.xindice.core.data.Record;
import net.jxta.impl.xindice.core.data.Value;
import net.jxta.impl.xindice.core.filer.BTreeCallback;
import net.jxta.impl.xindice.core.filer.BTreeException;
import net.jxta.impl.xindice.core.filer.BTreeFiler;
import net.jxta.impl.xindice.core.indexer.IndexQuery;
import net.jxta.impl.xindice.core.indexer.NameIndexer;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public final class Indexer {
    private String dir = null;
    private String file = null;
    private HashMap indices = new HashMap();
    private static final String listFileName = "offsets";
    private BTreeFiler listDB = null;
    private boolean sync = true;
    private static final Logger LOG = Logger.getLogger((String)Indexer.class.getName());

    public Indexer() {
    }

    public Indexer(boolean sync) {
        this.sync = sync;
    }

    public void setLocation(String dir, String file) {
        block10: {
            this.dir = dir;
            this.file = file;
            File directory = new File(dir);
            File[] indexFiles = directory.listFiles(new FilenameFilter(){

                public boolean accept(File parentDir, String fileName) {
                    return fileName.endsWith(".idx");
                }
            });
            for (int i = 0; i < indexFiles.length; ++i) {
                String name;
                String indexFileName = indexFiles[i].getName();
                int dash = indexFileName.lastIndexOf("-");
                int dot = indexFileName.lastIndexOf(".idx");
                if (dot <= 0 || dash <= 0 || this.indices.get(name = indexFileName.substring(dash + 1, dot).trim()) != null) continue;
                try {
                    NameIndexer indexer = new NameIndexer();
                    indexer.setLocation(dir, file + "-" + name);
                    indexer.setSync(this.sync);
                    if (!indexer.open()) {
                        indexer.create();
                        indexer.open();
                    }
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("Adding :" + indexFileName + " under " + name));
                    }
                    this.indices.put(name, indexer);
                    continue;
                }
                catch (DBException ignore) {
                    if (!LOG.isEnabledFor((Priority)Level.ERROR)) continue;
                    LOG.error((Object)("Failed to create Index " + name), (Throwable)ignore);
                }
            }
            try {
                this.listDB = new BTreeFiler();
                this.listDB.setSync(this.sync);
                this.listDB.setLocation(directory.getCanonicalPath(), file + "-" + listFileName);
                if (!this.listDB.open()) {
                    this.listDB.create();
                    this.listDB.open();
                }
            }
            catch (DBException dbe) {
                if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                    LOG.error((Object)"Failed during listDB Creation", (Throwable)dbe);
                }
            }
            catch (IOException ie) {
                if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block10;
                LOG.error((Object)"Failed during listDB Creation", (Throwable)ie);
            }
        }
    }

    public boolean open() throws DBException {
        return true;
    }

    public boolean create() throws DBException {
        return true;
    }

    public synchronized boolean close() throws DBException {
        if (this.indices != null) {
            Iterator i = this.indices.values().iterator();
            Iterator names = this.indices.keySet().iterator();
            while (i.hasNext()) {
                NameIndexer index = (NameIndexer)i.next();
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Closing Indexer :" + names.next()));
                }
                index.close();
            }
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"Clearing indices HashMap");
            }
            this.indices.clear();
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"Closing listDB");
            }
            this.listDB.close();
        }
        return true;
    }

    public Map getIndexers() {
        return Collections.unmodifiableMap(this.indices);
    }

    public BTreeFiler getListDB() {
        return this.listDB;
    }

    public void search(IndexQuery query, String name, BTreeCallback callback) throws IOException, BTreeException {
        int op;
        BTreeCallback cb = new SearchCallback(this.listDB, callback);
        if (query != null && ((op = query.getOperator()) == 8 || op == -8 || op == 5)) {
            query = new IndexQuery(0, query.getValues());
            cb = new EndsWithCallback(op, new SearchCallback(this.listDB, callback), query.getValue(0));
        }
        if (name == null) {
            if (this.indices != null) {
                Iterator i = this.indices.values().iterator();
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"Searching all indexes");
                }
                while (i.hasNext()) {
                    NameIndexer index = (NameIndexer)i.next();
                    index.query(query, new SearchCallback(this.listDB, callback));
                }
                return;
            }
        } else {
            NameIndexer indexer = (NameIndexer)this.indices.get(name);
            if (indexer == null) {
                return;
            }
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Searching Index : " + name));
            }
            indexer.query(query, cb);
        }
    }

    public void addToIndex(Map indexables, long pos) throws IOException, DBException {
        if (indexables == null) {
            return;
        }
        Iterator ni = indexables.keySet().iterator();
        while (ni.hasNext()) {
            NameIndexer indexer;
            String name = (String)ni.next();
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("looking up NameIndexer : " + name));
            }
            if ((indexer = (NameIndexer)this.indices.get(name)) == null) {
                indexer = new NameIndexer();
                indexer.setLocation(this.dir, this.file + "-" + name);
                indexer.setSync(this.sync);
                if (!indexer.open()) {
                    indexer.create();
                    indexer.open();
                }
                this.indices.put(name, indexer);
            }
            Key dbKey = new Key(name + (String)indexables.get(name));
            Key indexKey = new Key((String)indexables.get(name));
            long listPos = Indexer.writeRecord(this.listDB, dbKey, pos);
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Adding a reference at position :" + listPos + " to " + name + " index, Key: " + (String)indexables.get(name)));
            }
            indexer.add(indexKey, listPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromIndex(Map indexables, long pos) throws DBException {
        Iterator ni = indexables == null ? this.indices.keySet().iterator() : indexables.keySet().iterator();
        Long lpos = new Long(pos);
        while (ni.hasNext()) {
            String name = (String)ni.next();
            NameIndexer indexer = (NameIndexer)this.indices.get(name);
            if (indexer == null) continue;
            Key dbKey = new Key(name + (String)indexables.get(name));
            Key indexKey = new Key((String)indexables.get(name));
            BTreeFiler bTreeFiler = this.listDB;
            synchronized (bTreeFiler) {
                Record record = this.listDB.readRecord(dbKey);
                Set offsets = Indexer.readRecord(record);
                if (!offsets.isEmpty()) {
                    if (offsets.contains(lpos)) {
                        offsets.remove(lpos);
                        Value recordValue = new Value(Indexer.toByteArray(offsets));
                        this.listDB.writeRecord(dbKey, recordValue);
                    }
                    if (offsets.isEmpty()) {
                        this.listDB.deleteRecord(dbKey);
                        indexer.remove(indexKey);
                    }
                } else {
                    this.listDB.deleteRecord(dbKey);
                }
            }
        }
    }

    public void purge(long pos) throws IOException, BTreeException {
        IndexQuery iq = new IndexQuery(0, "");
        Iterator vi = this.indices.values().iterator();
        while (vi.hasNext()) {
            NameIndexer index = (NameIndexer)vi.next();
            PurgeCallback pc = new PurgeCallback(this.listDB, index, pos);
            index.query(iq, pc);
        }
    }

    private static byte[] toByteArray(Set offsets) {
        try {
            int size = offsets.size();
            ByteArrayOutputStream bos = new ByteArrayOutputStream(size * 8 + 4);
            DataOutputStream dos = new DataOutputStream(bos);
            dos.writeInt(size);
            Iterator oi = offsets.iterator();
            while (oi.hasNext()) {
                Long lpos = (Long)oi.next();
                dos.writeLong(lpos);
            }
            dos.close();
            return bos.toByteArray();
        }
        catch (IOException ie) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Exception during array to byte array conversion", (Throwable)ie);
            }
            return null;
        }
    }

    public static Set readRecord(Record record) {
        TreeSet<Long> result;
        block4: {
            result = new TreeSet<Long>();
            if (record == null) {
                return result;
            }
            InputStream is = record.getValue().getInputStream();
            try {
                DataInputStream ois = new DataInputStream(is);
                int size = ois.readInt();
                for (int i = 0; i < size; ++i) {
                    result.add(new Long(ois.readLong()));
                }
                ois.close();
            }
            catch (IOException ie) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block4;
                LOG.warn((Object)"Exception while reading Entry", (Throwable)ie);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long writeRecord(BTreeFiler listDB, Key key, long pos) throws DBException, IOException {
        BTreeFiler bTreeFiler = listDB;
        synchronized (bTreeFiler) {
            Long lpos = new Long(pos);
            Record record = listDB.readRecord(key);
            Set offsets = Indexer.readRecord(record);
            if (LOG.isEnabledFor((Priority)Level.DEBUG) && offsets != null) {
                LOG.debug((Object)("list.contains " + pos + " : " + offsets.contains(lpos)));
            }
            if (!offsets.contains(lpos)) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Adding a reference to record at :" + lpos));
                    LOG.debug((Object)("Writing :" + offsets.size() + " references"));
                }
                offsets.add(lpos);
            }
            Value recordValue = new Value(Indexer.toByteArray(offsets));
            return listDB.writeRecord(key, recordValue);
        }
    }

    public static final class SearchCallback
    implements BTreeCallback {
        private BTreeCallback callback = null;
        private BTreeFiler listDB = null;

        public SearchCallback(BTreeFiler listDB, BTreeCallback callback) {
            this.listDB = listDB;
            this.callback = callback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean indexInfo(Value val, long pos) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Found " + val.toString() + " at " + pos));
            }
            Record record = null;
            Set offsets = null;
            boolean result = true;
            try {
                BTreeFiler bTreeFiler = this.listDB;
                synchronized (bTreeFiler) {
                    record = this.listDB.readRecord(pos);
                    offsets = Indexer.readRecord(record);
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("Found " + offsets.size() + " entries"));
                    }
                }
                Iterator oi = offsets.iterator();
                while (oi.hasNext()) {
                    Long lpos = (Long)oi.next();
                    result &= this.callback.indexInfo(val, lpos);
                    if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
                    LOG.debug((Object)("Callback result : " + result));
                }
            }
            catch (DBException ex) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)"Exception while reading indexed", (Throwable)ex);
                }
                return false;
            }
            return result;
        }
    }

    private static final class PurgeCallback
    implements BTreeCallback {
        private NameIndexer indexer = null;
        private long pos = 0L;
        private Long lpos = null;
        private BTreeFiler listDB = null;

        PurgeCallback(BTreeFiler listDB, NameIndexer indexer, long pos) {
            this.listDB = listDB;
            this.indexer = indexer;
            this.pos = pos;
            this.lpos = new Long(pos);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean indexInfo(Value val, long pos) {
            block9: {
                try {
                    BTreeFiler bTreeFiler = this.listDB;
                    synchronized (bTreeFiler) {
                        Record record = this.listDB.readRecord(pos);
                        Set offsets = Indexer.readRecord(record);
                        if (!offsets.isEmpty()) {
                            if (offsets.contains(this.lpos)) {
                                offsets.remove(this.lpos);
                                if (!offsets.isEmpty()) {
                                    Value recordValue = new Value(Indexer.toByteArray(offsets));
                                    this.listDB.writeRecord(pos, recordValue);
                                }
                            } else {
                                return true;
                            }
                        }
                    }
                }
                catch (DBException ignore) {
                    if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block9;
                    LOG.debug((Object)"An exception occured", (Throwable)ignore);
                }
            }
            return true;
        }
    }

    private static final class EndsWithCallback
    implements BTreeCallback {
        private int op = 0;
        private BTreeCallback callback = null;
        private Value pattern = null;

        EndsWithCallback(int op, BTreeCallback callback, Value pattern) {
            this.op = op;
            this.callback = callback;
            this.pattern = pattern;
        }

        public boolean indexInfo(Value val, long pos) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("value :" + val + " pattern :" + this.pattern));
            }
            switch (this.op) {
                case 8: {
                    if (!val.endsWith(this.pattern)) break;
                    return this.callback.indexInfo(val, pos);
                }
                case -8: {
                    if (val.endsWith(this.pattern)) break;
                    return this.callback.indexInfo(val, pos);
                }
                case 5: {
                    if (!val.contains(this.pattern)) break;
                    return this.callback.indexInfo(val, pos);
                }
            }
            return true;
        }
    }
}

