/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.endpoint;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.ref.SoftReference;
import net.jxta.document.MimeMediaType;
import net.jxta.document.TextDocument;
import net.jxta.endpoint.MessageElement;
import net.jxta.util.CountingWriter;
import net.jxta.util.DevNullWriter;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public abstract class TextMessageElement
extends MessageElement
implements TextDocument {
    private static final Logger LOG = Logger.getLogger((String)TextMessageElement.class.getName());
    protected transient long cachedGetCharLength = -1L;
    protected transient SoftReference cachedGetChars = null;

    protected TextMessageElement(String name, MimeMediaType type, MessageElement sig) {
        super(name, type, sig);
    }

    public synchronized String toString() {
        String result = null;
        if (null != this.cachedToString && null != (result = (String)this.cachedToString.get())) {
            return result;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("creating toString of " + this.getClass().getName() + '@' + Integer.toHexString(this.hashCode())));
        }
        StringBuffer theString = new StringBuffer();
        try {
            int res;
            Reader asString = this.getReader();
            char[] characters = new char[256];
            while ((res = asString.read(characters)) >= 0) {
                theString.append(characters, 0, res);
            }
            result = theString.toString();
            this.cachedToString = new SoftReference<String>(result);
            return result;
        }
        catch (IOException caught) {
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.error((Object)"Could not generate string for element. ", (Throwable)caught);
            }
            throw new IllegalStateException("Could not generate string for element. " + caught);
        }
    }

    public String getFileExtension() {
        return "txt";
    }

    public synchronized long getCharLength() {
        if (this.cachedGetCharLength >= 0L) {
            return this.cachedGetCharLength;
        }
        CountingWriter countChars = new CountingWriter(new DevNullWriter());
        try {
            this.sendToWriter(countChars);
            this.cachedGetByteLength = countChars.getCharsWritten();
            return this.cachedGetByteLength;
        }
        catch (IOException caught) {
            throw new IllegalStateException("Could not get length of element : " + caught.toString());
        }
    }

    public synchronized char[] getChars(boolean copy) {
        long len;
        char[] result = null;
        if (null != this.cachedGetChars && null != (result = (char[])this.cachedGetChars.get())) {
            if (copy) {
                char[] theCopy = new char[result.length];
                System.arraycopy(theCopy, 0, result, 0, result.length);
            } else {
                return result;
            }
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("creating getChars of " + this.getClass().getName() + '@' + Integer.toHexString(this.hashCode())));
        }
        if ((len = this.getCharLength()) > Integer.MAX_VALUE) {
            throw new IllegalStateException("MessageElement is too large to be stored in a char array.");
        }
        result = new char[(int)len];
        try {
            int read;
            Reader reader = this.getReader();
            int toRead = (int)len;
            int offset = 0;
            while (-1 != (read = reader.read(result, offset, toRead))) {
                offset += read;
                if ((long)(toRead -= read) < len) continue;
            }
            if (toRead != 0) {
                IOException failure = new IOException("Unexpected EOF");
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)failure, (Throwable)failure);
                }
                throw failure;
            }
        }
        catch (IOException caught) {
            IllegalStateException failure = new IllegalStateException("Failed to get bytes of Message Element");
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)failure, (Throwable)caught);
            }
            throw failure;
        }
        if (!copy) {
            this.cachedGetChars = new SoftReference<char[]>(result);
        }
        return result;
    }

    public abstract Reader getReader() throws IOException;

    public void sendToWriter(Writer sendTo) throws IOException {
        this.copyReaderToWriter(this.getReader(), sendTo);
    }

    private void copyReaderToWriter(Reader source, Writer sink) throws IOException {
        int c;
        char[] buf = new char[4096];
        while (-1 != (c = source.read(buf))) {
            sink.write(buf, 0, c);
        }
    }
}

