/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.document;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.MissingResourceException;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.util.ClassFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public final class StructuredDocumentFactory
extends ClassFactory {
    private static final Logger LOG = Logger.getLogger((String)StructuredDocumentFactory.class.getName());
    private static StructuredDocumentFactory factory = new StructuredDocumentFactory();
    private Map encodings = new Hashtable();
    private Map extToMime = new HashMap();
    private Map mimeToExt = new HashMap();
    private boolean loadedProperty = false;

    private StructuredDocumentFactory() {
    }

    private boolean doLoadProperty() {
        try {
            return this.registerFromResources("net.jxta.impl.config", "StructuredDocumentInstanceTypes");
        }
        catch (MissingResourceException notFound) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Could not find net.jxta.impl.config properties file!");
            }
            return false;
        }
    }

    protected Map getAssocTable() {
        return this.encodings;
    }

    protected Class getClassForKey() {
        return String.class;
    }

    protected Class getClassOfInstantiators() {
        return Instantiator.class;
    }

    protected boolean registerAssoc(String className) {
        boolean registeredSomething;
        block3: {
            registeredSomething = false;
            try {
                Class<?> docClass = Class.forName(className);
                Instantiator instantiator = (Instantiator)docClass.getField("INSTANTIATOR").get(null);
                MimeMediaType[] mimeTypes = instantiator.getSupportedMimeTypes();
                for (int eachType = 0; eachType < mimeTypes.length; ++eachType) {
                    registeredSomething |= StructuredDocumentFactory.registerInstantiator(mimeTypes[eachType], instantiator);
                }
            }
            catch (Exception all) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block3;
                LOG.warn((Object)("Failed to register '" + className + "'"), (Throwable)all);
            }
        }
        return registeredSomething;
    }

    public static String getFileExtensionForMimeType(MimeMediaType mimetype) {
        return (String)StructuredDocumentFactory.factory.mimeToExt.get(mimetype.getMimeMediaType());
    }

    public static MimeMediaType getMimeTypeForFileExtension(String extension) {
        MimeMediaType result = null;
        String fromMap = (String)StructuredDocumentFactory.factory.extToMime.get(extension);
        if (null != fromMap) {
            result = new MimeMediaType(fromMap);
        }
        return result;
    }

    public static boolean registerInstantiator(MimeMediaType mimetype, Instantiator instantiator) {
        boolean registered = factory.registerAssoc(mimetype.getMimeMediaType(), instantiator);
        if (registered) {
            Instantiator.ExtensionMapping[] extensions = instantiator.getSupportedFileExtensions();
            for (int eachExt = 0; eachExt < extensions.length; ++eachExt) {
                if (null == extensions[eachExt].getMimeMediaType()) continue;
                StructuredDocumentFactory.factory.extToMime.put(extensions[eachExt].getExtension(), extensions[eachExt].getMimeMediaType().getMimeMediaType());
                StructuredDocumentFactory.factory.mimeToExt.put(extensions[eachExt].getMimeMediaType().getMimeMediaType(), extensions[eachExt].getExtension());
            }
        }
        return registered;
    }

    public static StructuredDocument newStructuredDocument(MimeMediaType mimetype, String doctype) {
        if (!StructuredDocumentFactory.factory.loadedProperty) {
            StructuredDocumentFactory.factory.loadedProperty = factory.doLoadProperty();
        }
        Instantiator instantiator = (Instantiator)factory.getInstantiator(mimetype.getMimeMediaType());
        return instantiator.newInstance(mimetype, doctype);
    }

    public static StructuredDocument newStructuredDocument(MimeMediaType mimetype, String doctype, String value) {
        if (!StructuredDocumentFactory.factory.loadedProperty) {
            StructuredDocumentFactory.factory.loadedProperty = factory.doLoadProperty();
        }
        Instantiator instantiator = (Instantiator)factory.getInstantiator(mimetype.getMimeMediaType());
        return instantiator.newInstance(mimetype, doctype, value);
    }

    public static StructuredDocument newStructuredDocument(MimeMediaType mimetype, InputStream stream) throws IOException {
        if (!StructuredDocumentFactory.factory.loadedProperty) {
            StructuredDocumentFactory.factory.loadedProperty = factory.doLoadProperty();
        }
        Instantiator instantiator = (Instantiator)factory.getInstantiator(mimetype.getMimeMediaType());
        return instantiator.newInstance(mimetype, stream);
    }

    public static StructuredDocument newStructuredDocument(MimeMediaType mimetype, Reader reader) throws IOException {
        Instantiator instantiator;
        if (!StructuredDocumentFactory.factory.loadedProperty) {
            StructuredDocumentFactory.factory.loadedProperty = factory.doLoadProperty();
        }
        if (!((instantiator = (Instantiator)factory.getInstantiator(mimetype.getMimeMediaType())) instanceof TextInstantiator)) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)("Document Class '" + instantiator.getClass().getName() + "' associated with '" + mimetype + "' is not a text oriented document"));
            }
            throw new UnsupportedOperationException("Document Class '" + instantiator.getClass().getName() + "' associated with '" + mimetype + "' is not a text oriented document");
        }
        return ((TextInstantiator)instantiator).newInstance(mimetype, reader);
    }

    public static interface TextInstantiator
    extends Instantiator {
        public StructuredDocument newInstance(MimeMediaType var1, Reader var2) throws IOException;
    }

    public static interface Instantiator {
        public MimeMediaType[] getSupportedMimeTypes();

        public ExtensionMapping[] getSupportedFileExtensions();

        public StructuredDocument newInstance(MimeMediaType var1, String var2);

        public StructuredDocument newInstance(MimeMediaType var1, String var2, String var3);

        public StructuredDocument newInstance(MimeMediaType var1, InputStream var2) throws IOException;

        public static class ExtensionMapping {
            String extension;
            MimeMediaType mimetype;

            private ExtensionMapping() {
            }

            public ExtensionMapping(String extension, MimeMediaType mimetype) {
                this.extension = extension;
                this.mimetype = mimetype;
            }

            protected Object clone() {
                return this;
            }

            public boolean equals(Object target) {
                if (this == target) {
                    return true;
                }
                if (target instanceof ExtensionMapping) {
                    ExtensionMapping asMapping = (ExtensionMapping)target;
                    return this.extension.equals(asMapping.extension) && this.mimetype.equals(asMapping.mimetype);
                }
                return false;
            }

            public int hashCode() {
                return this.extension.hashCode() ^ this.mimetype.hashCode();
            }

            public String toString() {
                return this.extension + " -> " + this.mimetype.toString();
            }

            public String getExtension() {
                return this.extension;
            }

            public MimeMediaType getMimeMediaType() {
                return this.mimetype;
            }
        }
    }
}

