/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.credential;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import net.jxta.credential.Credential;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.TextElement;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.peergroup.PeerGroup;
import net.jxta.service.Service;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public final class AuthenticationCredential
implements Credential {
    private static final Logger LOG = Logger.getLogger((String)AuthenticationCredential.class.getName());
    private String authenticationMethod = null;
    private Element identityInfo = null;
    private PeerGroup peergroup = null;

    public AuthenticationCredential(PeerGroup peergroup, String method, Element indentityInfo) {
        this.peergroup = peergroup;
        this.authenticationMethod = method;
        if (null != indentityInfo) {
            this.identityInfo = StructuredDocumentUtils.copyAsDocument(indentityInfo);
        }
    }

    public AuthenticationCredential(PeerGroup peergroup, Element root) {
        this.peergroup = peergroup;
        this.initialize(root);
    }

    public ID getPeerGroupID() {
        return this.peergroup.getPeerGroupID();
    }

    public ID getPeerID() {
        return this.peergroup.getPeerID();
    }

    public Service getSourceService() {
        return null;
    }

    public boolean isExpired() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public Object getSubject() {
        return null;
    }

    public StructuredDocument getDocument(MimeMediaType as) throws Exception {
        StructuredDocument doc = StructuredDocumentFactory.newStructuredDocument(as, "jxta:Cred");
        if (doc instanceof Attributable) {
            ((Attributable)((Object)doc)).addAttribute("xmlns:jxta", "http://jxta.org");
            ((Attributable)((Object)doc)).addAttribute("xml:space", "preserve");
            ((Attributable)((Object)doc)).addAttribute("type", "AuthenticationCredential");
        }
        Element e = doc.createElement("Method", this.getMethod());
        doc.appendChild(e);
        e = doc.createElement("PeerGroupID", this.getPeerGroupID().toString());
        doc.appendChild(e);
        e = doc.createElement("PeerID", this.getPeerID().toString());
        doc.appendChild(e);
        if (null != this.identityInfo) {
            e = doc.createElement("IdentityInfo");
            doc.appendChild(e);
            StructuredDocumentUtils.copyElements(doc, e, this.identityInfo);
        }
        return doc;
    }

    public String getMethod() {
        return this.authenticationMethod;
    }

    protected void setMethod(String authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
    }

    public Element getIdentityInfo() {
        return null == this.identityInfo ? null : StructuredDocumentUtils.copyAsDocument(this.identityInfo);
    }

    protected boolean handleElement(TextElement elem) {
        if (elem.getName().equals("PeerGroupID")) {
            try {
                URI gID = new URI(elem.getTextValue());
                ID pgid = IDFactory.fromURI(gID);
                if (!pgid.equals(this.getPeerGroupID())) {
                    throw new IllegalArgumentException("Operation is from a different group. " + pgid + " != " + this.getPeerGroupID());
                }
            }
            catch (URISyntaxException badID) {
                throw new IllegalArgumentException("Unusable ID in advertisement: " + elem.getTextValue());
            }
            return true;
        }
        if (elem.getName().equals("PeerID")) {
            try {
                URI pID = new URI(elem.getTextValue());
                ID pid = IDFactory.fromURI(pID);
                if (!pid.equals(this.getPeerID())) {
                    throw new IllegalArgumentException("Operation is from a different group. " + pid + " != " + this.getPeerID());
                }
            }
            catch (URISyntaxException badID) {
                throw new IllegalArgumentException("Bad Peer ID in advertisement: " + elem.getTextValue());
            }
            catch (ClassCastException badID) {
                throw new IllegalArgumentException("Id is not a peer id: " + elem.getTextValue());
            }
            return true;
        }
        if (elem.getName().equals("Method")) {
            this.setMethod(elem.getTextValue());
            return true;
        }
        if (elem.getName().equals("IdentityInfo")) {
            Enumeration firstChild = elem.getChildren();
            if (!firstChild.hasMoreElements()) {
                throw new IllegalArgumentException("Missing identity info");
            }
            this.identityInfo = StructuredDocumentUtils.copyAsDocument((Element)firstChild.nextElement());
            return true;
        }
        return false;
    }

    protected void initialize(Element root) {
        String doctype;
        Attribute itsType;
        if (!TextElement.class.isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports TextElement");
        }
        TextElement doc = (TextElement)root;
        String typedoctype = "";
        if (root instanceof Attributable && null != (itsType = ((Attributable)((Object)root)).getAttribute("type"))) {
            typedoctype = itsType.getValue();
        }
        if (!(doctype = doc.getName()).equals("jxta:AuthenticationCredential") && !typedoctype.equals("jxta:AuthenticationCredential")) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doctype);
        }
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            TextElement elem = (TextElement)elements.nextElement();
            if (this.handleElement(elem) || !LOG.isEnabledFor((Priority)Level.WARN)) continue;
            LOG.warn((Object)("Unhandleded element '" + elem.getName() + "' in " + doc.getName()));
        }
    }
}

