/*
 * Decompiled with CFR 0.152.
 */
package madkit.demos.gpong;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import madkit.demos.gpong.ComputerPlayer;
import madkit.demos.gpong.GPongAgent;
import madkit.demos.gpong.PongBall;

public class GPongGUI
extends JComponent
implements Runnable {
    GPongAgent ag;
    PongBall ball;
    ComputerPlayer computer;
    Thread thread;
    boolean running = true;
    final int default_width = 280;
    final int default_height = 240;
    boolean side = false;

    boolean getSide() {
        return this.side;
    }

    public GPongGUI(GPongAgent gPongAgent) {
        this.ag = gPongAgent;
        this.setBackground(Color.black);
        this.setPreferredSize(new Dimension(280, 240));
        this.side = false;
    }

    void setLeftPlayer() {
        this.side = true;
        this.computer = new ComputerPlayer(this, 15, this.getHeight() / 2 + 20, null, true);
        this.repaint();
    }

    void setRightPlayer() {
        this.side = false;
        this.computer = new ComputerPlayer(this, this.getWidth() - 35, this.getHeight() / 2 - 20, null, false);
        this.repaint();
    }

    void leaveBall(int n, int n2, int n3) {
        this.computer.setBall(null);
        this.ball = null;
        this.ag.sendBall(n, n2, n3);
    }

    void createInitBall() {
        this.createBall(this.getHeight() / 3, 2, 2);
    }

    void createBall(int n, int n2, int n3) {
        if (this.side) {
            this.ball = new PongBall(this, this.getWidth() - 10, n);
            if (n2 > 0) {
                n2 = -n2;
            }
        } else {
            this.ball = new PongBall(this, 10, n);
            if (n2 < 0) {
                n2 = -n2;
            }
        }
        this.ball.setSpeed(n2, n3);
        this.computer.setBall(this.ball);
    }

    public void start() {
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    public synchronized void setGoOn(boolean bl) {
        this.running = bl;
    }

    public void run() {
        while (this.running) {
            this.repaint();
            if (this.ball != null) {
                this.ball.move();
            }
            if (this.computer != null) {
                this.computer.move();
            }
            if (this.ball != null) {
                this.ball.testForCollisionComputer(this.computer);
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
    }

    public void paintComponent(Graphics graphics) {
        if (this.ball != null) {
            this.ball.display(graphics);
        }
        if (this.computer != null) {
            this.computer.display(graphics);
        }
    }
}

