/*
 * Decompiled with CFR 0.152.
 */
package madkit.demos;

import madkit.kernel.Agent;
import madkit.kernel.Message;
import madkit.kernel.StringMessage;

public class MultiPong
extends Agent {
    static final int PLAYING = 1;
    static final int WAITING = 2;
    private int status = 2;

    public void activate() {
        this.createGroup(true, "pong", "multi-pong", null, null);
        this.println("No multi-pong group : I created one");
        this.requestRole("pong", "multi-pong", "player", null);
    }

    public void live() {
        while (true) {
            this.exitImmediatlyOnKill();
            switch (this.status) {
                case 1: {
                    Message message = this.waitNextMessage(1300L);
                    if (message == null) {
                        this.println("partner is gone : waiting");
                        this.status = 2;
                        break;
                    }
                    this.println("message from " + message.getSender() + " I reply !");
                    this.pause(500);
                    this.sendMessage(message.getSender(), (Message)new StringMessage("Ball"));
                    break;
                }
                case 2: {
                    if (this.sendMessage("pong", "multi-pong", "player", (Message)new StringMessage("Ball"))) {
                        this.println("I have a new partner !!");
                        this.status = 1;
                        break;
                    }
                    this.println("still nobody...");
                    this.pause(1200);
                }
            }
        }
    }

    public void end() {
        this.println("Bye Bye !!");
        this.println("PingPong agent Ended");
    }
}

