/*
 * Decompiled with CFR 0.152.
 */
package madkit.simulation.probes;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Probe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflexiveProbe
extends Probe<AbstractAgent> {
    protected Map<AbstractAgent, Field> fields;
    private String property;

    public ReflexiveProbe(String string, String string2, String string3) {
        super(string, string2);
        this.property = string3;
        this.fields = new HashMap<AbstractAgent, Field>();
    }

    public ReflexiveProbe(String string, String string2, String string3, String string4) {
        super(string, string2, string3);
        this.property = string4;
        this.fields = new HashMap<AbstractAgent, Field>();
    }

    public String getProperty() {
        return this.property;
    }

    public void findFields() {
        for (AbstractAgent abstractAgent : this.getCurrentAgentsList()) {
            try {
                this.fields.put(abstractAgent, abstractAgent.getClass().getField(this.property));
            }
            catch (Exception exception) {
                System.err.println("Can't find property: " + this.property + " on " + abstractAgent.toString() + exception);
            }
        }
    }

    public void initialize() {
        this.findFields();
    }

    public void update(AbstractAgent abstractAgent, boolean bl) {
        if (bl) {
            this.updateFieldFor(abstractAgent);
        } else {
            this.fields.remove(abstractAgent);
        }
    }

    public void updateFieldFor(AbstractAgent abstractAgent) {
        try {
            this.fields.put(abstractAgent, abstractAgent.getClass().getField(this.property));
        }
        catch (Exception exception) {
            System.err.println("Can't find property: " + this.property + " on " + abstractAgent.toString() + "  " + exception);
        }
    }

    public synchronized double getDouble(AbstractAgent abstractAgent) {
        try {
            return this.fields.get(abstractAgent).getDouble(abstractAgent);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("Unable to getDouble on " + abstractAgent.toString() + "  " + illegalAccessException);
            return Double.NaN;
        }
    }

    public synchronized long getLong(AbstractAgent abstractAgent) {
        try {
            return this.fields.get(abstractAgent).getLong(abstractAgent);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("Unable to getLong on " + abstractAgent.toString() + "  " + illegalAccessException);
            return 0L;
        }
    }

    public synchronized boolean getBoolean(AbstractAgent abstractAgent) {
        try {
            return this.fields.get(abstractAgent).getBoolean(abstractAgent);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("Unable to getBoolean on " + abstractAgent.toString() + "  " + illegalAccessException);
            return false;
        }
    }

    public synchronized char getChar(AbstractAgent abstractAgent) {
        try {
            return this.fields.get(abstractAgent).getChar(abstractAgent);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("Unable to getBoolean on " + abstractAgent.toString() + "  " + illegalAccessException);
            return '\uffff';
        }
    }

    public synchronized Object getObject(AbstractAgent abstractAgent) {
        try {
            return this.fields.get(abstractAgent).get(abstractAgent);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("Unable to getObject on " + abstractAgent.toString() + "  " + illegalAccessException);
            return null;
        }
    }

    public int getPropertyCount() {
        return this.fields.size();
    }
}

