/*
 * Decompiled with CFR 0.152.
 */
package madkit.simulation.probes;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Kernel;
import madkit.kernel.Probe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyProbe<A extends AbstractAgent, P>
extends Probe<A> {
    private final HashMap<A, P> properties = new HashMap();
    private final String fieldName;

    public PropertyProbe(String string, String string2, String string3) {
        this(Kernel.DEFAULT_COMMUNITY, string, string2, string3);
    }

    public PropertyProbe(String string, String string2, String string3, String string4) {
        super(string, string2, string3);
        this.fieldName = string4;
    }

    public void initialize() {
        this.findFields();
    }

    public void update(AbstractAgent abstractAgent, boolean bl) {
        if (bl) {
            this.findFieldOfAgent(abstractAgent);
        } else {
            this.properties.remove(abstractAgent);
        }
    }

    private final void findFields() {
        for (AbstractAgent abstractAgent : this.getCurrentAgentsList()) {
            this.findFieldOfAgent(abstractAgent);
        }
    }

    private void findFieldOfAgent(A a) {
        try {
            this.properties.put(a, a.getClass().getField(this.fieldName).get(a));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            System.err.println("Can't find property: " + this.fieldName + " on " + a.toString() + noSuchFieldException);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
    }

    public Map<A, P> getMapping() {
        return this.properties;
    }

    public P getPropertyOf(A a) {
        return this.properties.get(a);
    }

    public Collection<P> getAllProperties() {
        return this.properties.values();
    }
}

