/*
 * Decompiled with CFR 0.152.
 */
package madkit.simulation.activators;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Activator;
import madkit.kernel.Kernel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OneValueArgsMethodActivator
extends Activator<AbstractAgent> {
    private String methodName;
    private Map<AbstractAgent, Method> methods = new HashMap<AbstractAgent, Method>();
    private Class<?>[] argsClass;

    public OneValueArgsMethodActivator(String string, String string2, String string3, Class<?>[] classArray) {
        this(Kernel.DEFAULT_COMMUNITY, string, string2, string3, classArray);
    }

    public OneValueArgsMethodActivator(String string, String string2, String string3, String string4, Class<?>[] classArray) {
        super(string, string2, string3);
        this.methodName = string4;
        this.argsClass = classArray;
    }

    public synchronized void initialize() {
        this.findMethods(this.methodName, this.argsClass);
    }

    protected void findMethods(String string, Class<?>[] classArray) {
        for (AbstractAgent abstractAgent : this.getCurrentAgentsList()) {
            try {
                this.methods.put(abstractAgent, abstractAgent.getClass().getMethod(string, this.argsClass));
            }
            catch (Exception exception) {
                System.err.println("Can't find method: " + string + " on " + abstractAgent + " " + exception);
            }
        }
    }

    public synchronized void update(AbstractAgent abstractAgent, boolean bl) {
        if (bl) {
            this.updateFieldFor(abstractAgent);
        } else {
            this.methods.remove(abstractAgent);
        }
    }

    public synchronized void updateFieldFor(AbstractAgent abstractAgent) {
        try {
            this.methods.put(abstractAgent, abstractAgent.getClass().getMethod(this.methodName, this.argsClass));
        }
        catch (Exception exception) {
            System.err.println("Can't find method: " + this.methodName + " on " + abstractAgent.toString() + " " + exception);
        }
    }

    public synchronized Object[] execute(Object[] objectArray) {
        Object[] objectArray2 = new Object[this.methods.size()];
        int n = 0;
        for (Map.Entry<AbstractAgent, Method> entry : this.methods.entrySet()) {
            try {
                objectArray2[n] = entry.getValue().invoke((Object)entry.getKey(), objectArray);
            }
            catch (Exception exception) {
                System.err.println("Can't invoke:" + entry.getValue().toString() + " on " + entry.getKey().toString() + " " + exception.toString());
            }
        }
        return objectArray2;
    }
}

