/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.python.core.ucnhashAPI;

public class ucnhash
implements ucnhashAPI {
    private static int n;
    private static int m;
    private static int minchar;
    private static int maxchar;
    private static int alphasz;
    private static int maxlen;
    private static int maxidx;
    private static int maxklen;
    private static short[] G;
    private static short[] T0;
    private static short[] T1;
    private static short[] T2;
    private static byte[] worddata;
    private static short[] wordoffs;
    private static short wordstart;
    private static short wordcutoff;
    private static byte[] rawdata;
    private static char[] rawindex;
    private static char[] codepoint;
    public static String[] __depends__;
    private static final char[] charmap;
    private static String cjkPrefix;
    private static int cjkPrefixLen;
    private static boolean initialized;
    private static boolean loaded;
    private static boolean debug;
    private static /* synthetic */ Class class$Lorg$python$modules$ucnhash;

    public static void loadTables() throws Exception {
        InputStream inputStream = (class$Lorg$python$modules$ucnhash != null ? class$Lorg$python$modules$ucnhash : (class$Lorg$python$modules$ucnhash = ucnhash.class$("org.python.modules.ucnhash"))).getResourceAsStream("ucnhash.dat");
        if (inputStream == null) {
            throw new IOException("Unicode name database not found: ucnhash.dat");
        }
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
        n = dataInputStream.readShort();
        m = dataInputStream.readShort();
        minchar = dataInputStream.readShort();
        maxchar = dataInputStream.readShort();
        alphasz = dataInputStream.readShort();
        maxlen = dataInputStream.readShort();
        maxidx = maxlen * alphasz - minchar;
        G = ucnhash.readShortTable(dataInputStream);
        if (dataInputStream.readShort() != 3) {
            throw new IOException("UnicodeNameMap file corrupt, unknown dimension");
        }
        T0 = ucnhash.readShortTable(dataInputStream);
        T1 = ucnhash.readShortTable(dataInputStream);
        T2 = ucnhash.readShortTable(dataInputStream);
        wordoffs = ucnhash.readShortTable(dataInputStream);
        worddata = ucnhash.readByteTable(dataInputStream);
        wordstart = dataInputStream.readShort();
        wordcutoff = dataInputStream.readShort();
        maxklen = dataInputStream.readShort();
        rawdata = ucnhash.readByteTable(dataInputStream);
        rawindex = ucnhash.readCharTable(dataInputStream);
        codepoint = ucnhash.readCharTable(dataInputStream);
    }

    private static short[] readShortTable(DataInputStream dataInputStream) throws IOException {
        if (dataInputStream.read() != 116) {
            throw new IOException("UnicodeNameMap file corrupt, shorttable");
        }
        int n = dataInputStream.readUnsignedShort() / 2;
        short[] sArray = new short[n];
        int n2 = 0;
        while (n2 < n) {
            sArray[n2] = dataInputStream.readShort();
            ++n2;
        }
        return sArray;
    }

    private static char[] readCharTable(DataInputStream dataInputStream) throws IOException {
        if (dataInputStream.read() != 116) {
            throw new IOException("UnicodeNameMap file corrupt, chartable");
        }
        int n = dataInputStream.readUnsignedShort() / 2;
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = dataInputStream.readChar();
            ++n2;
        }
        return cArray;
    }

    private static byte[] readByteTable(DataInputStream dataInputStream) throws IOException {
        if (dataInputStream.read() != 116) {
            throw new IOException("UnicodeNameMap file corrupt, byte table");
        }
        int n = dataInputStream.readUnsignedShort();
        byte[] byArray = new byte[n];
        dataInputStream.readFully(byArray);
        return byArray;
    }

    public static int hash(String string) {
        return ucnhash.hash(string, 0, string.length());
    }

    public static int hash(String string, int n, int n2) {
        int n3 = n;
        int n4 = -minchar;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n3 < n2) {
            char c = string.charAt(n3);
            if (c >= 'a' && c <= 'z') {
                c = (char)(c - 97 + 65);
            }
            n7 += T0[n4 + c];
            n6 += T1[n4 + c];
            n5 += T2[n4 + c];
            if ((n4 += alphasz) >= maxidx) {
                n4 = -minchar;
            }
            ++n3;
        }
        return (G[n7 %= ucnhash.n] + G[n6 %= ucnhash.n] + G[n5 %= ucnhash.n]) % m;
    }

    private static String getWord(int n) {
        int n2 = wordoffs[n];
        int n3 = worddata.length;
        if (n < wordoffs.length - 1) {
            n3 = wordoffs[n + 1];
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = n2;
        while (n4 < n3) {
            stringBuffer.append(charmap[worddata[n4]]);
            ++n4;
        }
        return stringBuffer.toString();
    }

    private static boolean match(int n, byte[] byArray, int n2, int n3) {
        short s = wordoffs[n];
        int n4 = worddata.length;
        if (n < wordoffs.length - 1) {
            n4 = wordoffs[n + 1];
        }
        if (n3 - n2 != n4 - s) {
            return false;
        }
        int n5 = n3 - n2;
        int n6 = 0;
        while (n6 < n5) {
            if (worddata[s + n6] != byArray[n2 + n6]) {
                return false;
            }
            ++n6;
        }
        return true;
    }

    private static int compare(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        int n5 = 0;
        while (n5 < n2 && n5 < n4) {
            int n6 = (byArray[n + n5] & 0xFF) - (byArray2[n3 + n5] & 0xFF);
            if (n6 != 0) {
                return n6;
            }
            ++n5;
        }
        return n2 - n4;
    }

    private static int binarysearch(byte[] byArray, int n, int n2) {
        int n3;
        int n4;
        int n5 = 0;
        int n6 = rawindex.length / 5;
        while (n5 < n6 - 1) {
            int n7;
            int n8;
            n4 = (n5 + n6) / 2;
            if (debug) {
                System.out.println("floor:" + n5 + " ceiling:" + n6 + " => " + n4);
            }
            if ((n8 = ucnhash.compare(byArray, n, n2 - n, rawdata, n3 = rawindex[n4 * 5], n7 = rawindex[n4 * 5 + 4] & 0x1F)) < 0) {
                n6 = n4;
                continue;
            }
            if (n8 > 0) {
                n5 = n4;
                continue;
            }
            return n4 * 12;
        }
        n4 = n5 * 5;
        n3 = rawindex[n4++];
        long l = (long)rawindex[n4++] << 48 | (long)rawindex[n4++] << 32 | (long)rawindex[n4++] << 16 | (long)rawindex[n4++];
        n5 *= 12;
        int n9 = 0;
        while (n9 < 12) {
            int n10 = (int)(l >> n9 * 5) & 0x1F;
            if (ucnhash.compare(byArray, n, n2, rawdata, n3, n10) == 0) {
                return n5;
            }
            n3 += n10;
            ++n5;
            ++n9;
        }
        return -1;
    }

    public static int lookup(String string) {
        return ucnhash.lookup(string, 0, string.length());
    }

    private static int lookup(String string, int n, int n2) {
        int n3;
        byte[] byArray = new byte[32];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (true) {
            int n7;
            int n8;
            n5 = n4;
            n3 = n;
            int n9 = n;
            while (n9 < n2) {
                n8 = string.charAt(n9);
                if (n8 == 32) {
                    n = n9 + 1;
                    break;
                }
                if (n8 >= 97 && n8 <= 122) {
                    n8 = (char)(n8 - 97 + 65);
                }
                if (n8 >= 65 && n8 <= 90) {
                    n7 = n8 - 65 + 1;
                } else if (n8 >= 48 && n8 <= 57) {
                    n7 = n8 - 48 + 27;
                } else if (n8 == 45) {
                    n7 = 37;
                } else {
                    return -1;
                }
                byArray[n4++] = (byte)n7;
                if (n8 == 45 && n != n9) {
                    n = ++n9;
                    break;
                }
                ++n9;
            }
            n8 = ucnhash.hash(string, n3, n9);
            if (debug) {
                System.out.println(string.substring(n3, n9) + " " + n8);
            }
            int n10 = n7 = n8 < 0 || n4 - n5 <= 1 || !ucnhash.match(n8, byArray, n5, n4) ? 0 : 1;
            if (n7 != 0) {
                if (debug) {
                    System.out.println("match " + ucnhash.getWord(n8));
                }
                n4 = n6;
                if ((n8 += wordstart) > wordcutoff) {
                    byArray[n4++] = (byte)((n8 >> 8) + wordcutoff);
                    byArray[n4++] = (byte)(n8 & 0xFF);
                } else {
                    byArray[n4++] = (byte)n8;
                }
            }
            n6 = n4;
            if (n9 >= n2) break;
            if (n7 != 0) continue;
            byArray[n4++] = 0;
        }
        if (debug) {
            System.out.print("rawdata: ");
            n3 = 0;
            while (n3 < n4) {
                System.out.print((byArray[n3] & 0xFF) + " ");
                ++n3;
            }
            System.out.println();
        }
        if ((n3 = ucnhash.binarysearch(byArray, 0, n4)) < 0) {
            return n3;
        }
        if (debug) {
            System.out.println("idx:" + n3);
            System.out.println("codepoint:" + codepoint[n3] + " " + Integer.toHexString(codepoint[n3]));
        }
        return codepoint[n3];
    }

    public int getCchMax() {
        if (!this.initialized()) {
            return -1;
        }
        return maxklen;
    }

    public int getValue(String string, int n, int n2) {
        if (!this.initialized()) {
            return -1;
        }
        if (string.regionMatches(n, cjkPrefix, 0, cjkPrefixLen)) {
            try {
                String string2 = string.substring(n + cjkPrefixLen, n2);
                int n3 = Integer.parseInt(string2, 16);
                return n3;
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        }
        return ucnhash.lookup(string, n, n2);
    }

    private synchronized boolean initialized() {
        if (initialized && loaded) {
            return true;
        }
        if (initialized) {
            return false;
        }
        try {
            ucnhash.loadTables();
            loaded = true;
        }
        catch (Exception exception) {
            return false;
        }
        initialized = true;
        return true;
    }

    public static void main(String[] stringArray) throws Exception {
        ucnhash.loadTables();
        debug = true;
        System.out.println(ucnhash.lookup("BACKSPACE"));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        __depends__ = new String[]{"/org/python/modules/ucnhash.dat"};
        charmap = " ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-".toCharArray();
        cjkPrefix = "CJK COMPATIBILITY IDEOGRAPH-";
        cjkPrefixLen = cjkPrefix.length();
        initialized = false;
        loaded = false;
        debug = false;
    }
}

