/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.python.core.Py;
import org.python.core.PyClass;
import org.python.core.PyComplex;
import org.python.core.PyException;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyString;
import org.python.core.PyTuple;

public class PyLong
extends PyObject {
    private static final BigInteger minLong = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigInteger maxLong = BigInteger.valueOf(Long.MAX_VALUE);
    private static final BigInteger minDouble = new BigDecimal(Double.MIN_VALUE).toBigInteger();
    private static final BigInteger maxDouble = new BigDecimal(Double.MAX_VALUE).toBigInteger();
    public static PyClass __class__;
    private BigInteger value;
    private static /* synthetic */ Class class$Ljava$lang$Byte;
    private static /* synthetic */ Class class$Ljava$lang$Short;
    private static /* synthetic */ Class class$Ljava$lang$Integer;
    private static /* synthetic */ Class class$Ljava$lang$Long;
    private static /* synthetic */ Class class$Ljava$lang$Float;
    private static /* synthetic */ Class class$Ljava$lang$Double;
    private static /* synthetic */ Class class$Ljava$math$BigInteger;
    private static /* synthetic */ Class class$Ljava$lang$Number;
    private static /* synthetic */ Class class$Ljava$lang$Object;
    private static /* synthetic */ Class class$Ljava$io$Serializable;

    public String toString() {
        return this.value.toString() + "L";
    }

    public int hashCode() {
        return this.value.intValue();
    }

    public boolean __nonzero__() {
        return !this.value.equals(BigInteger.valueOf(0L));
    }

    public double doubleValue() {
        double d = this.value.doubleValue();
        if (d == Double.NEGATIVE_INFINITY || d == Double.POSITIVE_INFINITY) {
            throw Py.OverflowError("long int too long to convert");
        }
        return d;
    }

    private long getLong(long l, long l2) {
        long l3;
        if (this.value.compareTo(maxLong) <= 0 && this.value.compareTo(minLong) >= 0 && (l3 = this.value.longValue()) >= l && l3 <= l2) {
            return l3;
        }
        throw Py.OverflowError("long int too long to convert");
    }

    public Object __tojava__(Class clazz) {
        try {
            if (clazz == Byte.TYPE || clazz == (class$Ljava$lang$Byte != null ? class$Ljava$lang$Byte : (class$Ljava$lang$Byte = PyLong.class$("java.lang.Byte")))) {
                return new Byte((byte)this.getLong(-128L, 127L));
            }
            if (clazz == Short.TYPE || clazz == (class$Ljava$lang$Short != null ? class$Ljava$lang$Short : (class$Ljava$lang$Short = PyLong.class$("java.lang.Short")))) {
                return new Short((short)this.getLong(-32768L, 32767L));
            }
            if (clazz == Integer.TYPE || clazz == (class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = PyLong.class$("java.lang.Integer")))) {
                return new Integer((int)this.getLong(Integer.MIN_VALUE, Integer.MAX_VALUE));
            }
            if (clazz == Long.TYPE || clazz == (class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = PyLong.class$("java.lang.Long")))) {
                return new Long(this.getLong(Long.MIN_VALUE, Long.MAX_VALUE));
            }
            if (clazz == Float.TYPE || clazz == Double.TYPE || clazz == (class$Ljava$lang$Float != null ? class$Ljava$lang$Float : (class$Ljava$lang$Float = PyLong.class$("java.lang.Float"))) || clazz == (class$Ljava$lang$Double != null ? class$Ljava$lang$Double : (class$Ljava$lang$Double = PyLong.class$("java.lang.Double")))) {
                return this.__float__().__tojava__(clazz);
            }
            if (clazz == (class$Ljava$math$BigInteger != null ? class$Ljava$math$BigInteger : (class$Ljava$math$BigInteger = PyLong.class$("java.math.BigInteger"))) || clazz == (class$Ljava$lang$Number != null ? class$Ljava$lang$Number : (class$Ljava$lang$Number = PyLong.class$("java.lang.Number"))) || clazz == (class$Ljava$lang$Object != null ? class$Ljava$lang$Object : (class$Ljava$lang$Object = PyLong.class$("java.lang.Object"))) || clazz == (class$Ljava$io$Serializable != null ? class$Ljava$io$Serializable : (class$Ljava$io$Serializable = PyLong.class$("java.io.Serializable")))) {
                return this.value;
            }
        }
        catch (PyException pyException) {
            return Py.NoConversion;
        }
        return super.__tojava__(clazz);
    }

    public int __cmp__(PyObject pyObject) {
        return this.value.compareTo(((PyLong)pyObject).value);
    }

    public Object __coerce_ex__(PyObject pyObject) {
        if (pyObject instanceof PyLong) {
            return pyObject;
        }
        if (pyObject instanceof PyInteger) {
            return new PyLong(((PyInteger)pyObject).getValue());
        }
        return Py.None;
    }

    private static final boolean canCoerce(PyObject pyObject) {
        return pyObject instanceof PyLong || pyObject instanceof PyInteger;
    }

    private static final BigInteger coerce(PyObject pyObject) {
        if (pyObject instanceof PyLong) {
            return ((PyLong)pyObject).value;
        }
        if (pyObject instanceof PyInteger) {
            return BigInteger.valueOf(((PyInteger)pyObject).getValue());
        }
        throw Py.TypeError("xxx");
    }

    public PyObject __add__(PyObject pyObject) {
        if (!PyLong.canCoerce(pyObject)) {
            return null;
        }
        return new PyLong(this.value.add(PyLong.coerce(pyObject)));
    }

    public PyObject __radd__(PyObject pyObject) {
        return this.__add__(pyObject);
    }

    public PyObject __sub__(PyObject pyObject) {
        if (!PyLong.canCoerce(pyObject)) {
            return null;
        }
        return new PyLong(this.value.subtract(PyLong.coerce(pyObject)));
    }

    public PyObject __rsub__(PyObject pyObject) {
        return new PyLong(PyLong.coerce(pyObject).subtract(this.value));
    }

    public PyObject __mul__(PyObject pyObject) {
        if (pyObject instanceof PySequence) {
            return ((PySequence)pyObject).repeat(PyLong.coerceInt(this));
        }
        if (!PyLong.canCoerce(pyObject)) {
            return null;
        }
        return new PyLong(this.value.multiply(PyLong.coerce(pyObject)));
    }

    public PyObject __rmul__(PyObject pyObject) {
        if (pyObject instanceof PySequence) {
            return ((PySequence)pyObject).repeat(PyLong.coerceInt(this));
        }
        if (!PyLong.canCoerce(pyObject)) {
            return null;
        }
        return new PyLong(PyLong.coerce(pyObject).multiply(this.value));
    }

    private BigInteger divide(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = BigInteger.valueOf(0L);
        if (bigInteger2.equals(bigInteger3)) {
            throw Py.ZeroDivisionError("long division or modulo");
        }
        if (bigInteger2.compareTo(bigInteger3) < 0) {
            if (bigInteger.compareTo(bigInteger3) > 0) {
                return bigInteger.subtract(bigInteger2).subtract(BigInteger.valueOf(1L)).divide(bigInteger2);
            }
        } else if (bigInteger.compareTo(bigInteger3) < 0) {
            return bigInteger.subtract(bigInteger2).add(BigInteger.valueOf(1L)).divide(bigInteger2);
        }
        return bigInteger.divide(bigInteger2);
    }

    public PyObject __div__(PyObject pyObject) {
        if (!PyLong.canCoerce(pyObject)) {
            return null;
        }
        return new PyLong(this.divide(this.value, PyLong.coerce(pyObject)));
    }

    public PyObject __rdiv__(PyObject pyObject) {
        if (!PyLong.canCoerce(pyObject)) {
            return null;
        }
        return new PyLong(this.divide(PyLong.coerce(pyObject), this.value));
    }

    private BigInteger modulo(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        return bigInteger.subtract(bigInteger3.multiply(bigInteger2));
    }

    public PyObject __mod__(PyObject pyObject) {
        if (!PyLong.canCoerce(pyObject)) {
            return null;
        }
        BigInteger bigInteger = PyLong.coerce(pyObject);
        return new PyLong(this.modulo(this.value, bigInteger, this.divide(this.value, bigInteger)));
    }

    public PyObject __rmod__(PyObject pyObject) {
        if (!PyLong.canCoerce(pyObject)) {
            return null;
        }
        BigInteger bigInteger = PyLong.coerce(pyObject);
        return new PyLong(this.modulo(bigInteger, this.value, this.divide(bigInteger, this.value)));
    }

    public PyObject __divmod__(PyObject pyObject) {
        if (!PyLong.canCoerce(pyObject)) {
            return null;
        }
        BigInteger bigInteger = PyLong.coerce(pyObject);
        BigInteger bigInteger2 = this.divide(this.value, bigInteger);
        return new PyTuple(new PyObject[]{new PyLong(bigInteger2), new PyLong(this.modulo(this.value, bigInteger, bigInteger2))});
    }

    public PyObject __rdivmod__(PyObject pyObject) {
        if (!PyLong.canCoerce(pyObject)) {
            return null;
        }
        BigInteger bigInteger = PyLong.coerce(pyObject);
        BigInteger bigInteger2 = this.divide(bigInteger, this.value);
        return new PyTuple(new PyObject[]{new PyLong(bigInteger2), new PyLong(this.modulo(bigInteger, this.value, bigInteger2))});
    }

    public PyObject __pow__(PyObject pyObject, PyObject pyObject2) {
        if (!PyLong.canCoerce(pyObject)) {
            return null;
        }
        if (pyObject2 != null && !PyLong.canCoerce(pyObject)) {
            return null;
        }
        return PyLong._pow(this.value, PyLong.coerce(pyObject), pyObject2);
    }

    public PyObject __rpow__(PyObject pyObject) {
        if (!PyLong.canCoerce(pyObject)) {
            return null;
        }
        return PyLong._pow(PyLong.coerce(pyObject), this.value, null);
    }

    public static PyLong _pow(BigInteger bigInteger, BigInteger bigInteger2, PyObject pyObject) {
        if (bigInteger2.compareTo(BigInteger.valueOf(0L)) < 0) {
            if (bigInteger.compareTo(BigInteger.valueOf(0L)) != 0) {
                throw Py.ValueError("long integer to a negative power");
            }
            throw Py.ZeroDivisionError("zero to a negative power");
        }
        if (pyObject == null) {
            return new PyLong(bigInteger.pow(bigInteger2.intValue()));
        }
        BigInteger bigInteger3 = PyLong.coerce(pyObject);
        int n = bigInteger3.intValue();
        if (n == 0) {
            throw Py.ValueError("pow(x, y, z) with z == 0");
        }
        if (n == 1 || n == -1) {
            return new PyLong(0L);
        }
        if (bigInteger3.compareTo(BigInteger.valueOf(0L)) <= 0) {
            if ((bigInteger2 = bigInteger.modPow(bigInteger2, bigInteger3.negate())).compareTo(BigInteger.valueOf(0L)) > 0) {
                return new PyLong(bigInteger3.add(bigInteger2));
            }
            return new PyLong(bigInteger2);
        }
        return new PyLong(bigInteger.modPow(bigInteger2, bigInteger3));
    }

    private static final int coerceInt(PyObject pyObject) {
        if (pyObject instanceof PyLong) {
            return (int)((PyLong)pyObject).getLong(Integer.MIN_VALUE, Integer.MAX_VALUE);
        }
        if (pyObject instanceof PyInteger) {
            return ((PyInteger)pyObject).getValue();
        }
        throw Py.TypeError("xxx");
    }

    public PyObject __lshift__(PyObject pyObject) {
        if (!PyLong.canCoerce(pyObject)) {
            return null;
        }
        return new PyLong(this.value.shiftLeft(PyLong.coerceInt(pyObject)));
    }

    public PyObject __rshift__(PyObject pyObject) {
        if (!PyLong.canCoerce(pyObject)) {
            return null;
        }
        return new PyLong(this.value.shiftRight(PyLong.coerceInt(pyObject)));
    }

    public PyObject __and__(PyObject pyObject) {
        if (!PyLong.canCoerce(pyObject)) {
            return null;
        }
        return new PyLong(this.value.and(PyLong.coerce(pyObject)));
    }

    public PyObject __xor__(PyObject pyObject) {
        if (!PyLong.canCoerce(pyObject)) {
            return null;
        }
        return new PyLong(this.value.xor(PyLong.coerce(pyObject)));
    }

    public PyObject __or__(PyObject pyObject) {
        if (!PyLong.canCoerce(pyObject)) {
            return null;
        }
        return new PyLong(this.value.or(PyLong.coerce(pyObject)));
    }

    public PyObject __neg__() {
        return new PyLong(this.value.negate());
    }

    public PyObject __pos__() {
        return this;
    }

    public PyObject __abs__() {
        return new PyLong(this.value.abs());
    }

    public PyObject __invert__() {
        return new PyLong(this.value.not());
    }

    public PyInteger __int__() {
        return new PyInteger((int)this.getLong(Integer.MIN_VALUE, Integer.MAX_VALUE));
    }

    public PyLong __long__() {
        return this;
    }

    public PyFloat __float__() {
        return new PyFloat(this.doubleValue());
    }

    public PyComplex __complex__() {
        return new PyComplex(this.doubleValue(), 0.0);
    }

    public PyString __oct__() {
        String string = this.value.toString(8);
        if (string.startsWith("-")) {
            return new PyString("-0" + string.substring(1, string.length()) + "L");
        }
        if (string.startsWith("0")) {
            return new PyString(string + "L");
        }
        return new PyString("0" + string + "L");
    }

    public PyString __hex__() {
        String string = this.value.toString(16).toUpperCase();
        if (string.startsWith("-")) {
            return new PyString("-0x" + string.substring(1, string.length()) + "L");
        }
        return new PyString("0x" + string + "L");
    }

    public PyString __str__() {
        return Py.newString(this.value.toString());
    }

    public boolean isMappingType() {
        return false;
    }

    public boolean isSequenceType() {
        return false;
    }

    protected PyClass getPyClass() {
        return __class__;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public PyLong(BigInteger bigInteger) {
        this.value = bigInteger;
    }

    public PyLong(double d) {
        this(new BigDecimal(d).toBigInteger());
    }

    public PyLong(long l) {
        this(BigInteger.valueOf(l));
    }

    public PyLong(String string) {
        this(new BigInteger(string));
    }
}

