/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.tabbedpanel.theme;

import java.awt.Component;
import java.awt.Insets;
import java.awt.Polygon;
import javax.swing.border.Border;
import net.infonode.gui.HighlightPainter;
import net.infonode.gui.InsetsUtil;
import net.infonode.gui.colorprovider.BackgroundPainterColorProvider;
import net.infonode.gui.colorprovider.ColorBlender;
import net.infonode.gui.colorprovider.ColorMultiplier;
import net.infonode.gui.colorprovider.ColorProvider;
import net.infonode.gui.colorprovider.UIManagerColorProvider;
import net.infonode.gui.componentpainter.GradientComponentPainter;
import net.infonode.tabbedpanel.Tab;
import net.infonode.tabbedpanel.TabbedPanelProperties;
import net.infonode.tabbedpanel.TabbedUtils;
import net.infonode.tabbedpanel.border.OpenContentBorder;
import net.infonode.tabbedpanel.internal.SlopedTabLineBorder;
import net.infonode.tabbedpanel.theme.TabbedPanelTitledTabTheme;
import net.infonode.tabbedpanel.titledtab.TitledTabBorderSizePolicy;
import net.infonode.tabbedpanel.titledtab.TitledTabProperties;
import net.infonode.tabbedpanel.titledtab.TitledTabStateProperties;

public class ShapedGradientTheme
extends TabbedPanelTitledTabTheme {
    private static final int CORNER_INSET = 3;
    private ColorProvider highlightColor;
    private ColorProvider lineColor;
    private ColorProvider controlColor;
    private ColorProvider darkControlColor;
    private ColorProvider alternateHighlight;
    private int leftSlopeHeight;
    private int rightSlopeHeight;
    private TabbedPanelProperties tabbedPanelProperties = new TabbedPanelProperties();
    private TitledTabProperties titledTabProperties = new TitledTabProperties();

    public ShapedGradientTheme() {
        this(0.0f, 0.5f);
    }

    public ShapedGradientTheme(float f, float f2) {
        this(f, f2, UIManagerColorProvider.TABBED_PANE_DARK_SHADOW, UIManagerColorProvider.TABBED_PANE_HIGHLIGHT);
    }

    public ShapedGradientTheme(float f, float f2, ColorProvider colorProvider, ColorProvider colorProvider2) {
        this(f, f2, 25, colorProvider, colorProvider2);
    }

    public ShapedGradientTheme(float f, float f2, int n, ColorProvider colorProvider, ColorProvider colorProvider2) {
        this.leftSlopeHeight = n;
        this.rightSlopeHeight = n;
        this.highlightColor = colorProvider2;
        this.lineColor = colorProvider;
        this.controlColor = UIManagerColorProvider.CONTROL_COLOR;
        this.darkControlColor = UIManagerColorProvider.TABBED_PANE_BACKGROUND;
        this.alternateHighlight = colorProvider2 != null ? new ColorBlender(colorProvider2, this.controlColor, 0.3f) : new ColorMultiplier(this.controlColor, 1.2);
        GradientComponentPainter gradientComponentPainter = new GradientComponentPainter(this.alternateHighlight, this.alternateHighlight, this.controlColor, this.controlColor);
        int n2 = (int)(f * (float)this.leftSlopeHeight);
        int n3 = (int)(f2 * (float)this.rightSlopeHeight);
        int n4 = 2;
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        this.titledTabProperties.setHighlightedRaised(n4).setBorderSizePolicy(TitledTabBorderSizePolicy.EQUAL_SIZE);
        TitledTabStateProperties titledTabStateProperties = this.titledTabProperties.getNormalProperties();
        TitledTabStateProperties titledTabStateProperties2 = this.titledTabProperties.getHighlightedProperties();
        TitledTabStateProperties titledTabStateProperties3 = this.titledTabProperties.getDisabledProperties();
        TabBorder tabBorder = new TabBorder(colorProvider, null, f, f2, this.leftSlopeHeight, this.rightSlopeHeight, false, bl2, bl3, false, true, true, n4);
        TabBorder tabBorder2 = new TabBorder(colorProvider, colorProvider2, f, f2, this.leftSlopeHeight, this.rightSlopeHeight, bl, bl2, bl3, bl4, false, true, n4);
        titledTabStateProperties.getComponentProperties().setBorder(tabBorder).setInsets(new Insets(0, 0, 0, 0));
        titledTabStateProperties2.getComponentProperties().setBorder(tabBorder2);
        ColorMultiplier colorMultiplier = new ColorMultiplier(this.darkControlColor, 1.1);
        ColorMultiplier colorMultiplier2 = new ColorMultiplier(this.darkControlColor, 0.92);
        GradientComponentPainter gradientComponentPainter2 = new GradientComponentPainter(colorMultiplier, colorMultiplier, colorMultiplier2, colorMultiplier2);
        titledTabStateProperties.getShapedPanelProperties().setComponentPainter(gradientComponentPainter2);
        titledTabStateProperties3.getShapedPanelProperties().setComponentPainter(gradientComponentPainter2);
        if (colorProvider2 == null) {
            titledTabStateProperties2.getShapedPanelProperties().setComponentPainter(gradientComponentPainter);
        } else {
            titledTabStateProperties2.getShapedPanelProperties().setComponentPainter(new GradientComponentPainter(colorProvider2, colorProvider2, this.controlColor, this.controlColor));
        }
        Insets insets = tabBorder.getBorderInsets(null);
        int n5 = 1 + insets.left + insets.right - (bl2 ? 3 : 0) - (bl3 ? 3 : 0) - (int)(0.2 * (double)(n2 + n3));
        this.tabbedPanelProperties.setTabSpacing(-n5).setShadowEnabled(false);
        this.tabbedPanelProperties.getTabAreaComponentsProperties().getComponentProperties().setBorder(new SlopedTabLineBorder(colorProvider, colorProvider2, false, 0.0f, 0.0f, 0, 0, false, bl2, bl3, false)).setInsets(new Insets(0, 0, 0, 0));
        this.tabbedPanelProperties.getTabAreaComponentsProperties().getShapedPanelProperties().setComponentPainter(gradientComponentPainter);
        this.tabbedPanelProperties.getContentPanelProperties().getComponentProperties().setBorder(new OpenContentBorder(colorProvider, colorProvider, colorProvider2 == null ? null : new ColorBlender(colorProvider2, BackgroundPainterColorProvider.INSTANCE, HighlightPainter.getBlendFactor(1, 0)), 1));
    }

    public String getName() {
        return "Shaped Gradient Theme";
    }

    public TabbedPanelProperties getTabbedPanelProperties() {
        return this.tabbedPanelProperties;
    }

    public TitledTabProperties getTitledTabProperties() {
        return this.titledTabProperties;
    }

    public ColorProvider getLineColor() {
        return this.lineColor;
    }

    public ColorProvider getHighlightColor() {
        return this.highlightColor;
    }

    public ColorProvider getAlternateHighlightColor() {
        return this.alternateHighlight;
    }

    public ColorProvider getControlColor() {
        return this.controlColor;
    }

    public ColorProvider getDarkControlColor() {
        return this.darkControlColor;
    }

    public Border createTabBorder(ColorProvider colorProvider, ColorProvider colorProvider2, float f, float f2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n) {
        return new TabBorder(colorProvider, colorProvider2, f, f2, 25, 25, bl, bl2, bl3, bl4, bl5, bl6, n);
    }

    private static class TabBorder
    extends SlopedTabLineBorder {
        private boolean bottomLeftRounded;
        private boolean isNormal;
        private boolean hasLeftSlope;
        private int raised;
        private int cornerInset;

        TabBorder(ColorProvider colorProvider, ColorProvider colorProvider2, float f, float f2, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n3) {
            super(colorProvider, colorProvider2, false, f, f2, n, n2, bl5 ? false : bl, bl2, bl3, bl4);
            this.bottomLeftRounded = bl;
            this.isNormal = bl5;
            this.raised = n3;
            this.hasLeftSlope = f > 0.0f;
            this.cornerInset = bl6 ? 3 : 0;
        }

        protected Polygon createPolygon(Component component, int n, int n2) {
            Polygon polygon = super.createPolygon(component, n, n2);
            if (this.isNormal) {
                int n3 = n / 2;
                for (int i = 0; i < polygon.npoints; ++i) {
                    polygon.xpoints[i] = polygon.xpoints[i] < n3 ? polygon.xpoints[i] + this.raised + (this.isFirst(component) ? 0 : this.cornerInset) : polygon.xpoints[i] - this.raised - this.cornerInset;
                }
            }
            return polygon;
        }

        protected Insets getShapedBorderInsets(Component component) {
            Insets insets = super.getShapedBorderInsets(component);
            Insets insets2 = new Insets(0, 0, 0, 1 + this.raised);
            if (this.isNormal && !this.isFirst(component)) {
                insets2.left += this.cornerInset;
            }
            if (!this.isNormal) {
                insets2.right -= this.cornerInset;
            }
            return InsetsUtil.add(insets, insets2);
        }

        private boolean isFirst(Component component) {
            Tab tab;
            if (!this.hasLeftSlope && (tab = TabbedUtils.getParentTab(component)) != null && tab.getTabbedPanel() != null) {
                return tab.getTabbedPanel().getTabAt(0) == tab;
            }
            return false;
        }

        protected boolean isBottomLeftRounded(Component component) {
            return this.isFirst(component) ? false : this.bottomLeftRounded;
        }
    }
}

