/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.tabbedpanel.internal;

import javax.swing.AbstractButton;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.infonode.gui.PopupList;
import net.infonode.gui.PopupListListener;
import net.infonode.gui.TextIconListCellRenderer;
import net.infonode.tabbedpanel.Tab;
import net.infonode.tabbedpanel.TabAdapter;
import net.infonode.tabbedpanel.TabDropDownListVisiblePolicy;
import net.infonode.tabbedpanel.TabEvent;
import net.infonode.tabbedpanel.TabListener;
import net.infonode.tabbedpanel.TabRemovedEvent;
import net.infonode.tabbedpanel.TabbedPanel;

public class TabDropDownList
extends PopupList {
    private TabbedPanel tabbedPanel;
    private TextIconListCellRenderer cellRenderer;
    private TabListener tabListener = new TabAdapter(){

        public void tabAdded(TabEvent tabEvent) {
            if (tabEvent.getTab().getTabbedPanel().getTabCount() == 2) {
                TabDropDownList.this.setVisible(true);
            }
        }

        public void tabRemoved(TabRemovedEvent tabRemovedEvent) {
            if (tabRemovedEvent.getTabbedPanel().getTabCount() == 1) {
                TabDropDownList.this.setVisible(false);
            }
        }
    };

    public TabDropDownList(final TabbedPanel tabbedPanel, AbstractButton abstractButton) {
        super(abstractButton);
        this.tabbedPanel = tabbedPanel;
        this.addPopupListListener(new PopupListListener(){

            public void willBecomeVisible(PopupList popupList) {
                int n = tabbedPanel.getTabCount();
                Object[] objectArray = new Tab[n];
                for (int i = 0; i < n; ++i) {
                    objectArray[i] = tabbedPanel.getTabAt(i);
                }
                TabDropDownList.this.cellRenderer.calculateMaximumIconWidth(objectArray);
                TabDropDownList.this.getList().setListData(objectArray);
                TabDropDownList.this.getList().setSelectedValue(tabbedPanel.getSelectedTab(), true);
            }
        });
        this.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    tabbedPanel.setSelectedTab((Tab)TabDropDownList.this.getList().getSelectedValue());
                }
            }
        });
        if (tabbedPanel.getProperties().getTabDropDownListVisiblePolicy() == TabDropDownListVisiblePolicy.MORE_THAN_ONE_TAB) {
            tabbedPanel.addTabListener(this.tabListener);
            this.setVisible(tabbedPanel.getTabCount() > 1);
        }
        this.cellRenderer = new TextIconListCellRenderer(this.getList().getCellRenderer());
        this.getList().setCellRenderer(this.cellRenderer);
        this.setOpaque(false);
    }

    public void dispose() {
        this.tabbedPanel.removeTabListener(this.tabListener);
    }

    public void updateUI() {
        super.updateUI();
        if (this.cellRenderer != null) {
            this.cellRenderer.setRenderer((ListCellRenderer)UIManager.get("List.cellRenderer"));
        }
    }
}

