/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.tabbedpanel;

import java.awt.BorderLayout;
import java.awt.Shape;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.infonode.gui.draggable.DraggableComponent;
import net.infonode.tabbedpanel.TabDragEvent;
import net.infonode.tabbedpanel.TabEvent;
import net.infonode.tabbedpanel.TabListener;
import net.infonode.tabbedpanel.TabRemovedEvent;
import net.infonode.tabbedpanel.TabStateChangedEvent;
import net.infonode.tabbedpanel.TabbedPanel;
import net.infonode.util.Direction;

public class Tab
extends JPanel {
    private TabbedPanel tabbedPanel;
    private JComponent contentComponent;
    private JComponent focusableComponent;
    private ArrayList listeners;
    private DraggableComponent draggableComponent;
    private KeyListener focusableKeyListener = new KeyAdapter(){

        public void keyPressed(KeyEvent keyEvent) {
            block1: {
                Tab tab;
                if (Tab.this.tabbedPanel == null) break block1;
                Direction direction = Tab.this.tabbedPanel.getProperties().getTabAreaOrientation();
                int n = direction.isHorizontal() ? 40 : 39;
                int n2 = direction.isHorizontal() ? 38 : 37;
                int n3 = Tab.this.tabbedPanel.getTabIndex(Tab.this);
                do {
                    n3 = (n3 + Tab.this.tabbedPanel.getTabCount() + (keyEvent.getKeyCode() == n ? 1 : (keyEvent.getKeyCode() == n2 ? -1 : 0))) % Tab.this.tabbedPanel.getTabCount();
                    tab = Tab.this.tabbedPanel.getTabAt(n3);
                    if (tab != Tab.this) continue;
                    return;
                } while (tab.getFocusableComponent() == null);
                tab.getFocusableComponent().setFocusable(true);
                tab.getFocusableComponent().requestFocusInWindow();
                tab.setSelected(true);
            }
        }
    };
    private TabListener tabbedPanelListener = new TabListener(){

        public void tabAdded(TabEvent tabEvent) {
            if (tabEvent.getTab() == Tab.this) {
                Tab.this.fireAddedEvent();
            }
        }

        public void tabRemoved(TabRemovedEvent tabRemovedEvent) {
            if (tabRemovedEvent.getTab() == Tab.this) {
                tabRemovedEvent.getTabbedPanel().removeTabListener(this);
                Tab.this.fireRemovedEvent(tabRemovedEvent);
            }
        }

        public void tabMoved(TabEvent tabEvent) {
            if (tabEvent.getTab() == Tab.this) {
                Tab.this.fireMovedEvent();
            }
        }

        public void tabDragged(TabDragEvent tabDragEvent) {
            if (tabDragEvent.getTab() == Tab.this) {
                Tab.this.fireDraggedEvent(tabDragEvent);
            }
        }

        public void tabDropped(TabDragEvent tabDragEvent) {
            if (tabDragEvent.getTab() == Tab.this) {
                Tab.this.fireDroppedEvent(tabDragEvent);
            }
        }

        public void tabDragAborted(TabEvent tabEvent) {
            if (tabEvent.getTab() == Tab.this) {
                Tab.this.fireNotDroppedEvent();
            }
        }

        public void tabSelected(TabStateChangedEvent tabStateChangedEvent) {
            if (tabStateChangedEvent.getTab() == Tab.this) {
                Tab.this.fireSelectedEvent(tabStateChangedEvent);
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        if (Tab.access$900(2.access$800(this.this$1)) != null) {
                            Tab.access$900(2.access$800(this.this$1)).setFocusable(true);
                        }
                    }
                });
            }
        }

        public void tabDeselected(TabStateChangedEvent tabStateChangedEvent) {
            if (tabStateChangedEvent.getTab() == Tab.this) {
                Tab.this.fireDeselectedEvent(tabStateChangedEvent);
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        if (Tab.access$900(2.access$800(this.this$1)) != null) {
                            Tab.access$900(2.access$800(this.this$1)).setFocusable(false);
                        }
                    }
                });
            }
        }

        public void tabHighlighted(TabStateChangedEvent tabStateChangedEvent) {
            if (tabStateChangedEvent.getTab() == Tab.this) {
                Tab.this.fireHighlightedEvent(tabStateChangedEvent);
            }
        }

        public void tabDehighlighted(TabStateChangedEvent tabStateChangedEvent) {
            if (tabStateChangedEvent.getPreviousTab() == Tab.this) {
                Tab.this.fireDehighlightedEvent(tabStateChangedEvent);
            }
        }

        static /* synthetic */ Tab access$800(2 var0) {
            return var0.Tab.this;
        }
    };

    public Tab() {
        this((JComponent)null);
    }

    public Tab(JComponent jComponent) {
        super(new BorderLayout());
        this.setOpaque(false);
        this.contentComponent = jComponent;
        this.draggableComponent = new DraggableComponent(this);
    }

    public void addTabListener(TabListener tabListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(2);
        }
        this.listeners.add(tabListener);
    }

    public void removeTabListener(TabListener tabListener) {
        if (this.listeners != null) {
            this.listeners.remove(tabListener);
            if (this.listeners.size() == 0) {
                this.listeners = null;
            }
        }
    }

    public JComponent getContentComponent() {
        return this.contentComponent;
    }

    public TabbedPanel getTabbedPanel() {
        return this.tabbedPanel;
    }

    public void setEnabled(boolean bl) {
        this.getDraggableComponent().setEnabled(bl);
        super.setEnabled(bl);
    }

    public void setSelected(boolean bl) {
        if (bl) {
            this.draggableComponent.select();
        } else if (this.tabbedPanel != null && this.tabbedPanel.getSelectedTab() == this) {
            this.tabbedPanel.setSelectedTab(null);
        }
    }

    public boolean isSelected() {
        return this.tabbedPanel != null ? this.tabbedPanel.getSelectedTab() == this : false;
    }

    public void setHighlighted(boolean bl) {
        if (this.tabbedPanel != null) {
            if (bl) {
                this.tabbedPanel.setHighlightedTab(this);
            } else if (this.tabbedPanel.getHighlightedTab() == this) {
                this.tabbedPanel.setHighlightedTab(null);
            }
        }
    }

    public boolean isHighlighted() {
        return this.tabbedPanel != null ? this.tabbedPanel.getHighlightedTab() == this : false;
    }

    public void setEventComponent(JComponent jComponent) {
        this.setEventComponents(new JComponent[]{jComponent});
    }

    public void setEventComponents(JComponent[] jComponentArray) {
        this.draggableComponent.setEventComponents(jComponentArray);
    }

    public JComponent[] getEventComponents() {
        return this.draggableComponent.getEventComponents();
    }

    public int getIndex() {
        return this.tabbedPanel == null ? -1 : this.tabbedPanel.getTabIndex(this);
    }

    public JComponent getFocusableComponent() {
        return this.focusableComponent;
    }

    public void setFocusableComponent(JComponent jComponent) {
        if (this.focusableComponent != null) {
            this.focusableComponent.removeKeyListener(this.focusableKeyListener);
        }
        this.focusableComponent = jComponent;
        if (this.focusableComponent != null) {
            this.focusableComponent.addKeyListener(this.focusableKeyListener);
        }
    }

    public Shape getShape() {
        return null;
    }

    protected void setTabbedPanel(TabbedPanel tabbedPanel) {
        this.tabbedPanel = tabbedPanel;
        if (this.tabbedPanel != null) {
            this.tabbedPanel.addTabListener(this.tabbedPanelListener);
        }
    }

    DraggableComponent getDraggableComponent() {
        return this.draggableComponent;
    }

    private void fireHighlightedEvent(TabStateChangedEvent tabStateChangedEvent) {
        if (this.listeners != null) {
            TabStateChangedEvent tabStateChangedEvent2 = new TabStateChangedEvent(this, tabStateChangedEvent.getTabbedPanel(), this, tabStateChangedEvent.getPreviousTab(), tabStateChangedEvent.getCurrentTab());
            Object[] objectArray = this.listeners.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ((TabListener)objectArray[i]).tabHighlighted(tabStateChangedEvent2);
            }
        }
    }

    private void fireDehighlightedEvent(TabStateChangedEvent tabStateChangedEvent) {
        if (this.listeners != null) {
            TabStateChangedEvent tabStateChangedEvent2 = new TabStateChangedEvent(this, tabStateChangedEvent.getTabbedPanel(), this, tabStateChangedEvent.getPreviousTab(), tabStateChangedEvent.getCurrentTab());
            Object[] objectArray = this.listeners.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ((TabListener)objectArray[i]).tabDehighlighted(tabStateChangedEvent2);
            }
        }
    }

    private void fireSelectedEvent(TabStateChangedEvent tabStateChangedEvent) {
        if (this.listeners != null) {
            TabStateChangedEvent tabStateChangedEvent2 = new TabStateChangedEvent(this, tabStateChangedEvent.getTabbedPanel(), this, tabStateChangedEvent.getPreviousTab(), tabStateChangedEvent.getCurrentTab());
            Object[] objectArray = this.listeners.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ((TabListener)objectArray[i]).tabSelected(tabStateChangedEvent2);
            }
        }
    }

    private void fireDeselectedEvent(TabStateChangedEvent tabStateChangedEvent) {
        if (this.listeners != null) {
            TabStateChangedEvent tabStateChangedEvent2 = new TabStateChangedEvent(this, tabStateChangedEvent.getTabbedPanel(), this, tabStateChangedEvent.getPreviousTab(), tabStateChangedEvent.getCurrentTab());
            Object[] objectArray = this.listeners.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ((TabListener)objectArray[i]).tabDeselected(tabStateChangedEvent2);
            }
        }
    }

    private void fireDraggedEvent(TabDragEvent tabDragEvent) {
        if (this.listeners != null) {
            TabDragEvent tabDragEvent2 = new TabDragEvent((Object)this, tabDragEvent.getMouseEvent());
            Object[] objectArray = this.listeners.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ((TabListener)objectArray[i]).tabDragged(tabDragEvent2);
            }
        }
    }

    private void fireDroppedEvent(TabDragEvent tabDragEvent) {
        if (this.listeners != null) {
            TabDragEvent tabDragEvent2 = new TabDragEvent(this, this, tabDragEvent.getPoint());
            Object[] objectArray = this.listeners.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ((TabListener)objectArray[i]).tabDropped(tabDragEvent2);
            }
        }
    }

    private void fireNotDroppedEvent() {
        if (this.listeners != null) {
            TabEvent tabEvent = new TabEvent(this, this);
            Object[] objectArray = this.listeners.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ((TabListener)objectArray[i]).tabDragAborted(tabEvent);
            }
        }
    }

    private void fireMovedEvent() {
        if (this.listeners != null) {
            TabEvent tabEvent = new TabEvent(this, this);
            Object[] objectArray = this.listeners.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ((TabListener)objectArray[i]).tabMoved(tabEvent);
            }
        }
    }

    private void fireAddedEvent() {
        if (this.listeners != null) {
            TabEvent tabEvent = new TabEvent(this, this);
            Object[] objectArray = this.listeners.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ((TabListener)objectArray[i]).tabAdded(tabEvent);
            }
        }
    }

    private void fireRemovedEvent(TabRemovedEvent tabRemovedEvent) {
        if (this.listeners != null) {
            TabRemovedEvent tabRemovedEvent2 = new TabRemovedEvent(this, this, tabRemovedEvent.getTabbedPanel());
            Object[] objectArray = this.listeners.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ((TabListener)objectArray[i]).tabRemoved(tabRemovedEvent2);
            }
        }
    }

    static /* synthetic */ JComponent access$900(Tab tab) {
        return tab.focusableComponent;
    }
}

