/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.properties.propertymap;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.infonode.properties.base.Property;
import net.infonode.properties.base.exception.InvalidPropertyException;
import net.infonode.properties.propertymap.PropertyMap;
import net.infonode.properties.propertymap.PropertyMapGroup;
import net.infonode.properties.propertymap.PropertyMapListener;
import net.infonode.properties.propertymap.PropertyMapManager;
import net.infonode.properties.propertymap.PropertyMapProperty;
import net.infonode.properties.propertymap.PropertyMapTreeListener;
import net.infonode.properties.propertymap.ref.CompositeMapRef;
import net.infonode.properties.propertymap.ref.ParentMapRef;
import net.infonode.properties.propertymap.ref.PropertyMapPropertyRef;
import net.infonode.properties.propertymap.ref.PropertyMapRef;
import net.infonode.properties.propertymap.ref.ThisPropertyMapRef;
import net.infonode.properties.propertymap.value.PropertyRefValue;
import net.infonode.properties.propertymap.value.PropertyValue;
import net.infonode.properties.propertymap.value.ValueDecoder;
import net.infonode.properties.util.PropertyChangeListener;
import net.infonode.properties.util.PropertyPath;
import net.infonode.util.Printer;
import net.infonode.util.Utils;
import net.infonode.util.ValueChange;
import net.infonode.util.collection.map.ConstVectorMap;
import net.infonode.util.collection.map.MapAdapter;
import net.infonode.util.collection.map.SingleValueMap;
import net.infonode.util.collection.map.base.ConstMap;
import net.infonode.util.collection.map.base.ConstMapIterator;
import net.infonode.util.collection.map.base.MapIterator;
import net.infonode.util.collection.notifymap.AbstractConstChangeNotifyMap;
import net.infonode.util.collection.notifymap.ChangeNotifyMapListener;
import net.infonode.util.collection.notifymap.ChangeNotifyMapWrapper;
import net.infonode.util.collection.notifymap.ConstChangeNotifyMap;
import net.infonode.util.collection.notifymap.ConstChangeNotifyVectorMap;

public class PropertyMapImpl
implements PropertyMap {
    private static final int SERIALIZE_VERSION = 1;
    private PropertyMapGroup propertyGroup;
    private PropertyMapImpl parent;
    private PropertyMapProperty property;
    private ChangeNotifyMapWrapper values = new ChangeNotifyMapWrapper(new MapAdapter());
    private ConstChangeNotifyVectorMap superMap = new ConstChangeNotifyVectorMap();
    private ConstVectorMap vectorMap = new ConstVectorMap();
    private PropertyObjectMap map = new PropertyObjectMap();
    private ArrayList superMaps = new ArrayList(1);
    private MapAdapter childMaps = new MapAdapter();
    private HashMap propertyChangeListeners;
    private ArrayList listeners;
    private ArrayList treeListeners;
    private ChangeNotifyMapListener mapListener;

    public PropertyMapImpl(PropertyMapGroup propertyMapGroup) {
        this(propertyMapGroup, null);
    }

    public PropertyMapImpl(PropertyMapImpl propertyMapImpl) {
        this(propertyMapImpl.getPropertyGroup(), propertyMapImpl);
    }

    public PropertyMapImpl(PropertyMapGroup propertyMapGroup, PropertyMapImpl propertyMapImpl) {
        this(propertyMapGroup, null, null);
        if (propertyMapImpl != null) {
            this.addSuperMap(propertyMapImpl);
        }
    }

    public PropertyMapImpl(PropertyMapImpl propertyMapImpl, PropertyMapProperty propertyMapProperty) {
        this(propertyMapProperty.getPropertyMapGroup(), propertyMapImpl, propertyMapProperty);
    }

    public PropertyMapImpl(PropertyMapGroup propertyMapGroup, PropertyMapImpl propertyMapImpl, PropertyMapProperty propertyMapProperty) {
        this.parent = propertyMapImpl;
        this.property = propertyMapProperty;
        this.propertyGroup = propertyMapGroup;
        Property[] propertyArray = this.propertyGroup.getProperties();
        for (int i = 0; i < propertyArray.length; ++i) {
            if (!(propertyArray[i] instanceof PropertyMapProperty)) continue;
            PropertyMapProperty propertyMapProperty2 = (PropertyMapProperty)propertyArray[i];
            PropertyMapImpl propertyMapImpl2 = new PropertyMapImpl(this, propertyMapProperty2);
            this.childMaps.put(propertyMapProperty2, propertyMapImpl2);
        }
        this.vectorMap.addMap(this.values);
        this.vectorMap.addMap(this.superMap);
    }

    private boolean hasTreeListener() {
        return this.treeListeners != null && this.treeListeners.size() > 0 || this.parent != null && this.parent.hasTreeListener();
    }

    private boolean hasListener() {
        return this.hasTreeListener() || this.listeners != null && this.listeners.size() > 0 || this.propertyChangeListeners != null && this.propertyChangeListeners.size() > 0;
    }

    private void updateListenerRecursive() {
        this.updateListener();
        ConstMapIterator constMapIterator = this.childMaps.constIterator();
        while (constMapIterator.atEntry()) {
            ((PropertyMapImpl)constMapIterator.getValue()).updateListenerRecursive();
            constMapIterator.next();
        }
    }

    private void updateListener() {
        if (this.hasListener()) {
            if (this.mapListener == null) {
                this.mapListener = new ChangeNotifyMapListener(){

                    public void entriesChanged(ConstMap constMap) {
                        PropertyMapManager.getInstance().addMapChanges(PropertyMapImpl.this, constMap);
                    }
                };
                this.map.addListener(this.mapListener);
            }
        } else if (this.mapListener != null) {
            this.map.removeListener(this.mapListener);
            this.mapListener = null;
        }
    }

    public ConstChangeNotifyMap getMap() {
        return this.map;
    }

    public PropertyMap getSuperMap() {
        return this.superMaps.size() == 0 ? null : (PropertyMap)this.superMaps.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeValue(Property property) throws InvalidPropertyException {
        this.checkProperty(property);
        PropertyValue propertyValue = (PropertyValue)this.values.get(property);
        if (propertyValue == null || propertyValue.getParent() != null) {
            return null;
        }
        this.values.remove(property);
        PropertyMapManager.getInstance().beginBatch();
        try {
            this.firePropertyValueChanged(property, new ValueChange(propertyValue, this.getValue(property)));
        }
        finally {
            PropertyMapManager.getInstance().endBatch();
        }
        return propertyValue.get(this);
    }

    private PropertyMapRef getPathFrom(PropertyMapImpl propertyMapImpl) {
        if (this.parent == null) {
            return null;
        }
        if (this.parent == propertyMapImpl) {
            return new PropertyMapPropertyRef(this.property);
        }
        PropertyMapRef propertyMapRef = this.parent.getPathFrom(propertyMapImpl);
        return propertyMapRef == null ? null : new CompositeMapRef(propertyMapRef, new PropertyMapPropertyRef(this.property));
    }

    private PropertyMapRef getRelativePathTo(PropertyMapImpl propertyMapImpl) {
        ThisPropertyMapRef thisPropertyMapRef;
        PropertyMapRef propertyMapRef = thisPropertyMapRef = propertyMapImpl == this ? ThisPropertyMapRef.INSTANCE : propertyMapImpl.getPathFrom(this);
        return thisPropertyMapRef == null ? (this.parent == null ? null : new CompositeMapRef(ParentMapRef.INSTANCE, this.parent.getRelativePathTo(propertyMapImpl))) : thisPropertyMapRef;
    }

    public Object createRelativeRef(Property property, PropertyMap propertyMap, Property property2) {
        PropertyValue propertyValue = this.setValue(property, new PropertyRefValue(this, property, this.getRelativePathTo((PropertyMapImpl)propertyMap), property2, null));
        return propertyValue == null ? null : propertyValue.getWithDefault(this);
    }

    public int getSuperMapCount() {
        return this.superMaps.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSuperMap(PropertyMap propertyMap) {
        PropertyMapImpl propertyMapImpl = (PropertyMapImpl)propertyMap;
        PropertyMapManager.getInstance().beginBatch();
        try {
            this.addSuperMap(0, propertyMapImpl);
        }
        finally {
            PropertyMapManager.getInstance().endBatch();
        }
    }

    public PropertyMap removeSuperMap() {
        if (this.superMaps.size() > (this.parent == null ? 0 : this.parent.superMaps.size())) {
            PropertyMapImpl propertyMapImpl = (PropertyMapImpl)this.superMaps.get(0);
            this.removeSuperMap(0);
            return propertyMapImpl;
        }
        return null;
    }

    public boolean removeSuperMap(PropertyMap propertyMap) {
        if (this.superMaps.size() > (this.parent == null ? 0 : this.parent.superMaps.size())) {
            int n = this.superMaps.indexOf(propertyMap);
            if (n == -1) {
                return false;
            }
            this.removeSuperMap(n);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replaceSuperMap(PropertyMap propertyMap, PropertyMap propertyMap2) {
        if (this.superMaps.size() > (this.parent == null ? 0 : this.parent.superMaps.size())) {
            int n = this.superMaps.indexOf(propertyMap);
            if (n == -1) {
                return false;
            }
            PropertyMapManager.getInstance().beginBatch();
            try {
                this.removeSuperMap(n);
                this.addSuperMap(n, (PropertyMapImpl)propertyMap2);
            }
            finally {
                PropertyMapManager.getInstance().endBatch();
            }
            return true;
        }
        return false;
    }

    private void removeParentSuperMap(int n) {
        this.removeSuperMap(this.superMaps.size() - this.parent.superMaps.size() - 1 + n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSuperMap(int n) {
        PropertyMapManager.getInstance().beginBatch();
        try {
            this.superMap.removeMap(n);
            this.superMaps.remove(n);
            ConstMapIterator constMapIterator = this.childMaps.constIterator();
            while (constMapIterator.atEntry()) {
                ((PropertyMapImpl)constMapIterator.getValue()).removeParentSuperMap(n);
                constMapIterator.next();
            }
        }
        finally {
            PropertyMapManager.getInstance().endBatch();
        }
    }

    private void addSuperMap(PropertyMapImpl propertyMapImpl) {
        this.addSuperMap(0, propertyMapImpl);
    }

    private void addParentSuperMap(PropertyMapImpl propertyMapImpl, int n) {
        this.addSuperMap(this.superMaps.size() - this.parent.superMaps.size() + 1 + n, propertyMapImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSuperMap(int n, PropertyMapImpl propertyMapImpl) {
        PropertyMapManager.getInstance().beginBatch();
        try {
            this.superMap.addMap(n, propertyMapImpl.map);
            this.superMaps.add(n, propertyMapImpl);
            ConstMapIterator constMapIterator = this.childMaps.constIterator();
            while (constMapIterator.atEntry()) {
                ((PropertyMapImpl)constMapIterator.getValue()).addParentSuperMap(propertyMapImpl.getChildMapImpl((PropertyMapProperty)constMapIterator.getKey()), n);
                constMapIterator.next();
            }
        }
        finally {
            PropertyMapManager.getInstance().endBatch();
        }
    }

    public void addTreeListener(PropertyMapTreeListener propertyMapTreeListener) {
        if (this.treeListeners == null) {
            this.treeListeners = new ArrayList(2);
        }
        this.treeListeners.add(propertyMapTreeListener);
        this.updateListenerRecursive();
    }

    public void removeTreeListener(PropertyMapTreeListener propertyMapTreeListener) {
        if (this.treeListeners != null) {
            this.treeListeners.remove(propertyMapTreeListener);
            if (this.treeListeners.size() == 0) {
                this.treeListeners = null;
            }
            this.updateListenerRecursive();
        }
    }

    public void addListener(PropertyMapListener propertyMapListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(2);
        }
        this.listeners.add(propertyMapListener);
        this.updateListener();
    }

    public void removeListener(PropertyMapListener propertyMapListener) {
        if (this.listeners != null) {
            this.listeners.remove(propertyMapListener);
            if (this.listeners.size() == 0) {
                this.listeners = null;
            }
        }
        this.updateListener();
    }

    public PropertyMapGroup getPropertyGroup() {
        return this.propertyGroup;
    }

    public void addPropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        ArrayList<PropertyChangeListener> arrayList;
        if (this.propertyChangeListeners == null) {
            this.propertyChangeListeners = new HashMap(4);
        }
        if ((arrayList = (ArrayList<PropertyChangeListener>)this.propertyChangeListeners.get(property)) == null) {
            arrayList = new ArrayList<PropertyChangeListener>(2);
            this.propertyChangeListeners.put(property, arrayList);
        }
        arrayList.add(propertyChangeListener);
        this.updateListener();
    }

    public void removePropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        if (this.propertyChangeListeners != null) {
            ArrayList arrayList = (ArrayList)this.propertyChangeListeners.get(property);
            if (arrayList == null) {
                return;
            }
            arrayList.remove(propertyChangeListener);
            if (arrayList.isEmpty()) {
                this.propertyChangeListeners.remove(property);
                if (this.propertyChangeListeners.isEmpty()) {
                    this.propertyChangeListeners = null;
                }
            }
            this.updateListener();
        }
    }

    public PropertyMapImpl getParent() {
        return this.parent;
    }

    public PropertyMapProperty getProperty() {
        return this.property;
    }

    private void checkProperty(Property property) {
        if (!this.propertyGroup.hasProperty(property)) {
            throw new InvalidPropertyException(property, "Property '" + property + "' not found in object '" + this.propertyGroup + "'!");
        }
    }

    public PropertyMap getChildMap(PropertyMapProperty propertyMapProperty) {
        return this.getChildMapImpl(propertyMapProperty);
    }

    public PropertyMapImpl getChildMapImpl(PropertyMapProperty propertyMapProperty) {
        this.checkProperty(propertyMapProperty);
        return (PropertyMapImpl)this.childMaps.get(propertyMapProperty);
    }

    private PropertyValue getParentDefaultValue(PropertyPath propertyPath) {
        PropertyValue propertyValue = this.parent == null ? null : this.parent.getParentDefaultValue(new PropertyPath(this.property, propertyPath));
        return propertyValue == null ? ((PropertyMapImpl)this.propertyGroup.getDefaultMap()).getValue(propertyPath) : propertyValue;
    }

    public PropertyValue getValueWithDefault(Property property) {
        PropertyValue propertyValue = this.getValue(property);
        return propertyValue == null ? this.getParentDefaultValue(new PropertyPath(property)) : propertyValue;
    }

    private PropertyValue getValue(PropertyPath propertyPath) {
        return propertyPath.getTail() == null ? this.getValue(propertyPath.getProperty()) : this.getChildMapImpl((PropertyMapProperty)propertyPath.getProperty()).getValue(propertyPath.getTail());
    }

    public PropertyValue getValue(Property property) {
        this.checkProperty(property);
        return (PropertyValue)this.map.get(property);
    }

    private PropertyValue internalSetValue(Property property, PropertyValue propertyValue) {
        PropertyValue propertyValue2 = (PropertyValue)(propertyValue == null ? this.values.remove(property) : this.values.put(property, propertyValue));
        if (propertyValue != null) {
            propertyValue.updateListener(this.hasListener());
        }
        if (propertyValue2 != null) {
            propertyValue2.unset();
        }
        return propertyValue2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyValue setValue(Property property, PropertyValue propertyValue) {
        this.checkProperty(property);
        PropertyValue propertyValue2 = this.internalSetValue(property, propertyValue);
        if (!Utils.equals(propertyValue, propertyValue2)) {
            PropertyMapManager.getInstance().beginBatch();
            try {
                this.firePropertyValueChanged(property, new ValueChange(propertyValue2, propertyValue));
            }
            finally {
                PropertyMapManager.getInstance().endBatch();
            }
        }
        return propertyValue2;
    }

    public boolean valueIsSet(Property property) {
        PropertyValue propertyValue = (PropertyValue)this.values.get(property);
        return propertyValue != null && propertyValue.getParent() == null;
    }

    public void firePropertyValueChanged(Property property, ValueChange valueChange) {
        this.map.fireEntriesChanged(new SingleValueMap(property, valueChange));
    }

    protected void firePropertyTreeValuesChanged(Map map) {
        if (this.treeListeners != null) {
            PropertyMapTreeListener[] propertyMapTreeListenerArray = this.treeListeners.toArray(new PropertyMapTreeListener[this.treeListeners.size()]);
            for (int i = 0; i < propertyMapTreeListenerArray.length; ++i) {
                propertyMapTreeListenerArray[i].propertyValuesChanged(map);
            }
        }
    }

    void firePropertyValuesChanged(Map map) {
        PropertyMapListener[] propertyMapListenerArray;
        if (this.listeners != null) {
            propertyMapListenerArray = this.listeners.toArray(new PropertyMapListener[this.listeners.size()]);
            for (int i = 0; i < propertyMapListenerArray.length; ++i) {
                propertyMapListenerArray[i].propertyValuesChanged(this, map);
            }
        }
        if (this.propertyChangeListeners != null) {
            propertyMapListenerArray = map.entrySet().iterator();
            while (propertyMapListenerArray.hasNext()) {
                Map.Entry entry = (Map.Entry)propertyMapListenerArray.next();
                ArrayList arrayList = (ArrayList)this.propertyChangeListeners.get(entry.getKey());
                if (arrayList == null) continue;
                ValueChange valueChange = (ValueChange)entry.getValue();
                PropertyChangeListener[] propertyChangeListenerArray = arrayList.toArray(new PropertyChangeListener[arrayList.size()]);
                for (int i = 0; i < propertyChangeListenerArray.length; ++i) {
                    propertyChangeListenerArray[i].propertyChanged((Property)entry.getKey(), this, valueChange.getOldValue(), valueChange.getNewValue());
                }
            }
        }
    }

    public void dump() {
        this.dump(new Printer(), new HashSet(4));
    }

    public void dump(Printer printer, Set set) {
        set.add(this);
        ConstMapIterator constMapIterator = this.values.constIterator();
        while (constMapIterator.atEntry()) {
            printer.println(constMapIterator.getKey() + " = " + constMapIterator.getValue());
            constMapIterator.next();
        }
        if (!this.values.isEmpty()) {
            printer.println();
        }
        for (int i = 0; i < this.superMaps.size(); ++i) {
            printer.println("Super Object " + (i + 1) + ':');
            printer.beginSection();
            ((PropertyMapImpl)this.superMaps.get(i)).dump(printer, set);
            printer.endSection();
            printer.println();
        }
        ConstMapIterator constMapIterator2 = this.childMaps.constIterator();
        while (constMapIterator2.atEntry()) {
            printer.println(constMapIterator2.getKey() + ":");
            printer.beginSection();
            ((PropertyMapImpl)constMapIterator2.getValue()).dump(printer, set);
            printer.endSection();
            printer.println();
            constMapIterator2.next();
        }
    }

    public void dumpSuperMaps(Printer printer) {
        printer.println(System.identityHashCode(this) + ":" + this);
        for (int i = 0; i < this.superMaps.size(); ++i) {
            if (this.superMap.getMap(i) != ((PropertyMapImpl)this.superMaps.get((int)i)).map) {
                System.out.println("Error!");
            }
            printer.beginSection();
            ((PropertyMapImpl)this.superMaps.get(i)).dumpSuperMaps(printer);
            printer.endSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(boolean bl) {
        PropertyMapManager.getInstance().beginBatch();
        try {
            this.doClear(bl);
        }
        finally {
            PropertyMapManager.getInstance().endBatch();
        }
    }

    private void doClear(boolean bl) {
        ArrayList<Object> arrayList = new ArrayList<Object>(10);
        MapIterator mapIterator = this.values.iterator();
        while (mapIterator.atEntry()) {
            PropertyValue propertyValue = (PropertyValue)mapIterator.getValue();
            if (propertyValue.getParent() == null) {
                arrayList.add(mapIterator.getKey());
            }
            mapIterator.next();
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            this.removeValue((Property)arrayList.get(i));
        }
        if (bl) {
            ConstMapIterator constMapIterator = this.childMaps.constIterator();
            while (constMapIterator.atEntry()) {
                ((PropertyMapImpl)constMapIterator.getValue()).doClear(bl);
                constMapIterator.next();
            }
        }
    }

    public boolean isEmpty(boolean bl) {
        ConstMapIterator constMapIterator = this.values.constIterator();
        while (constMapIterator.atEntry()) {
            PropertyValue propertyValue = (PropertyValue)constMapIterator.getValue();
            if (propertyValue.getParent() == null) {
                return false;
            }
            constMapIterator.next();
        }
        if (bl) {
            constMapIterator = this.childMaps.constIterator();
            while (constMapIterator.atEntry()) {
                if (!((PropertyMapImpl)constMapIterator.getValue()).isEmpty(bl)) {
                    return false;
                }
                constMapIterator.next();
            }
        }
        return true;
    }

    private void doRead(ObjectInputStream objectInputStream) throws IOException {
        Object object;
        while (objectInputStream.readBoolean()) {
            object = objectInputStream.readUTF();
            Property property = this.getPropertyGroup().getProperty((String)object);
            PropertyValue propertyValue = ValueDecoder.decode(objectInputStream, this, property);
            if (property == null || propertyValue == null) continue;
            this.setValue(property, propertyValue);
        }
        while (objectInputStream.readBoolean()) {
            object = (PropertyMapProperty)this.getPropertyGroup().getProperty(objectInputStream.readUTF());
            this.getChildMapImpl((PropertyMapProperty)object).doRead(objectInputStream);
        }
    }

    public void write(ObjectOutputStream objectOutputStream, boolean bl) throws IOException {
        objectOutputStream.writeInt(1);
        this.doWrite(objectOutputStream, bl);
    }

    public void write(ObjectOutputStream objectOutputStream) throws IOException {
        this.write(objectOutputStream, true);
    }

    private void doWrite(ObjectOutputStream objectOutputStream, boolean bl) throws IOException {
        ConstMapIterator constMapIterator = this.values.constIterator();
        while (constMapIterator.atEntry()) {
            PropertyValue propertyValue = (PropertyValue)constMapIterator.getValue();
            if (propertyValue.getParent() == null && propertyValue.isSerializable()) {
                objectOutputStream.writeBoolean(true);
                objectOutputStream.writeUTF(((Property)constMapIterator.getKey()).getName());
                propertyValue.write(objectOutputStream);
            }
            constMapIterator.next();
        }
        objectOutputStream.writeBoolean(false);
        if (bl) {
            constMapIterator = this.childMaps.constIterator();
            while (constMapIterator.atEntry()) {
                if (!((PropertyMapImpl)constMapIterator.getValue()).isEmpty(true)) {
                    objectOutputStream.writeBoolean(true);
                    objectOutputStream.writeUTF(((Property)constMapIterator.getKey()).getName());
                    ((PropertyMapImpl)constMapIterator.getValue()).doWrite(objectOutputStream, bl);
                }
                constMapIterator.next();
            }
        }
        objectOutputStream.writeBoolean(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(ObjectInputStream objectInputStream) throws IOException {
        PropertyMapManager.getInstance().beginBatch();
        try {
            int n = objectInputStream.readInt();
            if (n > 1) {
                throw new IOException("Can't read object because serialized version is newer than current version!");
            }
            this.doRead(objectInputStream);
        }
        finally {
            PropertyMapManager.getInstance().endBatch();
        }
    }

    public static void skip(ObjectInputStream objectInputStream) throws IOException {
        int n = objectInputStream.readInt();
        if (n > 1) {
            throw new IOException("Can't read object because serialized version is newer than current version!");
        }
        PropertyMapImpl.doSkip(objectInputStream);
    }

    private static void doSkip(ObjectInputStream objectInputStream) throws IOException {
        while (objectInputStream.readBoolean()) {
            objectInputStream.readUTF();
            ValueDecoder.skip(objectInputStream);
        }
        while (objectInputStream.readBoolean()) {
            objectInputStream.readUTF();
            PropertyMapImpl.doSkip(objectInputStream);
        }
    }

    private boolean doValuesEqual(PropertyMapImpl propertyMapImpl, boolean bl) {
        Property property;
        ConstMapIterator constMapIterator = this.map.constIterator();
        while (constMapIterator.atEntry()) {
            property = (Property)constMapIterator.getKey();
            if (!Utils.equals(((PropertyValue)constMapIterator.getValue()).get(this), propertyMapImpl.getValue(property).get(this))) {
                return false;
            }
            constMapIterator.next();
        }
        if (bl) {
            constMapIterator = this.childMaps.constIterator();
            while (constMapIterator.atEntry()) {
                property = (PropertyMapProperty)constMapIterator.getKey();
                if (!((PropertyMapImpl)constMapIterator.getValue()).doValuesEqual(propertyMapImpl.getChildMapImpl((PropertyMapProperty)property), bl)) {
                    return false;
                }
                constMapIterator.next();
            }
        }
        return true;
    }

    public boolean valuesEqualTo(PropertyMap propertyMap, boolean bl) {
        return this.doValuesEqual((PropertyMapImpl)propertyMap, bl);
    }

    public PropertyMap copy(boolean bl, boolean bl2) {
        PropertyMapImpl propertyMapImpl = new PropertyMapImpl(this.propertyGroup);
        this.doCopy(propertyMapImpl, bl, bl2, true);
        return propertyMapImpl;
    }

    private void doCopy(PropertyMapImpl propertyMapImpl, boolean bl, boolean bl2, boolean bl3) {
        ConstMapIterator constMapIterator = this.values.constIterator();
        while (constMapIterator.atEntry()) {
            PropertyValue propertyValue = (PropertyValue)constMapIterator.getValue();
            if (propertyValue.getParent() == null) {
                propertyMapImpl.values.put(constMapIterator.getKey(), propertyValue.copyTo(propertyMapImpl));
            }
            constMapIterator.next();
        }
        if (bl) {
            for (int i = 0; i < (bl3 ? this.superMaps.size() : this.superMaps.size() - this.parent.superMaps.size()); ++i) {
                propertyMapImpl.addSuperMap((PropertyMapImpl)this.superMaps.get(i));
            }
        }
        if (bl2) {
            constMapIterator = this.childMaps.constIterator();
            while (constMapIterator.atEntry()) {
                ((PropertyMapImpl)constMapIterator.getValue()).doCopy((PropertyMapImpl)propertyMapImpl.getChildMap((PropertyMapProperty)constMapIterator.getKey()), bl, bl2, false);
                constMapIterator.next();
            }
        }
    }

    private class PropertyObjectMap
    extends AbstractConstChangeNotifyMap {
        private ChangeNotifyMapListener superListener = new ChangeNotifyMapListener(this){
            private final /* synthetic */ PropertyObjectMap this$1;
            {
                this.this$1 = propertyObjectMap;
            }

            public void entriesChanged(ConstMap constMap) {
                MapAdapter mapAdapter = new MapAdapter();
                ConstMapIterator constMapIterator = constMap.constIterator();
                while (constMapIterator.atEntry()) {
                    PropertyValue propertyValue;
                    Property property = (Property)constMapIterator.getKey();
                    if (PropertyMapImpl.access$100(PropertyObjectMap.access$000(this.this$1)).hasProperty(property) && ((propertyValue = (PropertyValue)PropertyMapImpl.access$200(PropertyObjectMap.access$000(this.this$1)).get(property)) == null || propertyValue.getParent() != null)) {
                        ValueChange valueChange = (ValueChange)constMapIterator.getValue();
                        PropertyValue propertyValue2 = (PropertyValue)valueChange.getNewValue();
                        PropertyValue propertyValue3 = propertyValue2 == null ? null : propertyValue2.getSubValue(PropertyObjectMap.access$000(this.this$1));
                        PropertyMapImpl.access$300(PropertyObjectMap.access$000(this.this$1), property, propertyValue3);
                        mapAdapter.put(property, new ValueChange(propertyValue != null ? propertyValue : valueChange.getOldValue(), propertyValue3 != null ? propertyValue3 : valueChange.getNewValue()));
                    }
                    constMapIterator.next();
                }
                this.this$1.fireEntriesChanged(mapAdapter);
            }
        };

        PropertyObjectMap() {
        }

        public void addListener(ChangeNotifyMapListener changeNotifyMapListener) {
            boolean bl = this.hasListeners();
            super.addListener(changeNotifyMapListener);
            if (!bl) {
                this.addInheritedReferences();
                PropertyMapImpl.this.superMap.addListener(this.superListener);
            }
        }

        private void addInheritedReferences() {
            PropertyValue propertyValue;
            Property property;
            ConstMapIterator constMapIterator = PropertyMapImpl.this.values.constIterator();
            while (constMapIterator.atEntry()) {
                property = (Property)constMapIterator.getKey();
                propertyValue = (PropertyValue)PropertyMapImpl.this.values.get(property);
                propertyValue.updateListener(true);
                constMapIterator.next();
            }
            constMapIterator = PropertyMapImpl.this.superMap.constIterator();
            while (constMapIterator.atEntry()) {
                property = (Property)constMapIterator.getKey();
                if (PropertyMapImpl.this.propertyGroup.hasProperty(property) && ((propertyValue = (PropertyValue)PropertyMapImpl.this.values.get(property)) == null || propertyValue.getParent() != null)) {
                    PropertyValue propertyValue2 = (PropertyValue)constMapIterator.getValue();
                    PropertyValue propertyValue3 = propertyValue2 == null ? null : propertyValue2.getSubValue(PropertyMapImpl.this);
                    PropertyMapImpl.this.internalSetValue(property, propertyValue3);
                }
                constMapIterator.next();
            }
        }

        private void removeInheritedReferences() {
            ArrayList<Property> arrayList = new ArrayList<Property>();
            ConstMapIterator constMapIterator = PropertyMapImpl.this.values.constIterator();
            while (constMapIterator.atEntry()) {
                Property property = (Property)constMapIterator.getKey();
                PropertyValue propertyValue = (PropertyValue)PropertyMapImpl.this.values.get(property);
                if (propertyValue.getParent() != null) {
                    propertyValue.unset();
                    arrayList.add(property);
                } else {
                    propertyValue.updateListener(false);
                }
                constMapIterator.next();
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                PropertyMapImpl.this.values.remove(arrayList.get(i));
            }
        }

        public boolean removeListener(ChangeNotifyMapListener changeNotifyMapListener) {
            boolean bl = super.removeListener(changeNotifyMapListener);
            if (bl && !this.hasListeners()) {
                PropertyMapImpl.this.superMap.removeListener(this.superListener);
                this.removeInheritedReferences();
            }
            return bl;
        }

        public Object get(Object object) {
            return PropertyMapImpl.this.vectorMap.get(object);
        }

        public boolean containsKey(Object object) {
            return PropertyMapImpl.this.vectorMap.containsKey(object);
        }

        public boolean containsValue(Object object) {
            return PropertyMapImpl.this.vectorMap.containsValue(object);
        }

        public boolean isEmpty() {
            return PropertyMapImpl.this.vectorMap.isEmpty();
        }

        public ConstMapIterator constIterator() {
            return PropertyMapImpl.this.vectorMap.constIterator();
        }

        protected void fireEntriesChanged(ConstMap constMap) {
            super.fireEntriesChanged(constMap);
        }

        static /* synthetic */ PropertyMapImpl access$000(PropertyObjectMap propertyObjectMap) {
            return propertyObjectMap.PropertyMapImpl.this;
        }
    }
}

