/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.panel;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import net.infonode.gui.CursorManager;
import net.infonode.gui.panel.SimplePanel;
import net.infonode.util.Direction;

public class ResizablePanel
extends SimplePanel {
    private Direction direction;
    private int resizeWidth = 4;
    private boolean cursorChanged;
    private int offset = -1;
    private boolean mouseInside;

    public ResizablePanel(Direction direction) {
        this(direction, null);
    }

    public ResizablePanel(Direction direction, Component component) {
        this.direction = direction;
        if (component == null) {
            component = this;
        }
        component.addMouseListener(new MouseAdapter(){

            public void mouseExited(MouseEvent mouseEvent) {
                if (ResizablePanel.this.offset == -1) {
                    ResizablePanel.this.resetCursor();
                }
                ResizablePanel.this.mouseInside = false;
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                ResizablePanel.this.mouseInside = true;
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (ResizablePanel.this.cursorChanged) {
                    ResizablePanel.this.offset = ResizablePanel.this.direction == Direction.LEFT ? mouseEvent.getPoint().x : (ResizablePanel.this.direction == Direction.RIGHT ? ResizablePanel.this.getWidth() - mouseEvent.getPoint().x : (ResizablePanel.this.direction == Direction.UP ? mouseEvent.getPoint().y : ResizablePanel.this.getHeight() - mouseEvent.getPoint().y));
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                ResizablePanel.this.offset = -1;
                ResizablePanel.this.checkCursor(mouseEvent.getPoint());
            }
        });
        component.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                ResizablePanel.this.checkCursor(mouseEvent.getPoint());
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                if (ResizablePanel.this.offset != -1) {
                    int n = ResizablePanel.this.direction.isHorizontal() ? (ResizablePanel.this.direction == Direction.LEFT ? ResizablePanel.this.getWidth() - mouseEvent.getPoint().x + ResizablePanel.this.offset : mouseEvent.getPoint().x + ResizablePanel.this.offset) : (ResizablePanel.this.direction == Direction.UP ? ResizablePanel.this.getHeight() - mouseEvent.getPoint().y + ResizablePanel.this.offset : mouseEvent.getPoint().y + ResizablePanel.this.offset);
                    ResizablePanel.this.setPreferredSize(ResizablePanel.this.getBoundedSize(n));
                    ResizablePanel.this.revalidate();
                }
            }
        });
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return this.getBoundedSize(this.direction.isHorizontal() ? dimension.width : dimension.height);
    }

    private Dimension getBoundedSize(int n) {
        if (this.direction.isHorizontal()) {
            return new Dimension(Math.max(this.getMinimumSize().width, Math.min(n, this.getMaximumSize().width)), 0);
        }
        return new Dimension(0, Math.max(this.getMinimumSize().height, Math.min(n, this.getMaximumSize().height)));
    }

    public void setResizeWidth(int n) {
        this.resizeWidth = n;
    }

    public int getResizeWidth() {
        return this.resizeWidth;
    }

    private void checkCursor(Point point) {
        int n;
        if (this.offset != -1) {
            return;
        }
        int n2 = this.direction == Direction.UP ? point.y : (this.direction == Direction.DOWN ? this.getHeight() - point.y : (n = this.direction == Direction.LEFT ? point.x : this.getWidth() - point.x));
        if (n >= 0 && n < this.resizeWidth && this.mouseInside) {
            if (!this.cursorChanged) {
                this.cursorChanged = true;
                CursorManager.setGlobalCursor(this, new Cursor(this.direction == Direction.LEFT ? 10 : (this.direction == Direction.RIGHT ? 11 : (this.direction == Direction.UP ? 8 : 9))));
            }
        } else {
            this.resetCursor();
        }
    }

    private void resetCursor() {
        CursorManager.resetGlobalCursor(this);
        this.cursorChanged = false;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }
}

