/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.componentpainter;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import net.infonode.gui.colorprovider.ColorProvider;
import net.infonode.gui.colorprovider.FixedColorProvider;
import net.infonode.gui.componentpainter.AbstractComponentPainter;
import net.infonode.util.ColorUtil;
import net.infonode.util.Direction;
import net.infonode.util.ImageUtils;

public class GradientComponentPainter
extends AbstractComponentPainter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ColorProvider[] colorProviders = new ColorProvider[4];
    private transient Color[] colors;
    private int size = 128;
    private transient SoftReference[] images;
    private transient boolean hasAlpha;

    public GradientComponentPainter(Color color, Color color2, Color color3, Color color4) {
        this(new FixedColorProvider(color), new FixedColorProvider(color2), new FixedColorProvider(color3), new FixedColorProvider(color4));
    }

    public GradientComponentPainter(ColorProvider colorProvider, ColorProvider colorProvider2, ColorProvider colorProvider3, ColorProvider colorProvider4) {
        this.colorProviders[0] = colorProvider;
        this.colorProviders[1] = colorProvider2;
        this.colorProviders[2] = colorProvider3;
        this.colorProviders[3] = colorProvider4;
    }

    public void paint(Component component, Graphics graphics, int n, int n2, int n3, int n4, Direction direction, boolean bl, boolean bl2) {
        this.updateColors(component);
        if (this.colors[0].equals(this.colors[2]) && this.colors[1].equals(this.colors[3]) && this.colors[0].equals(this.colors[1])) {
            graphics.setColor(this.colors[0]);
            graphics.fillRect(n, n2, n3, n4);
        } else {
            Image image;
            int n5 = direction.getValue() + (bl ? 4 : 0) + (bl2 ? 8 : 0);
            SoftReference softReference = this.images[n5];
            Image image2 = image = softReference == null ? null : (Image)softReference.get();
            if (image == null) {
                image = this.createGradientImage(this.fixColors(direction, bl, bl2));
                this.images[n5] = new SoftReference<Image>(image);
            }
            graphics.drawImage(image, n, n2, n3, n4, null);
        }
    }

    private Color[] fixColors(Direction direction, boolean bl, boolean bl2) {
        Color color;
        Color[] colorArray = new Color[4];
        if (bl) {
            colorArray[0] = this.colors[1];
            colorArray[1] = this.colors[0];
            colorArray[2] = this.colors[3];
            colorArray[3] = this.colors[2];
        } else {
            colorArray[0] = this.colors[0];
            colorArray[1] = this.colors[1];
            colorArray[2] = this.colors[2];
            colorArray[3] = this.colors[3];
        }
        if (bl2) {
            color = colorArray[2];
            colorArray[2] = colorArray[0];
            colorArray[0] = color;
            color = colorArray[3];
            colorArray[3] = colorArray[1];
            colorArray[1] = color;
        }
        if (direction == Direction.RIGHT) {
            return colorArray;
        }
        if (direction == Direction.DOWN) {
            color = colorArray[0];
            colorArray[0] = colorArray[2];
            colorArray[2] = colorArray[3];
            colorArray[3] = colorArray[1];
            colorArray[1] = color;
        } else if (direction == Direction.LEFT) {
            color = colorArray[0];
            colorArray[0] = colorArray[3];
            colorArray[3] = color;
            color = colorArray[1];
            colorArray[1] = colorArray[2];
            colorArray[2] = color;
        } else if (direction == Direction.UP) {
            color = colorArray[0];
            colorArray[0] = colorArray[1];
            colorArray[1] = colorArray[3];
            colorArray[3] = colorArray[2];
            colorArray[2] = color;
        }
        return colorArray;
    }

    private Image createGradientImage(Color[] colorArray) {
        return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.size, this.size, ImageUtils.createGradientPixels(colorArray, this.size, this.size), 0, this.size));
    }

    private void updateColors(Component component) {
        if (this.images == null) {
            this.images = new SoftReference[16];
        }
        if (this.colors == null) {
            this.colors = new Color[4];
        }
        for (int i = 0; i < this.colors.length; ++i) {
            Color color = this.colorProviders[i].getColor(component);
            if (!color.equals(this.colors[i])) {
                for (int j = 0; j < this.images.length; ++j) {
                    this.images[j] = null;
                }
            }
            this.colors[i] = color;
            this.hasAlpha |= color.getAlpha() != 255;
        }
    }

    public boolean isOpaque(Component component) {
        this.updateColors(component);
        return !this.hasAlpha;
    }

    public Color getColor(Component component) {
        this.updateColors(component);
        return ColorUtil.blend(ColorUtil.blend(this.colors[0], this.colors[1], 0.5), ColorUtil.blend(this.colors[2], this.colors[3], 0.5), 0.5);
    }
}

