/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.border.Border;
import net.infonode.gui.InsetsUtil;
import net.infonode.gui.colorprovider.BackgroundPainterColorProvider;
import net.infonode.gui.colorprovider.ColorMultiplier;
import net.infonode.gui.colorprovider.ColorProvider;
import net.infonode.gui.colorprovider.ColorProviderUtil;
import net.infonode.util.Direction;

public class HighlightBorder
implements Border,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Insets INSETS = new Insets(1, 1, 0, 0);
    private boolean lowered;
    private boolean pressed;
    private ColorProvider colorProvider;

    public HighlightBorder() {
        this(false);
    }

    public HighlightBorder(boolean bl) {
        this(bl, null);
    }

    public HighlightBorder(boolean bl, Color color) {
        this(bl, false, color);
    }

    public HighlightBorder(boolean bl, boolean bl2, Color color) {
        this(bl, bl2, ColorProviderUtil.getColorProvider(color, new ColorMultiplier(BackgroundPainterColorProvider.INSTANCE, bl ? 0.7 : 1.7)));
    }

    public HighlightBorder(boolean bl, boolean bl2, ColorProvider colorProvider) {
        this.lowered = bl;
        this.pressed = bl2;
        this.colorProvider = colorProvider;
    }

    public Insets getBorderInsets(Component component) {
        return this.pressed ? InsetsUtil.rotate(Direction.LEFT, INSETS) : INSETS;
    }

    public boolean isBorderOpaque() {
        return false;
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(this.colorProvider.getColor(component));
        if (this.pressed) {
            graphics.drawLine(n + (this.lowered ? 0 : 1), n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
            graphics.drawLine(n + n3 - 1, n2 + (this.lowered ? 0 : 1), n + n3 - 1, n2 + n4 - 2);
        } else {
            graphics.drawLine(n, n2, n + n3 - (this.lowered ? 1 : 2), n2);
            graphics.drawLine(n, n2, n, n2 + n4 - (this.lowered ? 1 : 2));
        }
    }
}

