/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.infonode.gui.ScrollableBoxListener;
import net.infonode.gui.layout.LayoutUtil;

public class ScrollableBox
extends JPanel {
    private LayoutManager l = new LayoutManager(){

        public void addLayoutComponent(String string, Component component) {
        }

        public void layoutContainer(Container container) {
            if (container.getComponentCount() > 0) {
                Component component = container.getComponent(0);
                component.setBounds(0, 0, component.getPreferredSize().width, component.getPreferredSize().height);
                component.validate();
                ScrollableBox.this.update();
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            Dimension dimension = container.getComponentCount() == 0 ? new Dimension(0, 0) : container.getComponent(0).getMinimumSize();
            return LayoutUtil.add(ScrollableBox.this.vertical ? new Dimension(dimension.width, 0) : new Dimension(0, dimension.height), container.getInsets());
        }

        public Dimension preferredLayoutSize(Container container) {
            return container.getComponentCount() == 0 ? new Dimension(0, 0) : container.getComponent(0).getPreferredSize();
        }

        public void removeLayoutComponent(Component component) {
        }
    };
    private int leftIndex;
    private boolean vertical;
    private int scrollOffset;
    private boolean leftEnd = true;
    private boolean rightEnd = false;
    private ArrayList layoutOrderList;
    private MouseWheelListener mouseWheelListener = new MouseWheelListener(){

        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            ScrollableBox.this.setLeftIndex(ScrollableBox.this.leftIndex + mouseWheelEvent.getWheelRotation());
        }
    };
    private ArrayList listeners = new ArrayList(1);

    public ScrollableBox(final JComponent jComponent, boolean bl, int n) {
        this.setLayout(this.l);
        this.vertical = bl;
        this.scrollOffset = n;
        this.add(jComponent);
        this.setOpaque(false);
        jComponent.addMouseWheelListener(this.mouseWheelListener);
        jComponent.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                if (jComponent.getParent() != ScrollableBox.this) {
                    jComponent.removeHierarchyListener(this);
                    jComponent.removeMouseWheelListener(ScrollableBox.this.mouseWheelListener);
                }
            }
        });
    }

    public void addScrollableBoxListener(ScrollableBoxListener scrollableBoxListener) {
        this.listeners.add(scrollableBoxListener);
    }

    public void removeScrollableBoxListener(ScrollableBoxListener scrollableBoxListener) {
        this.listeners.remove(scrollableBoxListener);
    }

    public void setScrollingContainer(JComponent jComponent) {
    }

    public JComponent getScrollingComponent() {
        return this.getComponentCount() == 0 ? null : (JComponent)this.getComponent(0);
    }

    public void scrollLeft(int n) {
        this.setLeftIndex(this.leftIndex - n);
    }

    public void scrollRight(int n) {
        this.setLeftIndex(this.leftIndex + n);
    }

    public void ensureVisible(int n) {
        int n2;
        if (this.leftIndex > n) {
            this.setLeftIndex(n);
        } else if (this.leftIndex < n && (n2 = this.findFitIndex(n)) > this.leftIndex) {
            this.setLeftIndex(n2);
        }
    }

    public boolean isLeftEnd() {
        return this.leftEnd;
    }

    public boolean isRightEnd() {
        return this.rightEnd;
    }

    public void setScrollOffset(int n) {
        if (n != this.scrollOffset) {
            this.scrollOffset = n;
            this.update();
        }
    }

    public int getScrollOffset() {
        return this.scrollOffset;
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public void setVertical(boolean bl) {
        this.vertical = bl;
        this.update();
        this.fireChanged();
    }

    public void setLayoutOrderList(ArrayList arrayList) {
        this.layoutOrderList = arrayList;
    }

    private int getDimensionSize(Dimension dimension) {
        return (int)(this.vertical ? dimension.getHeight() : dimension.getWidth());
    }

    private Point createPos(int n) {
        return this.vertical ? new Point(0, n) : new Point(n, 0);
    }

    private int getPos(Point point) {
        return this.vertical ? point.y : point.x;
    }

    private int getScrollOffset(int n) {
        return n == 0 ? 0 : Math.min(this.scrollOffset, this.getDimensionSize(this.getScrollingComponents()[n - 1].getPreferredSize()) / 2);
    }

    private Component[] getScrollingComponents() {
        JComponent jComponent = this.getScrollingComponent();
        if (jComponent == null) {
            return new Component[0];
        }
        if (this.layoutOrderList != null) {
            Component[] componentArray = new Component[this.layoutOrderList.size()];
            for (int i = 0; i < this.layoutOrderList.size(); ++i) {
                componentArray[i] = (Component)this.layoutOrderList.get(i);
            }
            return componentArray;
        }
        return jComponent.getComponents();
    }

    private int getScrollingComponentCount() {
        JComponent jComponent = this.getScrollingComponent();
        return jComponent == null ? 0 : jComponent.getComponentCount();
    }

    private int findFitIndex(int n) {
        int n2 = this.getDimensionSize(this.getSize());
        if (n2 == 0 || n < 0) {
            return 0;
        }
        Component[] componentArray = this.getScrollingComponents();
        int n3 = this.getPos(componentArray[n].getLocation()) + this.getDimensionSize(componentArray[n].getSize());
        for (int i = n; i >= 0; --i) {
            if (n3 - this.getPos(componentArray[i].getLocation()) + this.getScrollOffset(i) <= n2) continue;
            return Math.min(componentArray.length - 1, i + 1);
        }
        return 0;
    }

    private void update() {
        this.setLeftIndex(this.leftIndex);
    }

    private void setLeftIndex(int n) {
        JComponent jComponent = this.getScrollingComponent();
        int n2 = this.leftIndex;
        if (jComponent != null) {
            int n3 = this.getScrollingComponentCount();
            int n4 = this.findFitIndex(n3 - 1);
            this.leftIndex = Math.min(n4, Math.max(0, n));
            this.leftEnd = this.leftIndex == 0;
            this.rightEnd = this.leftIndex >= n4;
            jComponent.setLocation(this.createPos((n3 == 0 ? 0 : -this.getPos(this.getScrollingComponents()[this.leftIndex].getLocation())) + this.getScrollOffset(this.leftIndex)));
            Object[] objectArray = this.listeners.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                if (n2 < n) {
                    this.fireScrolledRight();
                    continue;
                }
                if (n2 <= n) continue;
                this.fireScrolledLeft();
            }
        }
    }

    public void updateUI() {
        super.updateUI();
        if (this.listeners != null) {
            this.fireChanged();
        }
    }

    private void fireScrolledLeft() {
        Object[] objectArray = this.listeners.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            ((ScrollableBoxListener)objectArray[i]).scrolledLeft(this);
        }
    }

    private void fireScrolledRight() {
        Object[] objectArray = this.listeners.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            ((ScrollableBoxListener)objectArray[i]).scrolledRight(this);
        }
    }

    private void fireChanged() {
        Object[] objectArray = this.listeners.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            ((ScrollableBoxListener)objectArray[i]).changed(this);
        }
    }
}

