/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking.properties;

import net.infonode.docking.properties.TabWindowProperties;
import net.infonode.properties.base.PropertyGroup;
import net.infonode.properties.gui.util.ComponentProperties;
import net.infonode.properties.propertymap.PropertyMap;
import net.infonode.properties.propertymap.PropertyMapContainer;
import net.infonode.properties.propertymap.PropertyMapFactory;
import net.infonode.properties.propertymap.PropertyMapGroup;
import net.infonode.properties.propertymap.PropertyMapProperty;
import net.infonode.properties.propertymap.PropertyMapValueHandler;
import net.infonode.properties.types.IntegerProperty;
import net.infonode.util.Direction;

public class WindowBarProperties
extends PropertyMapContainer {
    public static final PropertyMapGroup PROPERTIES = new PropertyMapGroup("Window Bar Properties", "");
    public static final PropertyMapProperty COMPONENT_PROPERTIES = new PropertyMapProperty((PropertyGroup)PROPERTIES, "Component Properties", "The WindowBar component properties.", ComponentProperties.PROPERTIES);
    public static final IntegerProperty CONTENT_PANEL_EDGE_RESIZE_DISTANCE = IntegerProperty.createPositive(PROPERTIES, "Content Panel Edge Resize Distance", "Inside this distance from the content panel edge the user can resize the content panel.", 2, PropertyMapValueHandler.INSTANCE);
    public static final IntegerProperty MINIMUM_WIDTH = IntegerProperty.createPositive(PROPERTIES, "Minimum Width", "The minimum width of the window bar. If greater than 0, the window bar will always be visible and the user can drag windows to it.", 2, PropertyMapValueHandler.INSTANCE);
    public static final PropertyMapProperty TAB_WINDOW_PROPERTIES = new PropertyMapProperty((PropertyGroup)PROPERTIES, "Tab Window Properties", "", TabWindowProperties.PROPERTIES);
    private static WindowBarProperties[] DEFAULT_VALUES = new WindowBarProperties[4];

    public static WindowBarProperties createDefault(Direction direction) {
        return new WindowBarProperties(DEFAULT_VALUES[direction.getValue()]);
    }

    public WindowBarProperties() {
        super(PropertyMapFactory.create(PROPERTIES));
    }

    public WindowBarProperties(PropertyMap propertyMap) {
        super(propertyMap);
    }

    public WindowBarProperties(WindowBarProperties windowBarProperties) {
        super(PropertyMapFactory.create(windowBarProperties.getMap()));
    }

    public WindowBarProperties addSuperObject(WindowBarProperties windowBarProperties) {
        this.getMap().addSuperMap(windowBarProperties.getMap());
        return this;
    }

    public WindowBarProperties removeSuperObject() {
        this.getMap().removeSuperMap();
        return this;
    }

    public WindowBarProperties removeSuperObject(WindowBarProperties windowBarProperties) {
        this.getMap().removeSuperMap(windowBarProperties.getMap());
        return this;
    }

    public int getContentPanelEdgeResizeDistance() {
        return CONTENT_PANEL_EDGE_RESIZE_DISTANCE.get(this.getMap());
    }

    public WindowBarProperties setContentPanelEdgeResizeEdgeDistance(int n) {
        CONTENT_PANEL_EDGE_RESIZE_DISTANCE.set(this.getMap(), n);
        return this;
    }

    public int getMinimumWidth() {
        return MINIMUM_WIDTH.get(this.getMap());
    }

    public WindowBarProperties setMinimumWidth(int n) {
        MINIMUM_WIDTH.set(this.getMap(), n);
        return this;
    }

    public TabWindowProperties getTabWindowProperties() {
        return new TabWindowProperties(TAB_WINDOW_PROPERTIES.get(this.getMap()));
    }

    public ComponentProperties getComponentProperties() {
        return new ComponentProperties(COMPONENT_PROPERTIES.get(this.getMap()));
    }

    static {
        Direction[] directionArray = Direction.getDirections();
        for (int i = 0; i < directionArray.length; ++i) {
            Direction direction = directionArray[i];
            WindowBarProperties windowBarProperties = new WindowBarProperties();
            windowBarProperties.getTabWindowProperties().getTabbedPanelProperties().setTabAreaOrientation(direction);
            windowBarProperties.getTabWindowProperties().getTabProperties().getTitledTabProperties().getNormalProperties().setDirection(direction.isHorizontal() ? Direction.DOWN : Direction.RIGHT);
            WindowBarProperties.DEFAULT_VALUES[direction.getValue()] = windowBarProperties;
        }
    }
}

