/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking.action;

import java.io.ObjectStreamException;
import javax.swing.Icon;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.TabWindow;
import net.infonode.docking.action.DockingWindowAction;
import net.infonode.docking.util.DockingUtil;
import net.infonode.gui.icon.button.MaximizeIcon;

public final class MaximizeWindowAction
extends DockingWindowAction {
    private static final long serialVersionUID = 1L;
    public static final MaximizeWindowAction INSTANCE = new MaximizeWindowAction();
    private static final Icon icon = new MaximizeIcon(10);

    private MaximizeWindowAction() {
    }

    public Icon getIcon() {
        return icon;
    }

    public String getName() {
        return "Maximize";
    }

    public boolean isPerformable(DockingWindow dockingWindow) {
        TabWindow tabWindow = DockingUtil.getTabWindowFor(dockingWindow);
        return tabWindow != null && !tabWindow.isMaximized() && tabWindow.isMaximizable();
    }

    public void perform(DockingWindow dockingWindow) {
        TabWindow tabWindow = DockingUtil.getTabWindowFor(dockingWindow);
        if (tabWindow != null && !tabWindow.isMaximized() && tabWindow.isMaximizable()) {
            tabWindow.maximize();
        }
    }

    protected Object readResolve() throws ObjectStreamException {
        return INSTANCE;
    }
}

