/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking;

import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.Icon;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.RootWindow;
import net.infonode.docking.WindowDecoder;
import net.infonode.docking.internal.ReadContext;
import net.infonode.docking.internal.WriteContext;
import net.infonode.docking.internalutil.DropAction;
import net.infonode.docking.location.WindowLocation;
import net.infonode.docking.location.WindowSplitLocation;
import net.infonode.docking.model.SplitWindowItem;
import net.infonode.docking.model.ViewReader;
import net.infonode.docking.model.ViewWriter;
import net.infonode.docking.properties.SplitWindowProperties;
import net.infonode.gui.SimpleSplitPane;
import net.infonode.gui.SimpleSplitPaneListener;
import net.infonode.properties.propertymap.PropertyMap;
import net.infonode.util.Direction;

public class SplitWindow
extends DockingWindow {
    private SimpleSplitPane splitPane;
    private DockingWindow leftWindow;
    private DockingWindow rightWindow;

    public SplitWindow(boolean bl) {
        this(bl, null, null);
    }

    public SplitWindow(boolean bl, DockingWindow dockingWindow, DockingWindow dockingWindow2) {
        this(bl, 0.5f, dockingWindow, dockingWindow2);
    }

    public SplitWindow(boolean bl, float f, DockingWindow dockingWindow, DockingWindow dockingWindow2) {
        this(bl, f, dockingWindow, dockingWindow2, null);
    }

    protected SplitWindow(boolean bl, float f, DockingWindow dockingWindow, DockingWindow dockingWindow2, SplitWindowItem splitWindowItem) {
        super(splitWindowItem == null ? new SplitWindowItem() : splitWindowItem);
        this.splitPane = new SimpleSplitPane(bl);
        this.splitPane.addListener(new SimpleSplitPaneListener(){

            public void dividerLocationChanged(SimpleSplitPane simpleSplitPane) {
                ((SplitWindowItem)SplitWindow.this.getWindowItem()).setDividerLocation(simpleSplitPane.getDividerLocation());
            }
        });
        this.setComponent(this.splitPane);
        this.setWindows(dockingWindow, dockingWindow2);
        this.setHorizontal(bl);
        this.setDividerLocation(f);
        this.splitPane.getDividerPanel().addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    SplitWindow.this.showPopupMenu(mouseEvent);
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.mousePressed(mouseEvent);
            }
        });
        this.init();
    }

    public SplitWindowProperties getSplitWindowProperties() {
        return ((SplitWindowItem)this.getWindowItem()).getSplitWindowProperties();
    }

    public DockingWindow getLeftWindow() {
        return this.leftWindow;
    }

    public DockingWindow getRightWindow() {
        return this.rightWindow;
    }

    public void setDividerLocation(float f) {
        this.splitPane.setDividerLocation(f);
    }

    public float getDividerLocation() {
        return this.splitPane.getDividerLocation();
    }

    public void setWindows(final DockingWindow dockingWindow, final DockingWindow dockingWindow2) {
        if (dockingWindow == this.getLeftWindow() && dockingWindow2 == this.getRightWindow()) {
            return;
        }
        SplitWindow.optimizeAfter(null, new Runnable(){

            public void run() {
                DockingWindow dockingWindow3 = dockingWindow.getContentWindow(SplitWindow.this);
                DockingWindow dockingWindow22 = dockingWindow2.getContentWindow(SplitWindow.this);
                dockingWindow3.detach();
                dockingWindow22.detach();
                if (SplitWindow.this.getLeftWindow() != null) {
                    SplitWindow.this.removeWindow(SplitWindow.this.getLeftWindow());
                }
                if (SplitWindow.this.getRightWindow() != null) {
                    SplitWindow.this.removeWindow(SplitWindow.this.getRightWindow());
                }
                SplitWindow.this.leftWindow = dockingWindow3;
                SplitWindow.this.rightWindow = dockingWindow22;
                SplitWindow.this.splitPane.setComponents(dockingWindow3, dockingWindow22);
                SplitWindow.this.addWindow(dockingWindow3);
                SplitWindow.this.addWindow(dockingWindow22);
                if (DockingWindow.getUpdateModel()) {
                    SplitWindow.this.getWindowItem().addWindow(SplitWindow.this.getLeftWindow().getWindowItem());
                    SplitWindow.this.getWindowItem().addWindow(SplitWindow.this.getRightWindow().getWindowItem());
                    SplitWindow.this.cleanUpModel();
                }
            }
        });
    }

    public boolean isHorizontal() {
        return this.splitPane.isHorizontal();
    }

    public void setHorizontal(boolean bl) {
        this.splitPane.setHorizontal(bl);
        ((SplitWindowItem)this.getWindowItem()).setHorizontal(bl);
    }

    protected void update() {
        this.splitPane.setDividerSize(this.getSplitWindowProperties().getDividerSize());
        this.splitPane.setContinuousLayout(this.getSplitWindowProperties().getContinuousLayoutEnabled());
        this.splitPane.setDividerDraggable(this.getSplitWindowProperties().getDividerLocationDragEnabled());
    }

    protected void optimizeWindowLayout() {
        DockingWindow dockingWindow = this.getWindowParent();
        if (dockingWindow != null && (this.getRightWindow() == null || this.getLeftWindow() == null)) {
            if (this.getRightWindow() == null && this.getLeftWindow() == null) {
                dockingWindow.removeChildWindow(this);
            } else {
                DockingWindow dockingWindow2 = this.getRightWindow() == null ? this.getLeftWindow() : this.getRightWindow();
                dockingWindow.internalReplaceChildWindow(this, dockingWindow2.getBestFittedWindow(dockingWindow));
            }
        }
    }

    protected WindowLocation getWindowLocation(DockingWindow dockingWindow) {
        if (this.getLeftWindow() == null || this.getRightWindow() == null) {
            return this.getWindowLocation();
        }
        boolean bl = dockingWindow == this.getLeftWindow();
        return new WindowSplitLocation((bl ? this.getRightWindow() : this.getLeftWindow()).getLocationWindow(), this.getWindowLocation(), bl ? (this.splitPane.isHorizontal() ? Direction.LEFT : Direction.UP) : (this.splitPane.isHorizontal() ? Direction.RIGHT : Direction.DOWN), this.getDividerLocation());
    }

    public DockingWindow getChildWindow(int n) {
        return this.getWindows()[n];
    }

    private DockingWindow[] getWindows() {
        DockingWindow[] dockingWindowArray;
        if (this.getLeftWindow() == null) {
            if (this.getRightWindow() == null) {
                dockingWindowArray = new DockingWindow[]{};
            } else {
                DockingWindow[] dockingWindowArray2 = new DockingWindow[1];
                dockingWindowArray = dockingWindowArray2;
                dockingWindowArray2[0] = this.getRightWindow();
            }
        } else if (this.getRightWindow() == null) {
            DockingWindow[] dockingWindowArray3 = new DockingWindow[1];
            dockingWindowArray = dockingWindowArray3;
            dockingWindowArray3[0] = this.getLeftWindow();
        } else {
            DockingWindow[] dockingWindowArray4 = new DockingWindow[2];
            dockingWindowArray4[0] = this.getLeftWindow();
            dockingWindowArray = dockingWindowArray4;
            dockingWindowArray4[1] = this.getRightWindow();
        }
        return dockingWindowArray;
    }

    public int getChildWindowCount() {
        return this.getWindows().length;
    }

    public Icon getIcon() {
        return this.getLeftWindow() == null ? (this.getRightWindow() == null ? null : this.getRightWindow().getIcon()) : this.getLeftWindow().getIcon();
    }

    protected void doReplace(DockingWindow dockingWindow, DockingWindow dockingWindow2) {
        if (this.getLeftWindow() == dockingWindow) {
            this.leftWindow = dockingWindow2;
            this.splitPane.setLeftComponent(dockingWindow2);
        } else {
            this.rightWindow = dockingWindow2;
            this.splitPane.setRightComponent(dockingWindow2);
        }
        this.validate();
    }

    protected void doRemoveWindow(DockingWindow dockingWindow) {
        if (dockingWindow == this.getLeftWindow()) {
            this.leftWindow = null;
            this.splitPane.setLeftComponent(null);
        } else {
            this.rightWindow = null;
            this.splitPane.setRightComponent(null);
        }
    }

    protected DockingWindow oldRead(ObjectInputStream objectInputStream, ReadContext readContext) throws IOException {
        this.splitPane.setHorizontal(objectInputStream.readBoolean());
        this.splitPane.setDividerLocation(objectInputStream.readFloat());
        DockingWindow dockingWindow = WindowDecoder.decodeWindow(objectInputStream, readContext);
        DockingWindow dockingWindow2 = WindowDecoder.decodeWindow(objectInputStream, readContext);
        super.oldRead(objectInputStream, readContext);
        if (dockingWindow != null && dockingWindow2 != null) {
            this.setWindows(dockingWindow, dockingWindow2);
            return this;
        }
        return dockingWindow != null ? dockingWindow : (dockingWindow2 != null ? dockingWindow2 : null);
    }

    protected void updateWindowItem(RootWindow rootWindow) {
        super.updateWindowItem(rootWindow);
        ((SplitWindowItem)this.getWindowItem()).setParentSplitWindowProperties(rootWindow == null ? SplitWindowItem.emptyProperties : rootWindow.getRootWindowProperties().getSplitWindowProperties());
    }

    protected PropertyMap getPropertyObject() {
        return this.getSplitWindowProperties().getMap();
    }

    protected PropertyMap createPropertyObject() {
        return new SplitWindowProperties().getMap();
    }

    void removeWindowComponent(DockingWindow dockingWindow) {
        if (dockingWindow == this.getLeftWindow()) {
            this.splitPane.setLeftComponent(null);
        } else {
            this.splitPane.setRightComponent(null);
        }
    }

    void restoreWindowComponent(DockingWindow dockingWindow) {
        if (dockingWindow == this.getLeftWindow()) {
            this.splitPane.setLeftComponent(this.leftWindow);
        } else {
            this.splitPane.setRightComponent(this.rightWindow);
        }
    }

    protected int getChildEdgeDepth(DockingWindow dockingWindow, Direction direction) {
        return (dockingWindow == this.leftWindow ? direction : direction.getOpposite()) == (this.isHorizontal() ? Direction.RIGHT : Direction.DOWN) ? 0 : super.getChildEdgeDepth(dockingWindow, direction);
    }

    protected DropAction doAcceptDrop(Point point, DockingWindow dockingWindow) {
        float f;
        DropAction dropAction = this.acceptChildDrop(point, dockingWindow);
        if (dropAction != null) {
            return dropAction;
        }
        float f2 = f = this.isHorizontal() ? (float)point.y / (float)this.getHeight() : (float)point.x / (float)this.getWidth();
        if (f <= 0.33f) {
            return this.split(dockingWindow, this.isHorizontal() ? Direction.UP : Direction.LEFT);
        }
        if (f >= 0.66f) {
            return this.split(dockingWindow, this.isHorizontal() ? Direction.DOWN : Direction.RIGHT);
        }
        return this.createTabWindow(dockingWindow);
    }

    protected void write(ObjectOutputStream objectOutputStream, WriteContext writeContext, ViewWriter viewWriter) throws IOException {
        objectOutputStream.writeInt(2);
        viewWriter.writeWindowItem(this.getWindowItem(), objectOutputStream, writeContext);
        this.getLeftWindow().write(objectOutputStream, writeContext, viewWriter);
        this.getRightWindow().write(objectOutputStream, writeContext, viewWriter);
    }

    protected DockingWindow newRead(ObjectInputStream objectInputStream, ReadContext readContext, ViewReader viewReader) throws IOException {
        DockingWindow dockingWindow = WindowDecoder.decodeWindow(objectInputStream, readContext, viewReader);
        DockingWindow dockingWindow2 = WindowDecoder.decodeWindow(objectInputStream, readContext, viewReader);
        if (dockingWindow != null && dockingWindow2 != null) {
            this.setWindows(dockingWindow, dockingWindow2);
            return this;
        }
        return dockingWindow != null ? dockingWindow : (dockingWindow2 != null ? dockingWindow2 : null);
    }
}

