/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.FocusManager;
import net.infonode.docking.SplitWindow;
import net.infonode.docking.TabWindow;
import net.infonode.docking.View;
import net.infonode.docking.ViewSerializer;
import net.infonode.docking.WindowBar;
import net.infonode.docking.WindowDecoder;
import net.infonode.docking.action.MaximizeWindowAction;
import net.infonode.docking.action.NullWindowAction;
import net.infonode.docking.action.RestoreFocusWindowAction;
import net.infonode.docking.action.RestoreParentWindowAction;
import net.infonode.docking.action.RestoreWindowAction;
import net.infonode.docking.action.StateDependentWindowAction;
import net.infonode.docking.internal.ReadContext;
import net.infonode.docking.internal.WriteContext;
import net.infonode.docking.internalutil.DropAction;
import net.infonode.docking.location.WindowLocation;
import net.infonode.docking.location.WindowRootLocation;
import net.infonode.docking.model.RootWindowItem;
import net.infonode.docking.model.SplitWindowItem;
import net.infonode.docking.model.TabWindowItem;
import net.infonode.docking.model.ViewItem;
import net.infonode.docking.model.ViewReader;
import net.infonode.docking.model.ViewWriter;
import net.infonode.docking.model.WindowItem;
import net.infonode.docking.properties.RootWindowProperties;
import net.infonode.gui.componentpainter.RectangleComponentPainter;
import net.infonode.gui.layout.BorderLayout2;
import net.infonode.gui.layout.LayoutUtil;
import net.infonode.gui.layout.StretchLayout;
import net.infonode.gui.mouse.MouseButtonListener;
import net.infonode.gui.panel.ResizablePanel;
import net.infonode.gui.panel.SimplePanel;
import net.infonode.gui.shaped.panel.ShapedPanel;
import net.infonode.properties.gui.InternalPropertiesUtil;
import net.infonode.properties.propertymap.PropertyMap;
import net.infonode.properties.propertymap.PropertyMapManager;
import net.infonode.util.ArrayUtil;
import net.infonode.util.Direction;
import net.infonode.util.ReadWritable;

public class RootWindow
extends DockingWindow
implements ReadWritable {
    private static final int SERIALIZE_VERSION = 3;
    private SimplePanel layeredPane = new SimplePanel(){

        public boolean isOptimizedDrawingEnabled() {
            return false;
        }
    };
    private ShapedPanel shapedPanel = new ShapedPanel(this.layeredPane);
    private SimplePanel mainPanel = new SimplePanel();
    private ShapedPanel windowPanel = new ShapedPanel(new StretchLayout(true, true));
    private ViewSerializer viewSerializer;
    private DockingWindow window;
    private JLabel textComponent = new JLabel();
    private ShapedPanel rectangleComponent = new ShapedPanel();
    private WindowBar[] windowBars = new WindowBar[Direction.getDirections().length];
    private DockingWindow maximizedWindow;
    private View focusedView;
    private ArrayList lastFocusedWindows = new ArrayList(4);
    private ArrayList focusedWindows = new ArrayList(4);
    private ArrayList views = new ArrayList();
    private boolean cleanUpModel;
    private Runnable modelCleanUpEvent = new Runnable(){

        public void run() {
            if (RootWindow.this.cleanUpModel) {
                RootWindow.this.cleanUpModel = false;
                RootWindow.this.getWindowItem().cleanUp();
            }
        }
    };

    public RootWindow(ViewSerializer viewSerializer) {
        super(new RootWindowItem());
        this.getWindowProperties().addSuperObject(this.getRootWindowProperties().getDockingWindowProperties());
        this.mainPanel.setLayout(new BorderLayout2());
        this.mainPanel.add((Component)this.windowPanel, new Point(1, 1));
        this.createWindowBars();
        this.layeredPane.add(this.mainPanel);
        this.layeredPane.setLayout(new SingleComponentLayout());
        this.setComponent(this.shapedPanel);
        this.viewSerializer = viewSerializer;
        this.textComponent.setOpaque(true);
        this.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                if (RootWindow.this.getRootPane() != null && RootWindow.this.getRootPane().getLayeredPane() != RootWindow.this.textComponent.getParent()) {
                    RootWindow.this.addComponents();
                }
            }
        });
        this.init();
        FocusManager.getInstance();
        this.addTabMouseButtonListener(new MouseButtonListener(){

            public void mouseButtonEvent(MouseEvent mouseEvent) {
                if (mouseEvent.isConsumed()) {
                    return;
                }
                DockingWindow dockingWindow = (DockingWindow)mouseEvent.getSource();
                if (mouseEvent.getID() == 501 && mouseEvent.getButton() == 1 && !mouseEvent.isShiftDown() && dockingWindow.isShowing()) {
                    RestoreFocusWindowAction.INSTANCE.perform(dockingWindow);
                } else if (mouseEvent.getID() == 500 && mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                    if (dockingWindow.getWindowParent() instanceof WindowBar && RootWindow.this.getRootWindowProperties().getDoubleClickRestoresWindow()) {
                        RestoreWindowAction.INSTANCE.perform(dockingWindow);
                    } else {
                        new StateDependentWindowAction(MaximizeWindowAction.INSTANCE, NullWindowAction.INSTANCE, RestoreParentWindowAction.INSTANCE).perform(dockingWindow);
                    }
                }
            }
        });
    }

    public RootWindow(ViewSerializer viewSerializer, DockingWindow dockingWindow) {
        this(viewSerializer);
        this.setWindow(dockingWindow);
    }

    public View getFocusedView() {
        return this.focusedView;
    }

    void addFocusedWindow(DockingWindow dockingWindow) {
        for (int i = 0; i < this.lastFocusedWindows.size(); ++i) {
            if (((SoftReference)this.lastFocusedWindows.get(i)).get() != dockingWindow) continue;
            return;
        }
        this.lastFocusedWindows.add(new SoftReference<DockingWindow>(dockingWindow));
    }

    void setFocusedView(View view) {
        DockingWindow dockingWindow;
        int n;
        if (view == this.focusedView) {
            return;
        }
        View view2 = this.focusedView;
        this.focusedView = view;
        block0: for (DockingWindow dockingWindow2 = view; dockingWindow2 != null; dockingWindow2 = dockingWindow2.getWindowParent()) {
            this.focusedWindows.add(new SoftReference<View>((View)dockingWindow2));
            for (int i = 0; i < this.lastFocusedWindows.size(); ++i) {
                if (((SoftReference)this.lastFocusedWindows.get(i)).get() != dockingWindow2) continue;
                this.lastFocusedWindows.remove(i);
                continue block0;
            }
        }
        for (int i = 0; i < this.lastFocusedWindows.size(); ++i) {
            DockingWindow dockingWindow3 = (DockingWindow)((SoftReference)this.lastFocusedWindows.get(i)).get();
            if (dockingWindow3 == null) continue;
            dockingWindow3.setFocused(false);
        }
        ArrayList arrayList = this.lastFocusedWindows;
        this.lastFocusedWindows = this.focusedWindows;
        this.focusedWindows = arrayList;
        for (n = 0; n < this.lastFocusedWindows.size(); ++n) {
            dockingWindow = (DockingWindow)((SoftReference)this.lastFocusedWindows.get(n)).get();
            if (dockingWindow == null) continue;
            dockingWindow.setFocused(true);
        }
        if (view != null) {
            view.childGainedFocus(null, view);
        } else {
            this.clearFocus(null);
        }
        for (n = 0; n < this.focusedWindows.size(); ++n) {
            dockingWindow = (DockingWindow)((SoftReference)this.focusedWindows.get(n)).get();
            if (dockingWindow == null) continue;
            dockingWindow.fireViewFocusChanged(view2, this.focusedView);
        }
        for (n = 0; n < this.lastFocusedWindows.size(); ++n) {
            dockingWindow = (DockingWindow)((SoftReference)this.lastFocusedWindows.get(n)).get();
            if (dockingWindow == null) continue;
            dockingWindow.fireViewFocusChanged(view2, this.focusedView);
        }
        this.focusedWindows.clear();
    }

    public RootWindowProperties getRootWindowProperties() {
        return ((RootWindowItem)this.getWindowItem()).getRootWindowProperties();
    }

    public Direction getClosestWindowBar(DockingWindow dockingWindow) {
        Point point = SwingUtilities.convertPoint(dockingWindow.getParent(), dockingWindow.getLocation(), this);
        int[] nArray = new int[]{this.getWindowBar(Direction.UP).isEnabled() ? point.y + dockingWindow.getHeight() : Integer.MAX_VALUE, this.getWindowBar(Direction.DOWN).isEnabled() ? this.getHeight() - point.y : Integer.MAX_VALUE, this.getWindowBar(Direction.LEFT).isEnabled() ? point.x + dockingWindow.getWidth() : Integer.MAX_VALUE, this.getWindowBar(Direction.RIGHT).isEnabled() ? this.getWidth() - point.x : Integer.MAX_VALUE};
        Direction direction = (new Direction[]{Direction.UP, Direction.DOWN, Direction.LEFT, Direction.RIGHT})[ArrayUtil.findSmallest(nArray)];
        return this.getWindowBar(direction).isEnabled() ? direction : null;
    }

    public WindowBar getWindowBar(Direction direction) {
        return this.windowBars[direction.getValue()];
    }

    public void setWindow(DockingWindow dockingWindow) {
        if (this.window == dockingWindow) {
            return;
        }
        if (this.window == null) {
            DockingWindow dockingWindow2 = this.addWindow(dockingWindow);
            this.doReplace(null, dockingWindow2);
            if (RootWindow.getUpdateModel() && dockingWindow2.getWindowItem().getRootItem() != this.getWindowItem()) {
                this.getWindowItem().removeAll();
                this.getWindowItem().addWindow(dockingWindow2.getWindowItem());
            }
        } else if (dockingWindow == null) {
            this.removeChildWindow(this.window);
            this.window = null;
        } else {
            this.replaceChildWindow(this.window, dockingWindow);
        }
    }

    public DockingWindow getWindow() {
        return this.window;
    }

    public ViewSerializer getViewSerializer() {
        return this.viewSerializer;
    }

    public DockingWindow getChildWindow(int n) {
        return n < 4 ? this.windowBars[n] : this.window;
    }

    public int getChildWindowCount() {
        return 4 + (this.window == null ? 0 : 1);
    }

    public Icon getIcon() {
        return null;
    }

    public void write(ObjectOutputStream objectOutputStream) throws IOException {
        this.write(objectOutputStream, true);
    }

    public void write(ObjectOutputStream objectOutputStream, boolean bl) throws IOException {
        this.cleanUpModel();
        objectOutputStream.writeInt(3);
        objectOutputStream.writeBoolean(bl);
        WriteContext writeContext = new WriteContext(bl, this.getViewSerializer());
        final ArrayList<View> arrayList = new ArrayList<View>();
        for (int i = 0; i < this.views.size(); ++i) {
            View view = (View)((WeakReference)this.views.get(i)).get();
            if (view == null) continue;
            arrayList.add(view);
        }
        this.writeViews(arrayList, objectOutputStream, writeContext);
        ViewWriter viewWriter = new ViewWriter(){

            public void writeWindowItem(WindowItem windowItem, ObjectOutputStream objectOutputStream, WriteContext writeContext) throws IOException {
                if (windowItem.getRootItem() == RootWindow.this.getWindowItem()) {
                    objectOutputStream.writeBoolean(true);
                    RootWindow.this.writeWindowItemIndex(windowItem, objectOutputStream);
                    objectOutputStream.writeInt(-1);
                } else {
                    objectOutputStream.writeBoolean(false);
                    windowItem.writeSettings(objectOutputStream, writeContext);
                }
            }

            public void writeView(View view, ObjectOutputStream objectOutputStream, WriteContext writeContext) throws IOException {
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (arrayList.get(i) != view) continue;
                    objectOutputStream.writeInt(i);
                    return;
                }
                objectOutputStream.writeInt(-1);
            }
        };
        this.getWindowItem().write(objectOutputStream, writeContext, viewWriter);
        for (int i = 0; i < 4; ++i) {
            this.windowBars[i].write(objectOutputStream, writeContext, viewWriter);
        }
        this.writeLocations(objectOutputStream);
        if (this.maximizedWindow != null) {
            this.writeMaximized(this.maximizedWindow, objectOutputStream);
        }
        objectOutputStream.writeInt(-1);
    }

    private void writeWindowItemIndex(WindowItem windowItem, ObjectOutputStream objectOutputStream) throws IOException {
        if (windowItem.getParent() == null) {
            return;
        }
        this.writeWindowItemIndex(windowItem.getParent(), objectOutputStream);
        int n = windowItem.getParent().getWindowIndex(windowItem);
        objectOutputStream.writeInt(n);
    }

    private void writeMaximized(DockingWindow dockingWindow, ObjectOutputStream objectOutputStream) throws IOException {
        DockingWindow dockingWindow2 = dockingWindow.getWindowParent();
        if (dockingWindow2 != null) {
            this.writeMaximized(dockingWindow2, objectOutputStream);
            objectOutputStream.writeInt(dockingWindow2.getChildWindowIndex(dockingWindow));
        }
    }

    private void writeViews(ArrayList arrayList, ObjectOutputStream objectOutputStream, WriteContext writeContext) throws IOException {
        objectOutputStream.writeInt(arrayList.size());
        for (int i = 0; i < arrayList.size(); ++i) {
            ((View)arrayList.get(i)).write(objectOutputStream, writeContext);
        }
    }

    public void read(ObjectInputStream objectInputStream) throws IOException {
        this.read(objectInputStream, true);
    }

    private void oldInternalRead(ObjectInputStream objectInputStream, ReadContext readContext) throws IOException {
        int n;
        this.setWindow(objectInputStream.readBoolean() ? WindowDecoder.decodeWindow(objectInputStream, readContext) : null);
        for (n = 0; n < 4; ++n) {
            objectInputStream.readInt();
            this.windowBars[n].oldRead(objectInputStream, readContext);
        }
        super.oldRead(objectInputStream, readContext);
        this.readLocations(objectInputStream, this, readContext.getVersion());
        if (readContext.getVersion() > 1) {
            n = objectInputStream.readInt();
            for (int i = 0; i < n; ++i) {
                View view = (View)WindowDecoder.decodeWindow(objectInputStream, readContext);
                view.setRootWindow(this);
                view.readLocations(objectInputStream, this, readContext.getVersion());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newInternalRead(ObjectInputStream objectInputStream, ReadContext readContext) throws IOException {
        RootWindow.beginUpdateModel();
        try {
            int n = objectInputStream.readInt();
            final View[] viewArray = new View[n];
            for (int i = 0; i < n; ++i) {
                viewArray[i] = View.read(objectInputStream, readContext);
                if (viewArray[i] == null) continue;
                viewArray[i].setRootWindow(this);
            }
            ViewReader viewReader = new ViewReader(){

                public ViewItem readViewItem(ObjectInputStream objectInputStream, ReadContext readContext) throws IOException {
                    View view = this.readView(objectInputStream, readContext);
                    return view == null ? new ViewItem() : (ViewItem)view.getWindowItem();
                }

                public WindowItem readWindowItem(ObjectInputStream objectInputStream, ReadContext readContext) throws IOException {
                    if (objectInputStream.readBoolean()) {
                        int n;
                        WindowItem windowItem = RootWindow.this.getWindowItem();
                        while ((n = objectInputStream.readInt()) != -1) {
                            windowItem = windowItem.getWindow(n);
                        }
                        return windowItem;
                    }
                    return null;
                }

                public TabWindow createTabWindow(DockingWindow[] dockingWindowArray, TabWindowItem tabWindowItem) {
                    TabWindow tabWindow = new TabWindow(dockingWindowArray, tabWindowItem);
                    tabWindow.updateSelectedTab();
                    return tabWindow;
                }

                public SplitWindow createSplitWindow(DockingWindow dockingWindow, DockingWindow dockingWindow2, SplitWindowItem splitWindowItem) {
                    return new SplitWindow(splitWindowItem.isHorizontal(), splitWindowItem.getDividerLocation(), dockingWindow, dockingWindow2, splitWindowItem);
                }

                public View readView(ObjectInputStream objectInputStream, ReadContext readContext) throws IOException {
                    int n = objectInputStream.readInt();
                    return n == -1 ? null : viewArray[n];
                }
            };
            this.setWindow(this.getWindowItem().read(objectInputStream, readContext, viewReader));
            for (int i = 0; i < 4; ++i) {
                this.windowBars[i].newRead(objectInputStream, readContext, viewReader);
            }
            this.readLocations(objectInputStream, this, readContext.getVersion());
        }
        finally {
            RootWindow.endUpdateModel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(ObjectInputStream objectInputStream, boolean bl) throws IOException {
        FocusManager.getInstance().startIgnoreFocusChanges();
        PropertyMapManager.getInstance().beginBatch();
        try {
            this.setWindow(null);
            int n = objectInputStream.readInt();
            if (n > 3) {
                throw new IOException("Can't read serialized data because it was written by a later version of InfoNode Docking Windows!");
            }
            ReadContext readContext = new ReadContext(this.viewSerializer, n, objectInputStream.readBoolean(), bl);
            if (readContext.getVersion() < 3) {
                this.oldInternalRead(objectInputStream, readContext);
            } else {
                this.newInternalRead(objectInputStream, readContext);
            }
            if (n > 1) {
                this.readMaximized(objectInputStream);
            }
            FocusManager.focusWindow(this);
            PropertyMapManager.getInstance().endBatch();
        }
        catch (Throwable throwable) {
            PropertyMapManager.getInstance().endBatch();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    FocusManager.getInstance().stopIgnoreFocusChanges();
                }
            });
            throw throwable;
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    private void readMaximized(ObjectInputStream objectInputStream) throws IOException {
        int n;
        DockingWindow dockingWindow = this;
        while ((n = objectInputStream.readInt()) != -1) {
            if (n >= ((DockingWindow)dockingWindow).getChildWindowCount()) {
                while (objectInputStream.readInt() != -1) {
                }
                return;
            }
            dockingWindow = ((DockingWindow)dockingWindow).getChildWindow(n);
        }
        if (dockingWindow != this) {
            this.setMaximizedWindow(dockingWindow);
        }
    }

    public DockingWindow getMaximizedWindow() {
        return this.maximizedWindow;
    }

    public void setMaximizedWindow(DockingWindow dockingWindow) {
        if (dockingWindow == this.maximizedWindow) {
            return;
        }
        if (dockingWindow != null && dockingWindow.isMinimized()) {
            return;
        }
        this.internalSetMaximizedWindow(dockingWindow);
        if (dockingWindow != null) {
            FocusManager.focusWindow(dockingWindow);
        }
    }

    void addView(View view) {
        int n = this.views.size();
        for (int i = 0; i < this.views.size(); ++i) {
            View view2 = (View)((WeakReference)this.views.get(i)).get();
            if (view2 == view) {
                return;
            }
            if (view2 != null) continue;
            n = i;
        }
        this.views.add(n, new WeakReference<View>(view));
    }

    void removeView(View view) {
        for (int i = 0; i < this.views.size(); ++i) {
            View view2 = (View)((WeakReference)this.views.get(i)).get();
            if (view2 != view) continue;
            this.views.remove(i);
            return;
        }
    }

    private void internalSetMaximizedWindow(DockingWindow dockingWindow) {
        if (dockingWindow == this.maximizedWindow) {
            return;
        }
        if (this.maximizedWindow != null) {
            DockingWindow dockingWindow2 = this.maximizedWindow;
            this.maximizedWindow = null;
            if (dockingWindow2.getWindowParent() != null) {
                dockingWindow2.getWindowParent().restoreWindowComponent(dockingWindow2);
            }
            dockingWindow2.maximized(false);
            if (dockingWindow2 != this.window) {
                this.windowPanel.remove(dockingWindow2);
            }
        }
        this.maximizedWindow = dockingWindow;
        if (this.maximizedWindow != null) {
            if (this.maximizedWindow.getWindowParent() != null) {
                this.maximizedWindow.getWindowParent().removeWindowComponent(this.maximizedWindow);
            }
            if (this.maximizedWindow != this.window) {
                this.windowPanel.add(this.maximizedWindow);
                if (this.window != null) {
                    this.window.setVisible(false);
                }
            }
            this.maximizedWindow.maximized(true);
            this.maximizedWindow.setVisible(true);
        } else if (this.window != null) {
            this.window.setVisible(true);
        }
    }

    void setDragText(Point point, String string) {
        if (point != null) {
            if (this.textComponent.getParent() == null) {
                this.addComponents();
            }
            this.textComponent.setVisible(true);
            this.textComponent.setText(string);
            this.textComponent.setSize(this.textComponent.getPreferredSize());
            Point point2 = SwingUtilities.convertPoint(this, point, this.textComponent.getParent());
            this.textComponent.setLocation((int)(point2.getX() - (double)(this.textComponent.getWidth() / 2)), (int)(point2.getY() - (double)this.textComponent.getHeight()));
        } else {
            this.textComponent.setVisible(false);
        }
    }

    void setDragRectangle(Rectangle rectangle) {
        if (rectangle != null) {
            if (this.textComponent.getParent() == null) {
                this.addComponents();
            }
            this.rectangleComponent.setVisible(true);
            this.rectangleComponent.setBounds(SwingUtilities.convertRectangle(this, rectangle, this.rectangleComponent.getParent()));
        } else {
            this.rectangleComponent.setVisible(false);
        }
    }

    private void createWindowBars() {
        Direction[] directionArray = Direction.getDirections();
        for (int i = 0; i < directionArray.length; ++i) {
            this.windowBars[i] = new WindowBar(this, directionArray[i]);
            this.windowBars[i].setEnabled(false);
            this.addWindow(this.windowBars[i]);
            this.layeredPane.add(this.windowBars[i].getEdgePanel());
            this.mainPanel.add((Component)this.windowBars[i], new Point(directionArray[i] == Direction.LEFT ? 0 : (directionArray[i] == Direction.RIGHT ? 2 : 1), directionArray[i] == Direction.UP ? 0 : (directionArray[i] == Direction.DOWN ? 2 : 1)));
            this.windowBars[i].addPropertyChangeListener("enabled", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    RootWindow.this.updateMinimizable();
                }
            });
        }
    }

    protected void showChildWindow(DockingWindow dockingWindow) {
        if (this.maximizedWindow != null && dockingWindow == this.window) {
            this.setMaximizedWindow(null);
        }
        super.showChildWindow(dockingWindow);
    }

    protected void update() {
        RootWindowProperties rootWindowProperties = this.getRootWindowProperties();
        rootWindowProperties.getComponentProperties().applyTo(this.shapedPanel);
        InternalPropertiesUtil.applyTo(rootWindowProperties.getShapedPanelProperties(), this.shapedPanel);
        rootWindowProperties.getWindowAreaProperties().applyTo(this.windowPanel);
        InternalPropertiesUtil.applyTo(rootWindowProperties.getWindowAreaShapedPanelProperties(), this.windowPanel);
        rootWindowProperties.getDragLabelProperties().applyTo(this.textComponent);
        InternalPropertiesUtil.applyTo(rootWindowProperties.getDragRectangleShapedPanelProperties(), this.rectangleComponent);
        if (this.rectangleComponent.getComponentPainter() == null) {
            this.rectangleComponent.setComponentPainter(new RectangleComponentPainter(Color.BLACK, Color.WHITE, rootWindowProperties.getDragRectangleBorderWidth()));
        }
    }

    private void addComponents() {
        this.getRootPane().getLayeredPane().add(this.rectangleComponent);
        this.getRootPane().getLayeredPane().setPosition(this.rectangleComponent, 1);
        this.getRootPane().getLayeredPane().add(this.textComponent);
        this.getRootPane().getLayeredPane().setPosition(this.textComponent, 0);
    }

    protected void doReplace(DockingWindow dockingWindow, DockingWindow dockingWindow2) {
        if (dockingWindow == this.window) {
            if (this.window != null) {
                this.windowPanel.remove(this.window);
                this.window.setVisible(true);
            }
            this.window = dockingWindow2;
            if (this.window != null) {
                if (this.maximizedWindow != null) {
                    this.window.setVisible(false);
                }
                this.windowPanel.add(this.window);
                this.revalidate();
            }
        }
    }

    protected void doRemoveWindow(DockingWindow dockingWindow) {
        if (dockingWindow == this.window) {
            this.windowPanel.remove(dockingWindow);
            this.window.setVisible(true);
            this.window = null;
        }
        this.repaint();
    }

    public RootWindow getRootWindow() {
        return this;
    }

    protected boolean acceptsSplitWith(DockingWindow dockingWindow) {
        return false;
    }

    protected DropAction doAcceptDrop(Point point, DockingWindow dockingWindow) {
        DropAction dropAction;
        Point point2;
        if (this.maximizedWindow != null && this.maximizedWindow.contains(point2 = SwingUtilities.convertPoint(this, point, this.maximizedWindow)) && (dropAction = this.maximizedWindow.acceptDrop(point2, dockingWindow)) != null) {
            return dropAction;
        }
        return super.doAcceptDrop(point, dockingWindow);
    }

    protected DropAction acceptInteriorDrop(Point point, DockingWindow dockingWindow) {
        if (this.window != null) {
            return null;
        }
        return new DropAction(){

            public void execute(DockingWindow dockingWindow, MouseEvent mouseEvent) {
                RootWindow.this.setWindow(dockingWindow);
            }
        };
    }

    protected WindowLocation getWindowLocation(DockingWindow dockingWindow) {
        return new WindowRootLocation(this);
    }

    protected PropertyMap getPropertyObject() {
        return this.getRootWindowProperties().getMap();
    }

    protected PropertyMap createPropertyObject() {
        return new RootWindowProperties().getMap();
    }

    boolean windowBarEnabled() {
        for (int i = 0; i < this.windowBars.length; ++i) {
            if (!this.windowBars[i].isEnabled()) continue;
            return true;
        }
        return false;
    }

    void removeWindowComponent(DockingWindow dockingWindow) {
    }

    void restoreWindowComponent(DockingWindow dockingWindow) {
    }

    protected void cleanUpModel() {
        if (!this.cleanUpModel) {
            this.cleanUpModel = true;
            SwingUtilities.invokeLater(this.modelCleanUpEvent);
        }
    }

    protected boolean isShowingInRootWindow() {
        return true;
    }

    private class SingleComponentLayout
    implements LayoutManager {
        private SingleComponentLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void layoutContainer(Container container) {
            Dimension dimension = LayoutUtil.getInteriorSize(container);
            Insets insets = container.getInsets();
            RootWindow.this.mainPanel.setBounds(insets.left, insets.top, dimension.width, dimension.height);
            int n = ((RootWindow)RootWindow.this).windowBars[Direction.LEFT.getValue()].getPreferredSize().width;
            int n2 = ((RootWindow)RootWindow.this).windowBars[Direction.RIGHT.getValue()].getPreferredSize().width;
            int n3 = ((RootWindow)RootWindow.this).windowBars[Direction.UP.getValue()].getPreferredSize().height;
            int n4 = ((RootWindow)RootWindow.this).windowBars[Direction.DOWN.getValue()].getPreferredSize().height;
            Direction[] directionArray = Direction.getDirections();
            for (int i = 0; i < RootWindow.this.windowBars.length; ++i) {
                int n5;
                int n6;
                ResizablePanel resizablePanel = RootWindow.this.windowBars[i].getEdgePanel();
                if (!resizablePanel.isVisible()) continue;
                Direction direction = directionArray[i];
                int n7 = dimension.width - n - n2;
                int n8 = dimension.height - n3 - n4;
                if (direction == Direction.RIGHT) {
                    n6 = container.getWidth() - insets.right - n2 + ((RootWindow)RootWindow.this).windowBars[direction.getValue()].getInsets().left;
                    n5 = Math.min(((Component)resizablePanel).getPreferredSize().width, n7 + ((RootWindow)RootWindow.this).windowBars[direction.getValue()].getInsets().left);
                    resizablePanel.setBounds(n6 - n5, insets.top + n3, n5, n8);
                    continue;
                }
                if (direction == Direction.LEFT) {
                    n6 = insets.left + n - ((RootWindow)RootWindow.this).windowBars[direction.getValue()].getInsets().right;
                    n5 = Math.min(((Component)resizablePanel).getPreferredSize().width, n7 + ((RootWindow)RootWindow.this).windowBars[direction.getValue()].getInsets().right);
                    resizablePanel.setBounds(n6, insets.top + n3, n5, n8);
                    continue;
                }
                if (direction == Direction.DOWN) {
                    n6 = container.getHeight() - insets.bottom - n4 + ((RootWindow)RootWindow.this).windowBars[direction.getValue()].getInsets().top;
                    n5 = Math.min(((Component)resizablePanel).getPreferredSize().height, n8 + ((RootWindow)RootWindow.this).windowBars[direction.getValue()].getInsets().top);
                    resizablePanel.setBounds(insets.left + n, n6 - n5, n7, n5);
                    continue;
                }
                n6 = insets.top + n3 - ((RootWindow)RootWindow.this).windowBars[direction.getValue()].getInsets().bottom;
                n5 = Math.min(((Component)resizablePanel).getPreferredSize().height, n8 + ((RootWindow)RootWindow.this).windowBars[direction.getValue()].getInsets().bottom);
                resizablePanel.setBounds(insets.left + n, n6, n7, n5);
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            return LayoutUtil.add(RootWindow.this.mainPanel.getMinimumSize(), container.getInsets());
        }

        public Dimension preferredLayoutSize(Container container) {
            return LayoutUtil.add(RootWindow.this.mainPanel.getPreferredSize(), container.getInsets());
        }

        public void removeLayoutComponent(Component component) {
        }
    }
}

