/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.RootWindow;
import net.infonode.docking.View;

class FocusManager {
    private static final FocusManager INSTANCE = new FocusManager();
    private int ignoreFocusChanges;
    private Timer focusTimer;
    private ArrayList lastFocusedWindows = new ArrayList();
    private Component focusedComponent;
    private PropertyChangeListener focusListener = new PropertyChangeListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (FocusManager.this.ignoreFocusChanges > 0) {
                return;
            }
            FocusManager.this.ignoreFocusChanges++;
            try {
                FocusManager.this.triggerFocusUpdate();
            }
            finally {
                FocusManager.this.ignoreFocusChanges--;
            }
        }
    };

    private FocusManager() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", this.focusListener);
        this.updateFocus();
    }

    static FocusManager getInstance() {
        return INSTANCE;
    }

    private void updateFocus() {
        this.focusedComponent = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        ArrayList arrayList = this.lastFocusedWindows;
        this.lastFocusedWindows = new ArrayList();
        this.updateWindows(this.focusedComponent, this.focusedComponent, arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            RootWindow rootWindow = (RootWindow)((SoftReference)arrayList.get(i)).get();
            if (rootWindow == null) continue;
            rootWindow.setFocusedView(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pinFocus(Runnable runnable) {
        block3: {
            ++this.ignoreFocusChanges;
            Component component = this.focusedComponent;
            try {
                runnable.run();
                Object var4_3 = null;
                if (--this.ignoreFocusChanges != 0 || component == null) break block3;
                component.requestFocusInWindow();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (--this.ignoreFocusChanges == 0 && component != null) {
                    component.requestFocusInWindow();
                    SwingUtilities.invokeLater(new Runnable(component){
                        private final /* synthetic */ Component val$c;
                        {
                            this.val$c = component;
                        }

                        public void run() {
                            SwingUtilities.invokeLater(new Runnable(this){
                                private final /* synthetic */ 2 this$1;
                                {
                                    this.this$1 = var1_1;
                                }

                                public void run() {
                                    2.access$200(this.this$1).requestFocusInWindow();
                                }
                            });
                        }

                        static /* synthetic */ Component access$200(2 var0) {
                            return var0.val$c;
                        }
                    });
                }
                throw throwable;
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            {
            }
        }
    }

    void startIgnoreFocusChanges() {
        ++this.ignoreFocusChanges;
    }

    void stopIgnoreFocusChanges() {
        if (--this.ignoreFocusChanges == 0) {
            this.updateFocus();
        }
    }

    static void focusWindow(final DockingWindow dockingWindow) {
        if (dockingWindow == null) {
            return;
        }
        dockingWindow.restoreFocus();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 4 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public void run() {
                        4.access$300(this.this$0).restoreFocus();
                    }
                });
            }

            static /* synthetic */ DockingWindow access$300(4 var0) {
                return var0.dockingWindow;
            }
        });
    }

    private View getViewContaining(Component component) {
        return component == null ? null : (component instanceof View ? (View)component : this.getViewContaining(component.getParent()));
    }

    private void updateWindows(Component component, Component component2, ArrayList arrayList) {
        View view;
        while ((view = this.getViewContaining(component2)) != null) {
            view.setLastFocusedComponent(component);
            RootWindow rootWindow = view.getRootWindow();
            if (rootWindow == null) break;
            rootWindow.setFocusedView(view);
            this.lastFocusedWindows.add(new SoftReference<RootWindow>(rootWindow));
            component2 = rootWindow;
            for (int i = 0; i < arrayList.size(); ++i) {
                if (((SoftReference)arrayList.get(i)).get() != component2) continue;
                arrayList.remove(i);
            }
        }
    }

    private void triggerFocusUpdate() {
        if (this.focusTimer != null) {
            return;
        }
        this.focusTimer = new Timer(20, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FocusManager.this.updateFocus();
                FocusManager.this.focusTimer = null;
            }
        });
        this.focusTimer.setRepeats(false);
        this.focusTimer.start();
    }
}

