/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.awt.Dimension;
import java.awt.Point;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Agent;
import madkit.kernel.AgentAddress;
import madkit.kernel.AgentInformation;
import madkit.kernel.Communicator;
import madkit.kernel.Controller;
import madkit.kernel.GraphicShell;
import madkit.kernel.GroupIdentifier;
import madkit.kernel.Keeper;
import madkit.kernel.KernelAddress;
import madkit.kernel.KernelAgent;
import madkit.kernel.Message;
import madkit.kernel.MessageException;
import madkit.kernel.Mirror;
import madkit.kernel.Mobile;
import madkit.kernel.Organization;
import madkit.kernel.Overlooker;
import madkit.kernel.PlaceKeeper;
import madkit.kernel.PrivateMessage;
import madkit.kernel.SiteAgent;
import madkit.kernel.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Kernel {
    public static final int SEND_MESSAGE = 1;
    public static final int SEND_BROADCAST_MESSAGE = 2;
    public static final int KILL_AGENT = 3;
    public static final int CREATE_GROUP = 4;
    public static final int LEAVE_GROUP = 5;
    public static final int ADD_MEMBER_ROLE = 6;
    public static final int REMOVE_MEMBER_ROLE = 7;
    public static final int RESTORE_AGENT = 8;
    public static final int LAUNCH_AGENT = 0;
    public static final int CONNECTED_TO = 9;
    public static final int DISCONNECTED_FROM = 10;
    public static final int NEW_COMMUNITY = 11;
    public static final int DELETE_COMMUNITY = 12;
    static final int HOOKS_NUMBER = 13;
    public static final int GET_GROUPS = 20;
    public static final int GET_AGENTS = 21;
    public static final int DUMP_ORGANIZATION = 22;
    public static final int GET_AGENTINFO = 23;
    public static final int MIGRATION = 17;
    public static final int CONNECTION = 24;
    public static final int DECONNECTION = 25;
    public static final int DUMP_COMMUNITIES = 27;
    public static final String DEFAULT_COMMUNITY = "public";
    public static final String VERSION = "4.1.2 - Arpeggios";
    public static final String BUGREPORT = "Please file bug reports on the madkit forum @ http://www.madkit.org";
    static KernelAddress kernelAddress;
    String kernelName;
    private boolean debug = false;
    private Writer ostream = new OutputStreamWriter(System.err);
    private SiteAgent siteAgent;
    private KernelAgent kernelAgent;
    GraphicShell gui = null;
    private static Map<AgentAddress, AbstractAgent> localAgents;
    private Map<String, Organization> organizations;
    private static ThreadGroup agentsThread;
    static boolean fastSynchronous;
    public static boolean agressiveHeapMode;
    public static int defaultAgentsAllocation;
    static boolean interGroupMessage;
    static int agentsNb;
    static Communicator net;
    private Keeper KeeperAgent = null;

    public static ThreadGroup getAgentThreadGroup() {
        return agentsThread;
    }

    public static int getAgentsNb() {
        return agentsNb;
    }

    public static KernelAddress getAddress() {
        return kernelAddress;
    }

    public void registerGUI(GraphicShell graphicShell) {
        this.gui = graphicShell;
    }

    public String getName() {
        return this.kernelName;
    }

    public Kernel(String string, boolean bl) {
        kernelAddress = new KernelAddress(bl);
        this.kernelName = string;
        this.initialization();
    }

    public Kernel(String string, boolean bl, String string2) {
        kernelAddress = new KernelAddress(bl, string2);
        this.kernelName = string;
        this.initialization();
    }

    public Kernel(String string) {
        this(string, false);
    }

    void initialization() {
        Organization organization = new Organization();
        this.organizations = new Hashtable<String, Organization>();
        this.organizations.put("communities", organization);
        localAgents = agressiveHeapMode ? new HashMap<AgentAddress, AbstractAgent>(defaultAgentsAllocation) : new HashMap<AgentAddress, AbstractAgent>();
        this.kernelAgent = new KernelAgent();
        this.siteAgent = new SiteAgent(this.organizations, this.kernelAgent);
        this.launchAgent(this.siteAgent, "SITEAGENT", this, false);
        System.err.println("\n\t-----------------------------------------------------");
        System.err.println("\n\t\t\t\tMadKit/Aalaadin \n\n\t\t\t  by MadKit Team (c) 1997-2007\n");
        System.err.println("\t\t\tversion: 4.1.2 - Arpeggios\n");
        System.err.println("\t-----------------------------------------------------\n");
        System.err.println("Please file bug reports on the madkit forum @ http://www.madkit.org\n\n");
        this.displayln("MadKit Agent microKernel " + Kernel.getAddress() + " is up and running");
    }

    final int createGroup(AgentAddress agentAddress, boolean bl, String string, String string2, String string3, GroupIdentifier groupIdentifier) {
        int n;
        Organization organization = this.getOrganizationFor(string);
        if (organization == null) {
            organization = this.siteAgent.createCommunity(string);
        }
        if ((n = organization.createGroup(agentAddress, bl, string2, string3, groupIdentifier)) == 1) {
            this.kernelAgent.callHooks(4, agentAddress, string, string2, null);
            if (bl) {
                this.siteAgent.updateDistantOrgs(agentAddress, string, string2);
            }
        }
        return n;
    }

    final int joinPlace(Agent agent, String string, String string2) {
        return this.joinPlace(agent, DEFAULT_COMMUNITY, string, string2);
    }

    final int joinPlace(Agent agent, String string, String string2, String string3) {
        return this.KeeperAgent.joinPlace(agent, string, string2, string3);
    }

    final int createPlace(AgentAddress agentAddress, String string, String string2) {
        if (!this.isGroup(DEFAULT_COMMUNITY, "Mobility")) {
            System.err.println("This application is not yet able to be a mobile one ! You must create a mobile Group first.");
            return -1;
        }
        if (this.isGroup(DEFAULT_COMMUNITY, string)) {
            System.err.println("Place : " + string + " already existing!");
            return -2;
        }
        System.err.println("Creating the placeKeeper");
        PlaceKeeper placeKeeper = null;
        try {
            Class<?> clazz = Utils.loadClass("madkit.mobility.PlaceKeeperAgent");
            Constructor<?> constructor = clazz.getConstructor(Kernel.class, String.class);
            Agent agent = (Agent)constructor.newInstance(this, string);
            placeKeeper = (PlaceKeeper)((Object)agent);
            this.launchAgent(agent, string + ":placeKeeper", this, true);
        }
        catch (Exception exception) {
            System.err.println("Cannot create a placeKeeper: check if the Mobility plugin is available");
            return -1;
        }
        if (this.KeeperAgent.addPlace(placeKeeper, string)) {
            return 1;
        }
        this.killAgent((Agent)((Object)placeKeeper));
        return -1;
    }

    final boolean enableMobility(String string, int n) {
        if (this.KeeperAgent == null) {
            try {
                Class<?> clazz = Utils.loadClass("madkit.mobility.AgencyKeeper");
                Constructor<?> constructor = clazz.getConstructor(KernelAddress.class, String.class);
                Agent agent = (Agent)constructor.newInstance(Kernel.getAddress(), "agencyKeeperOf : " + string);
                this.KeeperAgent = (Keeper)((Object)agent);
                this.launchAgent(agent, "agencyKeeperOf" + Kernel.getAddress(), this, true);
            }
            catch (Exception exception) {
                System.err.println("Cannot create an AgencyKeeper: check if the Mobility plugin is available");
                return false;
            }
            this.kernelName = string;
            kernelAddress.setKernelName(this.kernelName);
            kernelAddress.enableMobility();
            boolean bl = this.launchCommunicator(n);
            if (bl) {
                System.err.println("Mobiliy activated : " + Kernel.getAddress().getInformation());
            } else {
                System.err.println("Cannot activate mobility...");
            }
            return bl;
        }
        System.err.println("A mobility group is already existing!");
        return true;
    }

    boolean launchCommunicator(int n) {
        if (net == null) {
            try {
                Agent agent = null;
                Class<?> clazz = Utils.loadClass("madkit.netcomm.NetAgent");
                if (n == 0) {
                    agent = (Agent)clazz.newInstance();
                } else {
                    Constructor<?> constructor = clazz.getConstructor(Integer.TYPE);
                    agent = (Agent)constructor.newInstance(new Integer(n));
                }
                net = (Communicator)((Object)agent);
                this.launchAgent(agent, "SiteAgent", this, true);
                return true;
            }
            catch (Exception exception) {
                System.err.println("Cannot create a communicator agent" + exception.toString());
                return false;
            }
        }
        return true;
    }

    final boolean supportMobility() {
        return kernelAddress.supportMobility();
    }

    final boolean connectAgencyToAgency(String string, int n) {
        if (this.supportMobility()) {
            if (net == null) {
                this.launchCommunicator(n);
            }
            net.connectAgency(this.kernelName, string, n);
            return true;
        }
        System.err.println("Mobility is not supported yet!! ");
        return false;
    }

    public KernelAddress getAgencyNamed(String string) {
        return this.KeeperAgent.getAgencyNamed(string);
    }

    public synchronized void launchMirror(Mirror mirror, AgentAddress agentAddress, String string, Object object, boolean bl) {
        Point point = new Point(100, 100);
        Dimension dimension = new Dimension(120, 120);
        Agent agent = (Agent)((Object)mirror);
        if (this.debug) {
            this.displayln("Agent launch: " + string + ", created by " + object.toString());
        }
        if (agent.getAgentInformation() == null) {
            agent.setAgentInformation(new AgentInformation(string, object));
            agent.setCurrentKernel(this);
            agent.getAddress().update(agentAddress);
            agent.setCurrentKernel(this);
            localAgents.put(agent.getAddress(), agent);
            if (bl && this.gui != null) {
                this.gui.setupGUI(agent, point, dimension);
            }
            Thread thread = null;
            if (agent instanceof Agent) {
                thread = new Thread(agentsThread, agent, agent.getName() + "_thread");
            }
            if (thread != null) {
                thread.start();
            } else {
                Controller controller = agent.getController();
                if (controller != null) {
                    controller.activate();
                } else {
                    agent.activate();
                }
            }
            ++agentsNb;
            this.kernelAgent.callHooks(0, agent.getAgentInformation());
        } else if (this.debug) {
            this.displayln("ASSERT: agent already registred");
        }
    }

    final synchronized void receiveAgent(AbstractAgent abstractAgent) {
        Thread thread = null;
        if (abstractAgent instanceof Mobile) {
            thread = new Thread((Runnable)((Agent)abstractAgent), abstractAgent.getName() + "_thread");
            if (((Mobile)((Object)abstractAgent)).getMyAgency().equals(kernelAddress)) {
                System.out.println("One of my Mobile Agents is coming back. Welcome!");
                Mirror mirror = (Mirror)((Object)localAgents.get(((Mobile)((Object)abstractAgent)).getMyBirthAddress()));
                this.killAgent((Agent)((Object)mirror));
                ((Mobile)((Object)abstractAgent)).setMirrorAgent(mirror);
                abstractAgent.getAddress().update(((Mobile)((Object)abstractAgent)).getMyBirthAddress());
            } else {
                abstractAgent.getAddress().update(kernelAddress);
            }
            abstractAgent.setCurrentKernel(this);
            localAgents.put(abstractAgent.getAddress(), abstractAgent);
            if (this.gui != null) {
                this.gui.setupGUI(abstractAgent);
            }
            if (thread != null) {
                thread.start();
            } else {
                abstractAgent.activate();
            }
        }
    }

    final int requestRole(AgentAddress agentAddress, String string, String string2, String string3, Object object) {
        Organization organization = this.getOrganizationFor(string);
        if (organization != null) {
            int n = organization.requestRole(agentAddress, string2, string3, object);
            if (n == 1) {
                if (organization.isDistributed(string2)) {
                    this.siteAgent.updateDistantOrgs(6, agentAddress, string, string2, string3, object);
                }
                this.kernelAgent.callHooks(6, agentAddress, string, string2, string3);
            }
            return n;
        }
        return -4;
    }

    final boolean leaveGroup(AgentAddress agentAddress, String string, String string2) {
        Organization organization = this.getOrganizationFor(string);
        if (organization != null && organization.isPlayingRole(agentAddress, string2, "member")) {
            if (organization.isDistributed(string2)) {
                this.siteAgent.updateDistantOrgs(5, agentAddress, string, string2, null, null);
            }
            this.kernelAgent.callHooks(5, agentAddress, string, string2, null);
            if (organization.leaveGroup(agentAddress, string2)) {
                this.siteAgent.removeCommunity(string);
            }
            return true;
        }
        return false;
    }

    final boolean leaveRole(AgentAddress agentAddress, String string, String string2, String string3) {
        Organization organization = this.getOrganizationFor(string);
        if (organization != null && organization.isPlayingRole(agentAddress, string2, string3)) {
            if (organization.isDistributed(string2)) {
                this.siteAgent.updateDistantOrgs(7, agentAddress, string, string2, string3, null);
            }
            if (organization.leaveRole(agentAddress, string2, string3)) {
                this.siteAgent.removeCommunity(string);
            }
            this.kernelAgent.callHooks(7, agentAddress, string, string2, string3);
            return true;
        }
        return false;
    }

    final boolean isBelongingToGroup(AgentAddress agentAddress, String string, String string2) {
        Organization organization = this.getOrganizationFor(string);
        return organization != null && organization.isPlayingRole(agentAddress, string2, "member");
    }

    final boolean addOverlooker(AgentAddress agentAddress, Overlooker overlooker, Object object) {
        Organization organization = this.getOrganizationFor(overlooker.community);
        if (organization == null) {
            return false;
        }
        return organization.addOverlooker(agentAddress, overlooker, object);
    }

    final void removeOverlooker(Overlooker overlooker) {
        Organization organization = this.getOrganizationFor(overlooker.community);
        if (organization != null && organization.removeOverlooker(overlooker)) {
            this.siteAgent.removeCommunity(overlooker.community);
        }
    }

    public final synchronized void launchAgent(AbstractAgent abstractAgent, String string, Object object, boolean bl) {
        this.launchAgent(abstractAgent, string, object, bl, new Point(-1, -1), new Dimension(-1, -1));
    }

    public final synchronized void launchAgent(AbstractAgent abstractAgent, String string, Object object, boolean bl, Point point, Dimension dimension) {
        if (this.debug) {
            this.displayln("Agent launch: " + string + ", created by " + object.toString());
        }
        if (abstractAgent.getAgentInformation() == null) {
            abstractAgent.setAgentInformation(new AgentInformation(string, object));
            abstractAgent.setCurrentKernel(this);
            localAgents.put(abstractAgent.getAddress(), abstractAgent);
            if (bl && this.gui != null) {
                this.gui.setupGUI(abstractAgent, point, dimension);
            }
            Thread thread = null;
            if (abstractAgent instanceof Agent) {
                thread = new Thread((Runnable)((Agent)abstractAgent), abstractAgent.getName() + "_thread");
            }
            if (thread != null) {
                thread.start();
            } else {
                Controller controller = abstractAgent.getController();
                if (controller != null) {
                    controller.activate();
                } else {
                    abstractAgent.activate();
                }
            }
            ++agentsNb;
            this.kernelAgent.callHooks(0, abstractAgent.getAgentInformation());
        } else if (this.debug) {
            this.displayln("ASSERT: agent already registred");
        }
    }

    final void killAgent(AbstractAgent abstractAgent, AbstractAgent abstractAgent2) {
        if (abstractAgent != null && abstractAgent.getAgentInformation() != null && (abstractAgent2.getAddress().equals(abstractAgent.getAgentInformation().getOwner()) || abstractAgent == abstractAgent2)) {
            this.killAgent(abstractAgent);
        }
    }

    public final synchronized void killAgent(AbstractAgent abstractAgent) {
        Controller controller;
        if (abstractAgent.getCurrentKernel() == null) {
            return;
        }
        if (abstractAgent instanceof Agent && Thread.currentThread() != ((Agent)abstractAgent).getAgentThread()) {
            ((Agent)abstractAgent).getAgentThread().stop();
        }
        if ((controller = abstractAgent.getController()) != null) {
            controller.end();
        } else {
            abstractAgent.end();
        }
        this.removeAgentFromOrganizations(abstractAgent.getAddress());
        localAgents.remove(abstractAgent.getAddress());
        if (this.gui != null) {
            this.gui.disposeGUI(abstractAgent);
        }
        abstractAgent.setCurrentKernel(null);
        this.kernelAgent.callHooks(3, abstractAgent.getAgentInformation());
        --agentsNb;
        abstractAgent = null;
    }

    final synchronized void restoreAgent(AbstractAgent abstractAgent, String string, Object object, boolean bl) {
        if (this.debug) {
            this.displayln("Agent restoration: " + string + ", restored by " + object.toString());
        }
        if (abstractAgent.getAgentInformation() != null) {
            abstractAgent.setAgentInformation(new AgentInformation(string, object));
            abstractAgent.setCurrentKernel(this);
            localAgents.put(abstractAgent.getAddress(), abstractAgent);
            if (bl && this.gui != null) {
                this.gui.setupGUI(abstractAgent);
            }
            Thread thread = null;
            if (abstractAgent instanceof Agent) {
                thread = new Thread((Runnable)((Agent)abstractAgent), abstractAgent.getName() + "_thread");
            }
            if (thread != null) {
                thread.start();
            } else {
                abstractAgent.activate();
            }
            this.kernelAgent.callHooks(8, abstractAgent.getAgentInformation());
        } else if (this.debug) {
            this.displayln("ASSERT: restoration impossible: agent has not been previously launched");
        }
    }

    private final synchronized void killAgents() {
        AgentAddress agentAddress = this.kernelAgent.getAddress();
        Iterator<AgentAddress> iterator = localAgents.keySet().iterator();
        while (iterator.hasNext()) {
            AgentAddress agentAddress2 = iterator.next();
            if (!agentAddress2.equals(agentAddress)) {
                this.removeAgentFromOrganizations(agentAddress2);
            }
            iterator.remove();
        }
    }

    final synchronized void removeReferenceOf(AgentAddress agentAddress) {
        if (this.gui != null) {
            try {
                this.gui.disposeGUI(localAgents.get(agentAddress));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        localAgents.remove(agentAddress);
    }

    final void sendMessage(Message message) {
        block6: {
            try {
                if (message.getReceiver().isLocal()) {
                    this.sendLocalMessage((Message)message.clone());
                    if (!(message instanceof PrivateMessage)) {
                        this.kernelAgent.callHooks(1, message);
                    }
                } else if (this.siteAgent.sendDistantMessage(message) && !(message instanceof PrivateMessage)) {
                    this.kernelAgent.callHooks(1, message);
                }
            }
            catch (MessageException messageException) {
                if (!this.debug) break block6;
                this.siteAgent.debug("Unable to send message " + message + " : " + messageException);
            }
        }
    }

    final void sendLocalMessage(Message message) throws MessageException {
        AbstractAgent abstractAgent = localAgents.get(message.getReceiver());
        if (abstractAgent == null) {
            throw new MessageException("Unknown agent");
        }
        abstractAgent.receiveMessage(message);
    }

    final void sendBroadcastMessage(String string, String string2, String string3, Message message) {
        Organization organization = this.getOrganizationFor(string);
        if (organization != null) {
            AgentAddress[] agentAddressArray = organization.getRolePlayers(string2, string3);
            if (!(message instanceof PrivateMessage)) {
                Vector<Object> vector = new Vector<Object>();
                vector.addElement(string2);
                vector.addElement(string3);
                vector.addElement(message);
                this.kernelAgent.callHooks(2, vector);
            }
            for (int i = 0; i < agentAddressArray.length; ++i) {
                Message message2 = (Message)message.clone();
                message2.setReceiver(agentAddressArray[i]);
                try {
                    if (agentAddressArray[i].isLocal()) {
                        this.sendLocalMessage(message2);
                        continue;
                    }
                    this.siteAgent.sendDistantMessage(message2);
                    continue;
                }
                catch (MessageException messageException) {
                    if (!this.debug) continue;
                    this.siteAgent.debug("Unknown agent");
                }
            }
        }
    }

    static final synchronized AbstractAgent getReference(Object object) {
        return localAgents.get(object);
    }

    static final synchronized AgentAddress[] getLocalAgents() {
        return localAgents.keySet().toArray(new AgentAddress[0]);
    }

    final synchronized Organization getOrganizationFor(String string) {
        return this.organizations.get(string);
    }

    final synchronized boolean isGroup(String string, String string2) {
        Organization organization = this.getOrganizationFor(string);
        if (organization != null) {
            return organization.isGroup(string2);
        }
        return false;
    }

    public final synchronized String[] getCurrentGroupsOf(AgentAddress agentAddress, String string) {
        Organization organization = this.getOrganizationFor(string);
        if (organization == null) {
            return new String[0];
        }
        return organization.getCurrentGroupsOf(agentAddress);
    }

    public final synchronized String[] getExistingGroups(String string) {
        Organization organization = this.getOrganizationFor(string);
        if (organization == null) {
            return new String[0];
        }
        return organization.getGroups();
    }

    public final synchronized AgentAddress[] getRolePlayers(String string, String string2, String string3) {
        Organization organization = this.getOrganizationFor(string);
        if (organization == null) {
            return new AgentAddress[0];
        }
        return organization.getRolePlayers(string2, string3);
    }

    final synchronized AgentAddress getRolePlayer(String string, String string2, String string3) {
        Organization organization = this.getOrganizationFor(string);
        if (organization == null) {
            return null;
        }
        return organization.getRolePlayer(string2, string3);
    }

    public final synchronized String[] getGroupRolesOf(AgentAddress agentAddress, String string, String string2) {
        Organization organization = this.getOrganizationFor(string);
        if (organization == null) {
            return new String[0];
        }
        return organization.getGroupRolesOf(agentAddress, string2);
    }

    public final synchronized String[] getExistingRoles(String string, String string2) {
        Organization organization = this.getOrganizationFor(string);
        if (organization == null) {
            return new String[0];
        }
        return organization.getRolesIn(string2);
    }

    final synchronized boolean isCommunity(String string) {
        Organization organization = this.getOrganizationFor("communities");
        return organization.isPlayingRole(this.siteAgent.getAddress(), string, "member") || organization.getRolePlayer(string, "site") != null;
    }

    final synchronized String[] getCommunities() {
        return this.siteAgent.getCommunities();
    }

    final synchronized boolean connectedWithCommunity(String string) {
        return this.getOrganizationFor("communities").isPlayingRole(this.siteAgent.getAddress(), string, "site");
    }

    final synchronized void removeAgentFromOrganizations(AgentAddress agentAddress) {
        String[] stringArray;
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        for (Map.Entry<String, Organization> entry : this.organizations.entrySet()) {
            stringArray = entry.getValue();
            hashMap.put(entry.getKey(), stringArray.getCurrentGroupsOf(agentAddress));
        }
        for (Map.Entry<String, Organization> entry : hashMap.entrySet()) {
            stringArray = (String[])entry.getValue();
            for (int i = 0; i < stringArray.length; ++i) {
                this.leaveGroup(agentAddress, entry.getKey(), stringArray[i]);
            }
        }
    }

    synchronized Map getDumpCommunities() {
        HashMap<String, Map> hashMap = new HashMap<String, Map>();
        for (Map.Entry<String, Organization> entry : this.organizations.entrySet()) {
            hashMap.put(entry.getKey(), entry.getValue().getLocalOrganization());
        }
        return hashMap;
    }

    public final synchronized AgentAddress[] getMembersWithin(String string, String string2) {
        Organization organization = this.getOrganizationFor(string);
        if (organization == null) {
            return new AgentAddress[0];
        }
        return organization.getRolePlayers(string2, "member");
    }

    public void stopKernel() {
        this.displayln("Disconnecting MadKit Kernel: " + this.getName());
        this.displayln("- killing local agents " + this.getName());
        this.killAgents();
        this.displayln("MadKit Kernel closed.");
        System.exit(0);
    }

    public void displayln(String string) {
        this.display(string + '\n');
    }

    public void display(String string) {
        System.err.print("<" + this.getName() + "> : " + string);
    }

    public void setOutputStream(Writer writer) {
        this.ostream = writer;
    }

    final void disposeGUIOf(AbstractAgent abstractAgent) {
        if (this.gui != null) {
            this.gui.disposeGUIImmediatly(abstractAgent);
        }
    }

    final void redisplayGUIOf(AbstractAgent abstractAgent) {
        if (this.gui != null) {
            this.gui.setupGUI(abstractAgent);
        }
    }

    public Vector getCurrentGroups(AgentAddress agentAddress) {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = this.getCurrentGroupsOf(agentAddress, DEFAULT_COMMUNITY);
        for (int i = 0; i < stringArray.length; ++i) {
            vector.addElement(stringArray[i]);
        }
        return vector;
    }

    public synchronized Enumeration getGroupMembers(String string) {
        HashSet<AgentAddress> hashSet = new HashSet<AgentAddress>();
        AgentAddress[] agentAddressArray = this.getMembersWithin(string, DEFAULT_COMMUNITY);
        for (int i = 0; i < agentAddressArray.length; ++i) {
            hashSet.add(agentAddressArray[i]);
        }
        return Collections.enumeration(hashSet);
    }

    public synchronized Vector getMemberRoles(String string, AgentAddress agentAddress) {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = this.getGroupRolesOf(agentAddress, DEFAULT_COMMUNITY, string);
        for (int i = 0; i < stringArray.length; ++i) {
            vector.addElement(stringArray[i]);
        }
        return vector;
    }

    void synchronizeKernel(Map<String, Organization> map, boolean bl) {
        for (Map.Entry<String, Organization> entry : map.entrySet()) {
            if (!this.siteAgent.connectedWith(entry.getKey())) continue;
            if (!this.organizations.containsKey(entry.getKey())) {
                this.organizations.put(entry.getKey(), new Organization());
            }
            this.organizations.get(entry.getKey()).importOrg(entry.getValue(), bl);
        }
        this.siteAgent.refreshCommunities();
    }

    public static void debugString() {
        System.err.println("--------------------------------------kernel status");
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        Thread[] threadArray = new Thread[threadGroup.activeCount()];
        threadGroup.enumerate(threadArray);
        for (int i = 0; i < threadArray.length; ++i) {
            if (threadArray[i] == null) continue;
            System.err.println("" + i + ":  " + threadArray[i] + " is demon " + threadArray[i].isDaemon());
        }
        System.err.println("used memory: " + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()));
        System.err.println("locals agents are " + localAgents.size());
    }

    static {
        localAgents = null;
        agentsThread = new ThreadGroup("agents");
        fastSynchronous = false;
        agressiveHeapMode = false;
        defaultAgentsAllocation = 2000;
        interGroupMessage = true;
        agentsNb = 0;
        net = null;
    }
}

