/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import madkit.kernel.AgentAddress;
import madkit.kernel.GroupIdentifier;
import madkit.kernel.Kernel;
import madkit.kernel.Overlooker;
import madkit.kernel.Role;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Group
extends HashMap<String, Role> {
    private boolean distributed = false;
    private String description = null;
    private GroupIdentifier groupGate = null;

    Group() {
    }

    Group(AgentAddress agentAddress, boolean bl, String string, GroupIdentifier groupIdentifier) {
        this.realCreation(agentAddress, bl, string, groupIdentifier);
    }

    void realCreation(AgentAddress agentAddress, boolean bl, String string, GroupIdentifier groupIdentifier) {
        Serializable serializable;
        if (this.containsKey("group manager")) {
            serializable = this.getRolePlayer("group manager");
            if (serializable != null) {
                ((Role)this.get("group manager")).removeMember((AgentAddress)serializable);
            }
            ((Role)this.get("group manager")).addMember(agentAddress);
        } else {
            serializable = new Role(1);
            ((Role)serializable).addMember(agentAddress);
            this.put("group manager", serializable);
        }
        if (this.containsKey("member")) {
            ((Role)this.get("member")).addMember(agentAddress);
        } else {
            serializable = Kernel.agressiveHeapMode ? new Role(Kernel.defaultAgentsAllocation) : new Role();
            ((Role)serializable).addMember(agentAddress);
            this.put("member", serializable);
        }
        this.distributed = bl;
        this.description = string;
        this.groupGate = groupIdentifier;
    }

    private int roleAssignment(AgentAddress agentAddress, String string) {
        Role role = (Role)this.get(string);
        if (role != null) {
            if (role.addMember(agentAddress)) {
                ((Role)this.get("member")).addMember(agentAddress);
                return 1;
            }
            return -2;
        }
        string.intern();
        role = new Role();
        role.addMember(agentAddress);
        this.put(string, role);
        ((Role)this.get("member")).addMember(agentAddress);
        return 1;
    }

    int requestRole(AgentAddress agentAddress, String string, Object object) {
        if (this.groupGate != null) {
            if (this.groupGate.allowAgentToTakeRole(agentAddress, string, object)) {
                return this.roleAssignment(agentAddress, string);
            }
            return -1;
        }
        return this.roleAssignment(agentAddress, string);
    }

    boolean leave(AgentAddress agentAddress) {
        Iterator iterator = this.values().iterator();
        while (iterator.hasNext()) {
            if (!((Role)iterator.next()).removeMember(agentAddress)) continue;
            iterator.remove();
        }
        return super.isEmpty();
    }

    boolean leaveRole(AgentAddress agentAddress, String string) {
        try {
            if (((Role)this.get(string)).removeMember(agentAddress)) {
                this.remove(string);
                return super.isEmpty();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    boolean addOverlooker(AgentAddress agentAddress, Overlooker overlooker, Object object) {
        if (this.groupGate != null && !this.groupGate.allowOverlooking(agentAddress, object)) {
            return false;
        }
        if (this.containsKey(overlooker.role)) {
            return ((Role)this.get(overlooker.role)).addOverlooker(overlooker);
        }
        Role role = Kernel.agressiveHeapMode ? new Role(Kernel.defaultAgentsAllocation) : new Role();
        this.put(overlooker.role, role);
        return role.addOverlooker(overlooker);
    }

    boolean removeOverlooker(Overlooker overlooker) {
        try {
            if (((Role)this.get(overlooker.role)).removeOverlooker(overlooker)) {
                this.remove(overlooker.role);
                return super.isEmpty();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    boolean isDistributed() {
        return this.distributed;
    }

    @Override
    public boolean isEmpty() {
        try {
            return ((Role)this.get("member")).isEmpty();
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
            return true;
        }
    }

    boolean isPlayingRole(AgentAddress agentAddress, String string) {
        try {
            return ((Role)this.get(string)).contains(agentAddress);
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    AgentAddress[] getRolePlayers(String string) {
        try {
            return ((Role)this.get(string)).toArray(new AgentAddress[((Role)this.get(string)).size()]);
        }
        catch (NullPointerException nullPointerException) {
            return new AgentAddress[0];
        }
    }

    AgentAddress getRolePlayer(String string) {
        AgentAddress[] agentAddressArray = this.getRolePlayers(string);
        if (agentAddressArray.length > 0) {
            return agentAddressArray[(int)(Math.random() * (double)agentAddressArray.length)];
        }
        return null;
    }

    String[] getRolesOf(AgentAddress agentAddress) {
        TreeSet treeSet = new TreeSet();
        for (Map.Entry entry : this.entrySet()) {
            if (!((Role)entry.getValue()).contains(agentAddress)) continue;
            treeSet.add(entry.getKey());
        }
        return treeSet.toArray(new String[treeSet.size()]);
    }

    String[] availableRoles() {
        TreeSet treeSet = new TreeSet();
        for (Map.Entry entry : this.entrySet()) {
            if (((Role)entry.getValue()).isEmpty()) continue;
            treeSet.add(entry.getKey());
        }
        return treeSet.toArray(new String[treeSet.size()]);
    }

    Map mapForm() {
        Hashtable hashtable = new Hashtable();
        for (Map.Entry entry : this.entrySet()) {
            if (((Collection)entry.getValue()).isEmpty()) continue;
            hashtable.put(entry.getKey(), new Vector((Collection)entry.getValue()));
        }
        return hashtable;
    }

    void merge(Group group, boolean bl) {
        if (bl) {
            if (group.getRolePlayer("group manager") != null) {
                this.realCreation(group.getRolePlayer("group manager"), true, group.getDescription(), group.getGroupIdentifier());
            }
        } else if (this.getRolePlayer("group manager") == null || this.isEmpty() && group.getRolePlayer("member") != null) {
            this.realCreation(group.getRolePlayer("member"), true, this.getDescription(), this.getGroupIdentifier());
        }
        if (this.isEmpty()) {
            Role role = Kernel.agressiveHeapMode ? new Role(Kernel.defaultAgentsAllocation) : new Role();
            this.put("member", role);
        }
        for (String string : group.keySet()) {
            if (string.equals("group manager")) continue;
            for (AgentAddress agentAddress : (Role)group.get(string)) {
                this.roleAssignment(agentAddress, string);
            }
        }
    }

    GroupIdentifier getGroupIdentifier() {
        return this.groupGate;
    }

    String getDescription() {
        return this.description;
    }
}

