/*
 * Decompiled with CFR 0.152.
 */
package madkit.games.tictactoe;

import madkit.games.tictactoe.GameCases;
import madkit.games.tictactoe.GameCasesFrame;
import madkit.kernel.Agent;
import madkit.kernel.AgentAddress;
import madkit.kernel.Message;
import madkit.kernel.StringMessage;
import madkit.messages.ActMessage;

public class TicTacToeAgent
extends Agent {
    GameCasesFrame gui;
    GameCases game;
    String community = "demogames";
    String group = "tictactoe";
    boolean master = false;
    boolean living = true;

    void setGame(GameCases gameCases) {
        this.game = gameCases;
    }

    boolean getMaster() {
        return this.master;
    }

    void setMaster(boolean bl) {
        this.master = bl;
    }

    public TicTacToeAgent() {
    }

    public TicTacToeAgent(String string) {
        this.group = string;
    }

    public void initGUI() {
        this.gui = new GameCasesFrame(this);
        this.gui.newDefaultGame();
        this.game = this.gui.getGame();
        this.setGUIObject(this.gui);
    }

    public void activate() {
        if (this.createGroup(true, this.community, this.group, null, null) == 1) {
            this.requestRole(this.community, this.group, "player", null);
            this.gui.setColor(1);
            this.master = true;
            this.gui.setMaster(this.master);
            this.gui.message("Hello I am the master");
            this.game.setWaiting(true);
        } else {
            this.gui.setColor(0);
            this.game.setWaiting(true);
            this.requestRole(this.community, this.group, "player", null);
        }
        if (!this.master) {
            this.sendMessage(this.community, this.group, "player", (Message)new ActMessage("joining"));
        }
    }

    void sendOther(Message message) {
        AgentAddress agentAddress = null;
        AgentAddress[] agentAddressArray = this.getAgentsWithRole(this.community, this.group, "player");
        for (int i = 0; i < agentAddressArray.length; ++i) {
            AgentAddress agentAddress2 = agentAddressArray[i];
            if (agentAddress2.equals((Object)this.getAddress())) continue;
            agentAddress = agentAddress2;
            break;
        }
        if (agentAddress != null) {
            this.sendMessage(agentAddress, message);
        }
    }

    void sendPosition(int n, int n2, int n3) {
        int[] nArray = new int[]{n, n2, n3};
        this.sendMessage(this.community, this.group, "player", (Message)new ActMessage("position", (Object)nArray));
    }

    void sendNewGame(int n, int n2, int n3) {
        int[] nArray = new int[]{n, n2, n3};
        this.sendMessage(this.community, this.group, "player", (Message)new ActMessage("newGame", (Object)nArray));
    }

    void handleMessage(ActMessage actMessage) {
        int[] nArray;
        if (actMessage.getAction().equals("joining")) {
            this.game.setWaiting(false);
            this.gui.newGame();
            this.gui.message("A player has joined, you may start to play");
        }
        if (actMessage.getAction().equals("position")) {
            nArray = (int[])actMessage.getObject();
            this.game.receivePlay(nArray[0], nArray[1], nArray[2]);
        }
        if (actMessage.getAction().equals("newGame")) {
            nArray = (int[])actMessage.getObject();
            this.game.setWaiting(true);
            this.gui.newGame(nArray[0], nArray[1], nArray[2]);
        }
    }

    public void live() {
        while (this.living) {
            Message message = this.waitNextMessage();
            if (message instanceof ActMessage) {
                this.handleMessage((ActMessage)message);
                continue;
            }
            if (!(message instanceof StringMessage)) continue;
            this.gui.message(((StringMessage)message).getString());
        }
    }
}

