/*
 * Decompiled with CFR 0.152.
 */
package madkit.games.tictactoe;

import madkit.games.tictactoe.GameCasesDisplay;
import madkit.games.tictactoe.GameCasesFrame;
import madkit.games.tictactoe.Piece;
import madkit.games.tictactoe.TicTacToeAgent;

public abstract class GameCases {
    int width = 5;
    int height = 5;
    int numberAlignment = 5;
    boolean waiting = true;
    int currentColor = 1;
    public static String[] noms = new String[]{"Red", "Blue"};
    Piece[][] cases;
    GameCasesDisplay display;
    GameCasesFrame jf;
    TicTacToeAgent ag;

    void setWaiting(boolean bl) {
        this.waiting = bl;
    }

    void setCurrentColor(int n) {
        this.currentColor = n;
    }

    GameCasesDisplay getDisplay() {
        return this.display;
    }

    void setDisplay(GameCasesDisplay gameCasesDisplay) {
        this.display = gameCasesDisplay;
    }

    void setAgent(TicTacToeAgent ticTacToeAgent) {
        this.ag = ticTacToeAgent;
    }

    public GameCases(GameCasesFrame gameCasesFrame, int n, int n2) {
        this.jf = gameCasesFrame;
        this.height = n;
        this.width = n;
        this.numberAlignment = n2;
    }

    Piece takePiece(int n, int n2) {
        return this.cases[n][n2];
    }

    void newGame() {
        this.currentColor = 1;
        this.cases = new Piece[this.width][this.height];
        if (this.ag.getMaster()) {
            this.message("You may start");
            this.waiting = false;
        } else {
            this.message("A new game has started, wait for the 'master' to play");
            this.waiting = true;
            this.currentColor = 0;
        }
    }

    void message(String string) {
        this.jf.message(string);
    }

    boolean isValid(int n, int n2) {
        return n >= 0 && n < this.width && n2 >= 0 && n2 < this.height;
    }

    boolean isOccupied(int n, int n2) {
        return this.isValid(n, n2) && this.cases[n][n2] != null;
    }

    void createPiece(int n, int n2, int n3) {
        if (this.isValid(n, n2)) {
            // empty if block
        }
    }

    boolean setPiece(Piece piece, int n, int n2) {
        if (this.isValid(n, n2) && !this.isOccupied(n, n2)) {
            this.cases[n][n2] = piece;
            return true;
        }
        return false;
    }

    boolean deletePiece(Piece piece, int n, int n2) {
        if (this.isOccupied(n, n2) && this.cases[n][n2] == piece) {
            this.cases[n][n2] = null;
            return true;
        }
        return false;
    }

    boolean lookForConfiguration() {
        for (int i = 0; i < this.width; ++i) {
            for (int j = this.height - 1; j >= 0; --j) {
                if (this.cases[i][j] == null || !this.cases[i][j].tryAllLines(this.numberAlignment - 1)) continue;
                return true;
            }
        }
        return false;
    }

    void receivePlay(int n, int n2, int n3) {
        this.installPosition(n, n2, n3);
        boolean bl = this.lookForConfiguration();
        if (bl) {
            this.waiting = true;
            this.message("Tt's sad, but you have lost..");
        } else {
            this.waiting = false;
            this.message("It's your turn to play");
        }
    }

    void doClick(int n, int n2) {
        boolean bl;
        if (!this.waiting && (bl = this.installPosition(n, n2, this.currentColor))) {
            boolean bl2 = this.lookForConfiguration();
            this.waiting = true;
            this.ag.sendPosition(n, n2, this.currentColor);
            if (bl2) {
                this.message("Contratulations!! you win!!");
            } else {
                this.message("Waiting the other one's play");
            }
        }
    }

    abstract boolean installPosition(int var1, int var2, int var3);
}

