/*
 * Decompiled with CFR 0.152.
 */
package madkit.TreeTools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import madkit.TreeTools.GenericIconDescriptor;
import madkit.TreeTools.GenericTreeCellRenderer;
import madkit.TreeTools.GenericTreeNode;

public class GenericTree
extends JPanel
implements MouseListener {
    protected JTree tree;
    protected GenericTreeNode top;
    protected DefaultTreeModel treeModel;
    protected GenericTreeCellRenderer myRenderer;
    JScrollPane scrollPane;

    public GenericTree() {
    }

    public GenericTree(GenericTreeNode genericTreeNode) {
        this.top = genericTreeNode;
    }

    protected void installTree() {
        this.treeModel = new DefaultTreeModel(this.top);
        this.myRenderer = new GenericTreeCellRenderer();
        this.tree = new JTree(this.treeModel);
        this.tree.setCellRenderer(this.myRenderer);
        this.tree.addMouseListener(this);
        this.setLayout(new BorderLayout());
        this.scrollPane = new JScrollPane();
        this.scrollPane.setViewportView(this.tree);
        this.add((Component)this.scrollPane, "Center");
    }

    public JTree getTree() {
        return this.tree;
    }

    public DefaultTreeModel getTreeModel() {
        return this.treeModel;
    }

    public GenericTreeNode getRootNode() {
        return this.top;
    }

    public void addNode(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2) {
        this.treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, this.treeModel.getChildCount(defaultMutableTreeNode));
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = this.tree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (n != -1) {
            if (mouseEvent.getClickCount() == 2) {
                this.LeftDoubleClick(mouseEvent);
            } else if (mouseEvent.getClickCount() == 1 && (mouseEvent.getModifiers() & 4) == 4) {
                this.RightClick(mouseEvent);
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void LeftDoubleClick(MouseEvent mouseEvent) {
        TreePath treePath = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        GenericTreeNode genericTreeNode = (GenericTreeNode)treePath.getLastPathComponent();
        genericTreeNode.execute();
    }

    public void RightClick(MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu;
        TreePath treePath = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        GenericTreeNode genericTreeNode = (GenericTreeNode)treePath.getLastPathComponent();
        GenericIconDescriptor genericIconDescriptor = genericTreeNode.getDescriptor();
        if (genericIconDescriptor != null && (jPopupMenu = genericIconDescriptor.getPopup()) != null) {
            genericIconDescriptor.setArg(genericTreeNode);
            jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

