/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BshClassManager;
import bsh.Capabilities;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.LHS;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.ReflectError;
import bsh.ReflectManager;
import bsh.SimpleNode;
import bsh.StringUtil;
import bsh.TargetError;
import bsh.This;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;

class Reflect {
    Reflect() {
    }

    public static Object invokeObjectMethod(Interpreter interpreter, Object object, String methodName, Object[] args, SimpleNode callerInfo) throws ReflectError, InvocationTargetException, EvalError {
        if (object instanceof This && !Reflect.showThisMethod(methodName)) {
            return ((This)object).invokeMethod(methodName, args, interpreter, null, callerInfo);
        }
        return Reflect.invokeMethod(object.getClass(), object, methodName, args, false);
    }

    private static boolean showThisMethod(String name) {
        return name.equals("getClass") || name.equals("invokeMethod");
    }

    public static Object invokeStaticMethod(Class clas, String methodName, Object[] args) throws ReflectError, InvocationTargetException, EvalError {
        Interpreter.debug("invoke static Method");
        return Reflect.invokeMethod(clas, null, methodName, args, true);
    }

    public static Object getIndex(Object array, int index) throws ReflectError, TargetError {
        if (Interpreter.DEBUG) {
            Interpreter.debug("getIndex: " + array + ", index=" + index);
        }
        try {
            Object val = Array.get(array, index);
            return Reflect.wrapPrimitive(val, array.getClass().getComponentType());
        }
        catch (ArrayIndexOutOfBoundsException e1) {
            throw new TargetError("Array Index", e1);
        }
        catch (Exception e) {
            throw new ReflectError("Array access:" + e);
        }
    }

    public static void setIndex(Object array, int index, Object val) throws ReflectError, TargetError {
        try {
            val = Reflect.unwrapPrimitive(val);
            Array.set(array, index, val);
        }
        catch (ArrayStoreException e2) {
            throw new TargetError("Array store exception", e2);
        }
        catch (IllegalArgumentException e1) {
            throw new TargetError("Illegal Argument", new ArrayStoreException(e1.toString()));
        }
        catch (Exception e) {
            throw new ReflectError("Array access:" + e);
        }
    }

    public static Object getStaticField(Class clas, String fieldName) throws ReflectError {
        return Reflect.getFieldValue(clas, null, fieldName);
    }

    public static Object getObjectField(Object object, String fieldName) throws ReflectError {
        if (object instanceof This) {
            return ((This)object).namespace.getVariable(fieldName);
        }
        try {
            return Reflect.getFieldValue(object.getClass(), object, fieldName);
        }
        catch (ReflectError e) {
            if (Reflect.hasObjectPropertyGetter(object.getClass(), fieldName)) {
                return Reflect.getObjectProperty(object, fieldName);
            }
            throw e;
        }
    }

    static LHS getLHSStaticField(Class clas, String fieldName) throws ReflectError {
        Field f = Reflect.getField(clas, fieldName);
        return new LHS(f);
    }

    static LHS getLHSObjectField(Object object, String fieldName) throws ReflectError {
        if (object instanceof This) {
            return new LHS(((This)object).namespace, fieldName);
        }
        try {
            Field f = Reflect.getField(object.getClass(), fieldName);
            return new LHS(object, f);
        }
        catch (ReflectError e) {
            if (Reflect.hasObjectPropertySetter(object.getClass(), fieldName)) {
                return new LHS(object, fieldName);
            }
            throw e;
        }
    }

    private static Object getFieldValue(Class clas, Object object, String fieldName) throws ReflectError {
        try {
            Field f = Reflect.getField(clas, fieldName);
            if (f == null) {
                throw new ReflectError("internal: field not found:" + fieldName);
            }
            Object value = f.get(object);
            Class<?> returnType = f.getType();
            return Reflect.wrapPrimitive(value, returnType);
        }
        catch (NullPointerException e) {
            throw new ReflectError("???" + fieldName + " is not a static field.");
        }
        catch (IllegalAccessException e) {
            throw new ReflectError("Can't access field: " + fieldName);
        }
    }

    private static Field getField(Class clas, String fieldName) throws ReflectError {
        try {
            if (Capabilities.haveAccessibility()) {
                return Reflect.findAccessibleField(clas, fieldName);
            }
            return clas.getField(fieldName);
        }
        catch (NoSuchFieldException e) {
            throw new ReflectError("No such field: " + fieldName);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static Field findAccessibleField(Class clas, String fieldName) throws NoSuchFieldException {
        try {
            return clas.getField(fieldName);
        }
        catch (NoSuchFieldException var2_2) {
            ** while (clas != null)
        }
lbl-1000:
        // 1 sources

        {
            try {
                field = clas.getDeclaredField(fieldName);
                if (ReflectManager.RMSetAccessible(field)) {
                    return field;
                }
            }
            catch (NoSuchFieldException var2_4) {
                // empty catch block
            }
            clas = clas.getSuperclass();
            continue;
        }
lbl14:
        // 1 sources

        throw new NoSuchFieldException(fieldName);
    }

    private static Object invokeMethod(Class clas, Object object, String name, Object[] args, boolean onlyStatic) throws ReflectError, InvocationTargetException, EvalError {
        if (object == Primitive.NULL) {
            throw new TargetError("Attempt to invoke method " + name + " on null value", new NullPointerException());
        }
        if (object == Primitive.VOID) {
            throw new EvalError("Attempt to invoke method " + name + " on undefined variable or class name");
        }
        if (args == null) {
            args = new Object[]{};
        }
        int i = 0;
        while (i < args.length) {
            if (args[i] == Primitive.VOID) {
                throw new ReflectError("Attempt to pass void argument (position " + i + ") to method: " + name);
            }
            ++i;
        }
        Class<?> returnType = null;
        Object returnValue = null;
        Class[] types = Reflect.getTypes(args);
        Reflect.unwrapPrimitives(args);
        try {
            Method m = null;
            try {
                m = Reflect.findAccessibleMethod(clas, name, types, onlyStatic);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (m == null && Interpreter.DEBUG) {
                Interpreter.debug("Exact method " + StringUtil.methodString(name, types) + " not found in '" + clas.getName() + "'");
            }
            if (m == null) {
                if (types.length == 0) {
                    throw new ReflectError("No args " + (onlyStatic ? "static " : "") + "method " + StringUtil.methodString(name, types) + " not found in class'" + clas.getName() + "'");
                }
                Method[] methods = clas.getMethods();
                if (onlyStatic) {
                    methods = Reflect.retainStaticMethods(methods);
                }
                m = Reflect.findMostSpecificMethod(name, types, methods);
                methods = clas.getMethods();
                if (m == null) {
                    m = Reflect.findExtendedMethod(name, args, methods);
                }
                if (m != null) {
                    try {
                        m = Reflect.findAccessibleMethod(clas, m.getName(), m.getParameterTypes(), onlyStatic);
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                }
            }
            if (m == null) {
                throw new ReflectError(String.valueOf(onlyStatic ? "Static method " : "Method ") + StringUtil.methodString(name, types) + " not found in class'" + clas.getName() + "'");
            }
            returnValue = m.invoke(object, args);
            if (returnValue == null) {
                returnValue = Primitive.NULL;
            }
            returnType = m.getReturnType();
        }
        catch (IllegalAccessException e) {
            throw new ReflectError("Cannot access method " + StringUtil.methodString(name, types) + " in '" + clas.getName() + "' :" + e);
        }
        return Reflect.wrapPrimitive(returnValue, returnType);
    }

    private static Method[] retainStaticMethods(Method[] methods) {
        Vector<Method> v = new Vector<Method>();
        int i = 0;
        while (i < methods.length) {
            if (Modifier.isStatic(methods[i].getModifiers())) {
                v.addElement(methods[i]);
            }
            ++i;
        }
        Object[] ma = new Method[v.size()];
        v.copyInto(ma);
        return ma;
    }

    static Method findAccessibleMethod(Class clas, String name, Class[] types, boolean onlyStatic) {
        Method meth = null;
        Vector classQ = new Vector();
        classQ.addElement(clas);
        Method found = null;
        while (classQ.size() > 0) {
            Class superclass;
            Class c = (Class)classQ.firstElement();
            classQ.removeElementAt(0);
            if (Modifier.isPublic(c.getModifiers()) || Capabilities.haveAccessibility()) {
                try {
                    meth = c.getDeclaredMethod(name, types);
                    if (Modifier.isPublic(meth.getModifiers()) && Modifier.isPublic(c.getModifiers()) || Capabilities.haveAccessibility() && ReflectManager.RMSetAccessible(meth)) {
                        found = meth;
                        break;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (!c.isInterface() && (superclass = c.getSuperclass()) != null) {
                classQ.addElement(superclass);
            }
            Class<?>[] intfs = c.getInterfaces();
            int i = 0;
            while (i < intfs.length) {
                classQ.addElement(intfs[i]);
                ++i;
            }
        }
        if (found != null && (!onlyStatic || Modifier.isStatic(found.getModifiers()))) {
            return found;
        }
        return null;
    }

    private static Object wrapPrimitive(Object value, Class returnType) throws ReflectError {
        if (value == null) {
            return Primitive.NULL;
        }
        if (returnType == Void.TYPE) {
            return Primitive.VOID;
        }
        if (returnType.isPrimitive()) {
            if (value instanceof Number) {
                return new Primitive((Number)value);
            }
            if (value instanceof Boolean) {
                return new Primitive((Boolean)value);
            }
            if (value instanceof Character) {
                return new Primitive((Character)value);
            }
            throw new ReflectError("Something bad happened");
        }
        return value;
    }

    public static Class[] getTypes(Object[] args) {
        if (args == null) {
            return new Class[0];
        }
        Class[] types = new Class[args.length];
        int i = 0;
        while (i < args.length) {
            if (args[i] == null) {
                throw new InterpreterError("Null arg in getTypes()");
            }
            types[i] = args[i] instanceof Primitive ? ((Primitive)args[i]).getType() : args[i].getClass();
            ++i;
        }
        return types;
    }

    private static void unwrapPrimitives(Object[] args) {
        int i = 0;
        while (i < args.length) {
            args[i] = Reflect.unwrapPrimitive(args[i]);
            ++i;
        }
    }

    private static Object unwrapPrimitive(Object arg) {
        if (arg instanceof Primitive) {
            return ((Primitive)arg).getValue();
        }
        return arg;
    }

    static Object constructObject(String clas, Object[] args) throws ReflectError, InvocationTargetException {
        Class c = BshClassManager.classForName(clas);
        if (c == null) {
            throw new ReflectError("Class not found: " + clas);
        }
        return Reflect.constructObject(c, args);
    }

    static Object constructObject(Class clas, Object[] args) throws ReflectError, InvocationTargetException {
        int i = 0;
        while (i < args.length) {
            if (args[i] == Primitive.VOID) {
                throw new ReflectError("Attempt to pass void argument (position " + i + ") to constructor for: " + clas);
            }
            ++i;
        }
        if (clas.isInterface()) {
            throw new ReflectError("Can't create instance of an interface: " + clas);
        }
        Object obj = null;
        Class[] types = Reflect.getTypes(args);
        Reflect.unwrapPrimitives(args);
        Constructor con = null;
        Constructor[] constructors = clas.getDeclaredConstructors();
        if (Interpreter.DEBUG) {
            Interpreter.debug("Looking for most specific constructor: " + clas);
        }
        if ((con = Reflect.findMostSpecificConstructor(types, constructors)) == null) {
            if (types.length == 0) {
                throw new ReflectError("Can't find default constructor for: " + clas);
            }
            con = Reflect.findExtendedConstructor(args, constructors);
        }
        if (con == null) {
            throw new ReflectError("Can't find constructor: " + clas);
        }
        try {
            obj = con.newInstance(args);
        }
        catch (InstantiationException e) {
            throw new ReflectError("the class is abstract ");
        }
        catch (IllegalAccessException e) {
            throw new ReflectError("we don't have permission to create an instance");
        }
        catch (IllegalArgumentException e) {
            throw new ReflectError("the number of arguments was wrong");
        }
        if (obj == null) {
            throw new ReflectError("couldn't construct the object");
        }
        return obj;
    }

    static Method findMostSpecificMethod(String name, Class[] idealMatch, Method[] methods) {
        int match;
        Vector<Class<?>[]> sigs = new Vector<Class<?>[]>();
        Vector<Method> meths = new Vector<Method>();
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getName().equals(name)) {
                meths.addElement(methods[i]);
                sigs.addElement(methods[i].getParameterTypes());
            }
            ++i;
        }
        Class[][] candidates = new Class[sigs.size()][];
        sigs.copyInto((Object[])candidates);
        if (Interpreter.DEBUG) {
            Interpreter.debug("Looking for most specific method: " + name);
        }
        if ((match = Reflect.findMostSpecificSignature(idealMatch, candidates)) == -1) {
            return null;
        }
        return (Method)meths.elementAt(match);
    }

    static Method findExtendedMethod(String name, Object[] args, Method[] methods) {
        Object bestMatch = null;
        Object[] tempArgs = new Object[args.length];
        int i = 0;
        while (i < methods.length) {
            Class<?>[] parameters;
            Method currentMethod = methods[i];
            if (name.equals(currentMethod.getName()) && (parameters = currentMethod.getParameterTypes()).length == args.length) {
                try {
                    int j = 0;
                    while (j < parameters.length) {
                        tempArgs[j] = NameSpace.getAssignableForm(args[j], parameters[j]);
                        ++j;
                    }
                    System.arraycopy(tempArgs, 0, args, 0, args.length);
                    return currentMethod;
                }
                catch (EvalError evalError) {
                    // empty catch block
                }
            }
            ++i;
        }
        return null;
    }

    static Constructor findMostSpecificConstructor(Class[] idealMatch, Constructor[] constructors) {
        Class[][] candidates = new Class[constructors.length][];
        int i = 0;
        while (i < candidates.length) {
            candidates[i] = constructors[i].getParameterTypes();
            ++i;
        }
        int match = Reflect.findMostSpecificSignature(idealMatch, candidates);
        if (match == -1) {
            return null;
        }
        return constructors[match];
    }

    static Constructor findExtendedConstructor(Object[] args, Constructor[] constructors) {
        Object bestMatch = null;
        Object[] tempArgs = new Object[args.length];
        int i = 0;
        while (i < constructors.length) {
            Constructor currentConstructor = constructors[i];
            Class<?>[] parameters = currentConstructor.getParameterTypes();
            if (parameters.length == args.length) {
                try {
                    int j = 0;
                    while (j < parameters.length) {
                        tempArgs[j] = NameSpace.getAssignableForm(args[j], parameters[j]);
                        ++j;
                    }
                    System.arraycopy(tempArgs, 0, args, 0, args.length);
                    return currentConstructor;
                }
                catch (EvalError evalError) {
                    // empty catch block
                }
            }
            ++i;
        }
        return null;
    }

    static int findMostSpecificSignature(Class[] idealMatch, Class[][] candidates) {
        Class[] bestMatch = null;
        int bestMatchIndex = -1;
        int i = 0;
        while (i < candidates.length) {
            Class[] targetMatch = candidates[i];
            if (Reflect.isAssignable(idealMatch, targetMatch) && (bestMatch == null || Reflect.isAssignable(targetMatch, bestMatch))) {
                bestMatch = targetMatch;
                bestMatchIndex = i;
            }
            ++i;
        }
        if (bestMatch != null) {
            return bestMatchIndex;
        }
        Interpreter.debug("no match found");
        return -1;
    }

    static boolean isAssignable(Class[] from, Class[] to) {
        if (from == null) {
            from = new Class[]{};
        }
        if (to == null) {
            to = new Class[]{};
        }
        if (from.length != to.length) {
            return false;
        }
        int i = 0;
        while (i < from.length) {
            if (to[i] != null) {
                if (from[i] == null) {
                    if (to[i].isPrimitive()) {
                        return false;
                    }
                } else if (!Reflect.isAssignableFrom(to[i], from[i])) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    static boolean isAssignableFrom(Class lhs, Class rhs) {
        if (lhs.isPrimitive() && rhs.isPrimitive()) {
            if (lhs == rhs) {
                return true;
            }
            if (rhs == Byte.TYPE && (lhs == Short.TYPE || lhs == Integer.TYPE || lhs == Long.TYPE || lhs == Float.TYPE || lhs == Double.TYPE)) {
                return true;
            }
            if (rhs == Short.TYPE && (lhs == Integer.TYPE || lhs == Long.TYPE || lhs == Float.TYPE || lhs == Double.TYPE)) {
                return true;
            }
            if (rhs == Character.TYPE && (lhs == Integer.TYPE || lhs == Long.TYPE || lhs == Float.TYPE || lhs == Double.TYPE)) {
                return true;
            }
            if (rhs == Integer.TYPE && (lhs == Long.TYPE || lhs == Float.TYPE || lhs == Double.TYPE)) {
                return true;
            }
            if (rhs == Long.TYPE && (lhs == Float.TYPE || lhs == Double.TYPE)) {
                return true;
            }
            if (rhs == Float.TYPE && lhs == Double.TYPE) {
                return true;
            }
        } else if (lhs.isAssignableFrom(rhs)) {
            return true;
        }
        return false;
    }

    private static String accessorName(String getorset, String propName) {
        return String.valueOf(getorset) + String.valueOf(Character.toUpperCase(propName.charAt(0))) + propName.substring(1);
    }

    public static boolean hasObjectPropertyGetter(Class clas, String propName) {
        String getterName = Reflect.accessorName("get", propName);
        try {
            clas.getMethod(getterName, new Class[0]);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public static boolean hasObjectPropertySetter(Class clas, String propName) {
        String setterName = Reflect.accessorName("set", propName);
        Class[] sig = new Class[]{clas};
        Method[] methods = clas.getMethods();
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getName().equals(setterName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Object getObjectProperty(Object obj, String propName) throws ReflectError {
        String accessorName = Reflect.accessorName("get", propName);
        Object[] args = new Object[]{};
        Interpreter.debug("property access: ");
        try {
            try {
                return Reflect.invokeObjectMethod(null, obj, accessorName, args, null);
            }
            catch (EvalError e) {
                throw new ReflectError("getter: " + e);
            }
        }
        catch (InvocationTargetException e) {
            throw new ReflectError("Property accessor threw exception:" + e);
        }
    }

    public static void setObjectProperty(Object obj, String propName, Object value) throws ReflectError, EvalError {
        String accessorName = Reflect.accessorName("set", propName);
        Object[] args = new Object[]{value};
        Interpreter.debug("property access: ");
        try {
            Reflect.invokeObjectMethod(null, obj, accessorName, args, null);
        }
        catch (InvocationTargetException e) {
            throw new EvalError("Property accessor threw exception!");
        }
    }

    public static String normalizeClassName(Class type) {
        if (!type.isArray()) {
            return type.getName();
        }
        StringBuffer className = new StringBuffer();
        try {
            className.append(Reflect.getArrayBaseType(type).getName());
            int i = 0;
            while (i < Reflect.getArrayDimensions(type)) {
                className.append("[]");
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return className.toString();
    }

    public static int getArrayDimensions(Class arrayClass) {
        if (!arrayClass.isArray()) {
            return 0;
        }
        return arrayClass.getName().lastIndexOf(91) + 1;
    }

    public static Class getArrayBaseType(Class arrayClass) throws ReflectError {
        if (!arrayClass.isArray()) {
            throw new ReflectError("The class is not an array.");
        }
        return arrayClass.getComponentType();
    }
}

