/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.SimpleNode;

public class EvalError
extends Exception {
    SimpleNode node;
    String message;

    public EvalError(String s) {
        this.setMessage(s);
    }

    public EvalError(String s, SimpleNode node) {
        this(s);
        this.node = node;
    }

    public String toString() {
        String trace = this.node != null ? " : at Line: " + this.node.getLineNumber() + " : in file: " + this.node.getSourceFile() + " : " + this.node.getText() : ": <at unknown location>";
        return String.valueOf(this.getMessage()) + trace;
    }

    public void reThrow(String msg) throws EvalError {
        this.reThrow(msg, null);
    }

    public void reThrow(SimpleNode node) throws EvalError {
        this.reThrow(null, node);
    }

    public void reThrow(String addMsg, SimpleNode addNode) throws EvalError {
        this.prependMessage(addMsg);
        this.addNode(addNode);
        throw this;
    }

    void setNode(SimpleNode node) {
        this.node = node;
    }

    SimpleNode getNode() {
        return this.node;
    }

    public String getErrorText() {
        if (this.node != null) {
            return this.node.getText();
        }
        return "<unknown error>";
    }

    public int getErrorLineNumber() {
        if (this.node != null) {
            return this.node.getLineNumber();
        }
        return -1;
    }

    public String getErrorSourceFile() {
        if (this.node != null) {
            return this.node.getSourceFile();
        }
        return "<unknown file>";
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String s) {
        this.message = s;
    }

    protected void prependMessage(String s) {
        if (s != null) {
            this.message = String.valueOf(s) + " : " + this.message;
        }
    }

    protected void addNode(SimpleNode addNode) {
        SimpleNode node = this.node;
        if (node == null && addNode != null) {
            node = addNode;
        }
    }
}

