/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHAmbiguousName;
import bsh.BSHPrimitiveType;
import bsh.BshClassManager;
import bsh.EvalError;
import bsh.NameSpace;
import bsh.SimpleNode;
import java.lang.reflect.Array;

class BSHType
extends SimpleNode
implements BshClassManager.Listener {
    private Class baseType;
    private int arrayDims;
    private Class type;

    BSHType(int id) {
        super(id);
        BshClassManager.addCMListener(this);
    }

    public void addArrayDimension() {
        ++this.arrayDims;
    }

    public Class getType(NameSpace namespace) throws EvalError {
        if (this.type != null) {
            return this.type;
        }
        SimpleNode node = (SimpleNode)this.jjtGetChild(0);
        this.baseType = node instanceof BSHPrimitiveType ? ((BSHPrimitiveType)node).getType() : ((BSHAmbiguousName)node).toClass(namespace);
        if (this.arrayDims > 0) {
            try {
                int[] dims = new int[this.arrayDims];
                Object obj = Array.newInstance(this.baseType, dims);
                this.type = obj.getClass();
            }
            catch (Exception e) {
                throw new EvalError("Couldn't construct array type", this);
            }
        } else {
            this.type = this.baseType;
        }
        return this.type;
    }

    public Class getBaseType() {
        return this.baseType;
    }

    public int getArrayDims() {
        return this.arrayDims;
    }

    public void classLoaderChanged() {
        this.type = null;
        this.baseType = null;
    }
}

