/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHArguments;
import bsh.BSHPrimarySuffix;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.LHS;
import bsh.Primitive;
import bsh.Reflect;
import bsh.ReflectError;
import bsh.SimpleNode;
import bsh.TargetError;
import java.lang.reflect.InvocationTargetException;

class BSHLHSPrimarySuffix
extends SimpleNode {
    public static final int INDEX = 1;
    public static final int NAME = 2;
    public static final int PROPERTY = 3;
    public int operation;
    Object index;
    public String field;
    public String method;

    BSHLHSPrimarySuffix(int id) {
        super(id);
    }

    public LHS doLHSSuffix(Object obj, CallStack callstack, Interpreter interpreter) throws EvalError {
        try {
            switch (this.operation) {
                case 1: {
                    return this.doIndex(obj, callstack, interpreter);
                }
                case 2: {
                    return this.doName(obj, callstack, interpreter);
                }
                case 3: {
                    return this.doProperty(obj, callstack, interpreter);
                }
            }
            throw new InterpreterError("LHS suffix");
        }
        catch (ReflectError e) {
            throw new EvalError("reflection error: " + e, this);
        }
        catch (InvocationTargetException e) {
            throw new TargetError("target exception", e.getTargetException(), this, true);
        }
    }

    private LHS doName(Object obj, CallStack callstack, Interpreter interpreter) throws EvalError, ReflectError, InvocationTargetException {
        if (this.jjtGetNumChildren() == 0) {
            return Reflect.getLHSObjectField(obj, this.field);
        }
        Object[] oa = ((BSHArguments)this.jjtGetChild(0)).getArguments(callstack, interpreter);
        try {
            obj = Reflect.invokeObjectMethod(interpreter, obj, this.method, oa, this);
        }
        catch (EvalError ee) {
            throw new EvalError(ee.getMessage(), this);
        }
        return Reflect.getLHSObjectField(obj, this.field);
    }

    private LHS doIndex(Object obj, CallStack callstack, Interpreter interpreter) throws EvalError, ReflectError {
        int index = BSHPrimarySuffix.getIndexAux(obj, callstack, interpreter, this);
        return new LHS(obj, index);
    }

    private LHS doProperty(Object obj, CallStack callstack, Interpreter interpreter) throws EvalError, ReflectError {
        if (obj == Primitive.VOID) {
            throw new EvalError("Attempt to access property on a void type", this);
        }
        if (obj instanceof Primitive) {
            throw new EvalError("Attempt to access property on a primitive", this);
        }
        Object value = ((SimpleNode)this.jjtGetChild(0)).eval(callstack, interpreter);
        if (!(value instanceof String)) {
            throw new EvalError("Property expression must be a String or identifier.", this);
        }
        if (Interpreter.DEBUG) {
            Interpreter.debug("LHS property access: ");
        }
        return new LHS(obj, (String)value);
    }
}

