/*
 * Decompiled with CFR 0.152.
 */
package madkit.system;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import madkit.kernel.Agent;
import madkit.kernel.AgentAddress;
import madkit.kernel.KernelMessage;
import madkit.kernel.Message;
import madkit.system.GroupMessageTracerGUI;

public class GroupMessageTracer
extends Agent {
    AgentAddress mykernel;
    boolean debug = true;
    GroupMessageTracerGUI gui;
    String targetGroup;
    Vector agents;
    Hashtable orgdump = new Hashtable();
    boolean parseTime = true;

    public boolean getParseTime() {
        return this.parseTime;
    }

    public void setParseTime(boolean bl) {
        this.parseTime = bl;
    }

    public void initGUI() {
        this.gui = new GroupMessageTracerGUI(this);
        this.setGUIObject(this.gui);
    }

    public void activate() {
        this.requestRole("public", "system", "tracer", null);
        this.mykernel = this.getAgentWithRole("system", "kernel");
        this.sendMessage(this.mykernel, (Message)new KernelMessage(14, 22));
        this.sendMessage(this.mykernel, (Message)new KernelMessage(22, 1));
        this.sendMessage(this.mykernel, (Message)new KernelMessage(22, 2));
    }

    public void enterGroup(String string) {
        if (this.targetGroup != null && !string.equals(this.targetGroup)) {
            this.leaveGroup(this.targetGroup);
        }
        if (string != null) {
            this.requestRole(string, "$MessageTracer", null);
            this.targetGroup = string;
        }
    }

    public void leaveGroups() {
        if (this.targetGroup != null) {
            this.leaveGroup(this.targetGroup);
            this.targetGroup = null;
        }
    }

    protected void requestDumpCommunities() {
        this.sendMessage(this.mykernel, (Message)new KernelMessage(14, 27));
    }

    protected Vector getAllGroups() {
        Vector vector = new Vector(this.orgdump.keySet());
        vector.removeElement("system");
        return vector;
    }

    public void live() {
        while (true) {
            Message message;
            if (!((message = this.waitNextMessage()) instanceof KernelMessage)) {
                continue;
            }
            this.handleMessage((KernelMessage)message);
        }
    }

    public Vector getAgents(String string) {
        if (string != null) {
            Vector<AgentAddress> vector = new Vector<AgentAddress>();
            String[] stringArray = this.getExistingRoles(this.targetGroup);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                AgentAddress[] agentAddressArray = this.getAgentsWithRole(this.targetGroup, stringArray[i]);
                int n2 = agentAddressArray.length;
                for (int j = 0; j < n2; ++j) {
                    vector.addElement(agentAddressArray[j]);
                }
            }
            return vector;
        }
        return null;
    }

    protected void handleMessage(KernelMessage kernelMessage) {
        if (kernelMessage.getOperation() == 22) {
            Hashtable hashtable = null;
            if (kernelMessage.getType() == 13) {
                this.orgdump = hashtable = (Hashtable)kernelMessage.getArgument();
            }
        } else if (kernelMessage.getOperation() == 1) {
            Message message = (Message)kernelMessage.getArgument();
            if (this.hasGUI()) {
                String string;
                if (!(this.targetGroup == null || this.agents == null || this.agents.contains(message.getSender()) && this.agents.contains(message.getReceiver()))) {
                    return;
                }
                String string2 = message.getClass().getName();
                string2 = string2.substring(string2.lastIndexOf(46) + 1);
                if (this.parseTime) {
                    Date date = message.getCreationDate();
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss SSSS");
                    string = simpleDateFormat.format(date);
                } else {
                    string = Long.toString(message.getCreationDate().getTime());
                }
                this.gui.addMessage(message.getSender().getName(), message.getReceiver().getName(), string2, message.toString(), string);
            } else {
                this.println("Trace" + message);
            }
        } else if (kernelMessage.getOperation() == 2) {
            Vector vector = (Vector)kernelMessage.getArgument();
            String string = (String)vector.elementAt(0);
            String string3 = (String)vector.elementAt(1);
            Message message = (Message)vector.elementAt(2);
            String string4 = message.getClass().getName();
            string4 = string4.substring(string4.lastIndexOf(46) + 1);
            if (this.hasGUI()) {
                String string5;
                if (this.targetGroup != null && this.agents != null && !this.targetGroup.equals(string) && this.agents.contains(message.getSender())) {
                    return;
                }
                if (this.parseTime) {
                    Date date = message.getCreationDate();
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss SSSS");
                    string5 = simpleDateFormat.format(date);
                } else {
                    string5 = Long.toString(message.getCreationDate().getTime());
                }
                this.gui.addMessage(message.getSender().getName(), "<" + string + "," + string3 + ">", string4, message.toString(), string5);
            }
        }
    }
}

