/*
 * Decompiled with CFR 0.152.
 */
package madkit.system;

import java.awt.Color;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import madkit.kernel.AGRTrio;
import madkit.kernel.Agent;
import madkit.kernel.AgentAddress;
import madkit.kernel.KernelMessage;
import madkit.kernel.Message;
import madkit.system.AgentEventAddTo;
import madkit.system.AgentEventCreateGroup;
import madkit.system.AgentEventKillAgent;
import madkit.system.AgentEventRemoveFromGroup;
import madkit.system.AgentEventRemoveFromRole;
import madkit.system.AgentEventSendBroadcastMessage;
import madkit.system.AgentEventSendMessage;
import madkit.system.AgentEventSimple;
import madkit.system.GraphicGroupObserverGUI;

public class GraphicGroupObserver
extends Agent {
    GraphicGroupObserverGUI gui;
    HashMap map;

    public GraphicGroupObserver() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Community", "travel");
        this.map = new HashMap();
        this.map.put("toSpy", hashMap);
        this.initMap();
    }

    public GraphicGroupObserver(HashMap hashMap) {
        this.map = hashMap;
        this.initMap();
    }

    public void initGUI() {
        this.gui = new GraphicGroupObserverGUI(this);
        this.setGUIObject(this.gui);
    }

    public void activate() {
        this.createGroup(false, "public", "system", null, null);
        this.requestRole("public", "system", "tracer", null);
        AgentAddress agentAddress = this.getAgentWithRole("system", "kernel");
        this.sendMessage(agentAddress, (Message)new KernelMessage(14, 27));
        this.sendMessage(agentAddress, (Message)new KernelMessage(22, 1));
        this.sendMessage(agentAddress, (Message)new KernelMessage(22, 2));
        this.sendMessage(agentAddress, (Message)new KernelMessage(22, 4));
        this.sendMessage(agentAddress, (Message)new KernelMessage(22, 5));
        this.sendMessage(agentAddress, (Message)new KernelMessage(22, 6));
        this.sendMessage(agentAddress, (Message)new KernelMessage(22, 7));
        this.sendMessage(agentAddress, (Message)new KernelMessage(22, 3));
        this.sendMessage(agentAddress, (Message)new KernelMessage(22, 13));
        this.sendMessage(agentAddress, (Message)new KernelMessage(22, 8));
        this.sendMessage(agentAddress, (Message)new KernelMessage(22, 9));
        this.sendMessage(agentAddress, (Message)new KernelMessage(22, 10));
        this.sendMessage(agentAddress, (Message)new KernelMessage(22, 11));
        this.sendMessage(agentAddress, (Message)new KernelMessage(22, 12));
    }

    public void live() {
        while (true) {
            Message message;
            if (!((message = this.waitNextMessage()) instanceof KernelMessage)) {
                continue;
            }
            this.handleMessage((KernelMessage)message);
        }
    }

    protected void initMap() {
        Object object = this.map.get("toSpy");
        if (object == null) {
            object = new HashMap();
            this.map.put("toSpy", object);
        }
        if (object == null) {
            object = Color.BLUE;
            this.map.put("colorCreateGroup", object);
        }
        if ((object = this.map.get("colorGroupIn")) == null) {
            object = Color.MAGENTA;
            this.map.put("colorGroupIn", object);
        }
        if ((object = this.map.get("colorGroupOut")) == null) {
            object = Color.orange;
            this.map.put("colorGroupOut", object);
        }
        if ((object = this.map.get("colorRoleIn")) == null) {
            object = Color.green;
            this.map.put("colorRoleIn", object);
        }
        if ((object = this.map.get("colorRoleOut")) == null) {
            object = Color.PINK;
            this.map.put("colorRoleOut", object);
        }
        if ((object = this.map.get("colorKill")) == null) {
            object = Color.red;
            this.map.put("colorKill", object);
        }
        if ((object = this.map.get("colorMess")) == null) {
            object = Color.black;
            this.map.put("colorMess", object);
        }
        if ((object = this.map.get("colorMessToAll")) == null) {
            object = Color.DARK_GRAY;
            this.map.put("colorMessToAll", object);
        }
        if ((object = this.map.get("addFirst")) == null) {
            object = new Boolean(true);
            this.map.put("addFirst", object);
        }
        if ((object = this.map.get("autoRemove")) == null) {
            object = new Boolean(false);
            this.map.put("autoRemove", object);
        }
    }

    protected void dumpCommunities(Map map) {
        for (Object k : map.keySet()) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("Community", k.toString());
            this.dumpGroup((Map)map.get(k), hashMap);
        }
    }

    protected void dumpGroup(Map map, HashMap hashMap) {
        for (Object k : map.keySet()) {
            HashMap<String, String> hashMap2 = new HashMap<String, String>(hashMap);
            hashMap2.put("Group", k.toString());
            this.dumpRole((Map)map.get(k), hashMap2);
        }
    }

    protected void dumpRole(Map map, HashMap hashMap) {
        for (Object k : map.keySet()) {
            HashMap<String, String> hashMap2 = new HashMap<String, String>(hashMap);
            hashMap2.put("Role", k.toString());
            this.dumpAgent((Vector)map.get(k), hashMap2);
        }
    }

    protected void dumpAgent(Vector vector, HashMap hashMap) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.gui.addExistingAgent((AgentAddress)enumeration.nextElement(), hashMap);
        }
    }

    protected void handleMessage(KernelMessage kernelMessage) {
        if (kernelMessage.getOperation() == 27) {
            Object var2_2 = null;
            if (kernelMessage.getType() == 13 && this.hasGUI()) {
                this.dumpCommunities((Map)kernelMessage.getArgument());
            }
        } else if (kernelMessage.getOperation() == 4) {
            AGRTrio aGRTrio = (AGRTrio)kernelMessage.getArgument();
            if (this.hasGUI()) {
                AgentEventCreateGroup agentEventCreateGroup = new AgentEventCreateGroup(3, new Date().getTime(), aGRTrio.getAgent(), aGRTrio.getCommunity(), aGRTrio.getGroup());
                agentEventCreateGroup.setColor((Color)this.map.get("colorCreateGroup"));
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("Community", aGRTrio.getCommunity());
                hashMap.put("Group", aGRTrio.getGroup());
                this.gui.addMemberRole(agentEventCreateGroup, hashMap);
            } else {
                this.println("ADD_MEMBER_ROLE <" + aGRTrio.getGroup() + "> by " + aGRTrio.getAgent().getName());
            }
        } else if (kernelMessage.getOperation() == 6) {
            AGRTrio aGRTrio = (AGRTrio)kernelMessage.getArgument();
            if (this.hasGUI()) {
                AgentEventAddTo agentEventAddTo = new AgentEventAddTo(3, new Date().getTime(), aGRTrio.getAgent(), aGRTrio.getCommunity(), aGRTrio.getGroup(), aGRTrio.getRole());
                agentEventAddTo.setColor((Color)this.map.get("colorRoleIn"));
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("Community", aGRTrio.getCommunity());
                hashMap.put("Group", aGRTrio.getGroup());
                hashMap.put("Role", aGRTrio.getRole());
                this.gui.addMemberRole(agentEventAddTo, hashMap);
            } else {
                this.println("ADD_MEMBER_ROLE <" + aGRTrio.getGroup() + "> by " + aGRTrio.getAgent().getName());
            }
        } else if (kernelMessage.getOperation() == 7) {
            AGRTrio aGRTrio = (AGRTrio)kernelMessage.getArgument();
            if (this.hasGUI()) {
                AgentEventRemoveFromRole agentEventRemoveFromRole = new AgentEventRemoveFromRole(4, new Date().getTime(), aGRTrio.getAgent(), aGRTrio.getCommunity(), aGRTrio.getGroup(), aGRTrio.getRole());
                agentEventRemoveFromRole.setColor((Color)this.map.get("colorRoleOut"));
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("Community", aGRTrio.getCommunity());
                hashMap.put("Group", aGRTrio.getGroup());
                hashMap.put("Role", aGRTrio.getRole());
                this.gui.removeFrom(agentEventRemoveFromRole, hashMap);
            } else {
                this.println("REMOVE_MEMBER_ROLE <" + aGRTrio.getGroup() + "> by " + aGRTrio.getAgent().getName());
            }
        } else if (kernelMessage.getOperation() == 5) {
            AGRTrio aGRTrio = (AGRTrio)kernelMessage.getArgument();
            if (this.hasGUI()) {
                AgentEventRemoveFromGroup agentEventRemoveFromGroup = new AgentEventRemoveFromGroup(4, new Date().getTime(), aGRTrio.getAgent(), aGRTrio.getCommunity(), aGRTrio.getGroup());
                agentEventRemoveFromGroup.setColor((Color)this.map.get("colorGroupOut"));
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("Community", aGRTrio.getCommunity());
                hashMap.put("Group", aGRTrio.getGroup());
                this.gui.removeFrom(agentEventRemoveFromGroup, hashMap);
            } else {
                this.println("LEAVE_GROUP <" + aGRTrio.getGroup() + "> by " + aGRTrio.getAgent().getName());
            }
        } else if (kernelMessage.getOperation() == 3) {
            Object object = kernelMessage.getArgument();
            AgentAddress agentAddress = null;
            if (object instanceof AGRTrio) {
                agentAddress = ((AGRTrio)object).getAgent();
            } else if (object instanceof AgentAddress) {
                agentAddress = (AgentAddress)object;
            }
            if (this.hasGUI() && agentAddress != null) {
                AgentEventKillAgent agentEventKillAgent = new AgentEventKillAgent(6, new Date().getTime(), agentAddress);
                agentEventKillAgent.setColor((Color)this.map.get("colorKill"));
                this.gui.killAgent(agentEventKillAgent);
            } else {
                this.println("KILL_AGENT " + agentAddress.getName());
            }
        } else if (kernelMessage.getOperation() == 1) {
            Message message = (Message)kernelMessage.getArgument();
            if (this.hasGUI()) {
                String string = message.getClass().getName();
                string = string.substring(string.lastIndexOf(46) + 1);
                AgentEventSendMessage agentEventSendMessage = new AgentEventSendMessage(1, message.getCreationDate().getTime(), message.getSender(), message.getReceiver(), string, message.toString());
                agentEventSendMessage.setColor((Color)this.map.get("colorMess"));
                this.gui.addMessage(agentEventSendMessage);
            } else {
                this.println("Trace " + message);
            }
        } else if (kernelMessage.getOperation() == 2) {
            Vector vector = (Vector)kernelMessage.getArgument();
            String string = (String)vector.elementAt(0);
            String string2 = (String)vector.elementAt(1);
            Message message = (Message)vector.elementAt(2);
            String string3 = message.getClass().getName();
            string3 = string3.substring(string3.lastIndexOf(46) + 1);
            if (this.hasGUI()) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("Group", string);
                hashMap.put("Role", string2);
                AgentEventSendBroadcastMessage agentEventSendBroadcastMessage = new AgentEventSendBroadcastMessage(2, message.getCreationDate().getTime(), message.getSender(), hashMap, string3, message.toString());
                agentEventSendBroadcastMessage.setColor((Color)this.map.get("colorMessToAll"));
                this.gui.addBroadcastMessage(agentEventSendBroadcastMessage);
            }
        } else if (kernelMessage.getOperation() == 12) {
            String string = (String)kernelMessage.getArgument();
            if (this.hasGUI()) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("Community", string);
                AgentEventSimple agentEventSimple = new AgentEventSimple(5, new Date().getTime());
                this.gui.removeAllFrom(agentEventSimple, hashMap);
            } else {
                this.println("REMOVE_COMMUNITY <" + string + "> ");
            }
        }
    }

    public HashMap getMap() {
        return this.map;
    }
}

