/*
 * Decompiled with CFR 0.152.
 */
package madkit.utils.agents;

import java.io.File;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Agent;
import madkit.kernel.AgentAddress;
import madkit.kernel.Controller;
import madkit.kernel.Message;
import madkit.kernel.StringMessage;
import madkit.messages.ControlMessage;

public abstract class LanguageController
implements Controller {
    protected AbstractAgent thisAgent;
    String libFile = null;
    String behaviorFile = null;
    private boolean watchOutMessages = true;
    private boolean watchInMessages = true;
    private boolean watchRestartEngine = false;
    private boolean watchControlMessages = false;

    public AbstractAgent thisAgent() {
        return this.thisAgent;
    }

    public void end() {
        this.thisAgent.end();
    }

    public LanguageController(AbstractAgent abstractAgent) {
        this.thisAgent = abstractAgent;
    }

    public LanguageController(AbstractAgent abstractAgent, String string) {
        this(abstractAgent);
        String string2 = new File(string).getAbsolutePath();
        this.setBehaviorFile(string2);
    }

    public String getLibFile() {
        return this.libFile;
    }

    public void setLibFile(String string) {
        this.libFile = string;
    }

    public String getBehaviorFile() {
        return this.behaviorFile;
    }

    public void setBehaviorFile(String string) {
        this.behaviorFile = string;
    }

    public void setWatchOutMessages(boolean bl) {
        this.watchOutMessages = bl;
    }

    public void setWatchInMessages(boolean bl) {
        this.watchInMessages = bl;
    }

    public void setWatchRestartEngine(boolean bl) {
        this.watchRestartEngine = bl;
    }

    public void setWatchControlMessages(boolean bl) {
        this.watchControlMessages = bl;
    }

    public boolean getWatchOutMessages() {
        return this.watchOutMessages;
    }

    public boolean getWatchInMessages() {
        return this.watchInMessages;
    }

    public boolean getWatchRestartEngine() {
        return this.watchRestartEngine;
    }

    public boolean getWatchControlMessages() {
        return this.watchControlMessages;
    }

    public void toggleWatchOutMessages() {
        this.watchOutMessages = !this.watchOutMessages;
    }

    public void toggleWatchInMessages() {
        this.watchInMessages = !this.watchInMessages;
    }

    public void toggleWatchRestartEngine() {
        this.watchRestartEngine = !this.watchRestartEngine;
    }

    public void toggleWatchControlMessages() {
        this.watchControlMessages = !this.watchControlMessages;
    }

    public void activate() {
        this.println("Language controller");
    }

    public void println(String string) {
        this.thisAgent.println(string);
    }

    protected void handleControlMessage(ControlMessage controlMessage) {
        String string = controlMessage.getAction();
    }

    protected final void exitImmediatlyOnKill() {
        this.thisAgent.getMyGroups();
    }

    public void live() {
    }

    public void doIt() {
    }

    protected void readMessages() {
        while (!this.thisAgent.isMessageBoxEmpty()) {
            this.handleMessage(this.thisAgent.nextMessage());
        }
    }

    protected void handleMessage(Message message) {
        if (message instanceof ControlMessage) {
            this.handleControlMessage((ControlMessage)message);
        }
    }

    public void doPause(int n) {
        if (this.thisAgent instanceof Agent) {
            ((Agent)this.thisAgent).pause(n);
        }
    }

    public void doLaunchAgent(AbstractAgent abstractAgent, String string, boolean bl) {
        this.thisAgent.launchAgent(abstractAgent, string, bl);
    }

    public void doSendStringMessage(AgentAddress agentAddress, String string) {
        if (this.getWatchOutMessages()) {
            this.println(">> sending string message : " + string + " to " + agentAddress);
        }
        this.thisAgent.sendMessage(agentAddress, (Message)new StringMessage(string));
    }

    public void doSendMessage(AgentAddress agentAddress, Message message) {
        if (this.getWatchOutMessages()) {
            this.println(">> sending message : " + message + " to " + agentAddress);
        }
        this.thisAgent.sendMessage(agentAddress, message);
    }

    public void doSendControlMessage(String string) {
        this.thisAgent.sendMessage(this.thisAgent.getAddress(), (Message)new ControlMessage(string));
    }

    public void doSendControlMessage(String string, String string2) {
        this.thisAgent.sendMessage(this.thisAgent.getAddress(), (Message)new ControlMessage(string, string2));
    }

    public void doSendMessage(String string, String string2, Message message) {
        if (this.getWatchOutMessages()) {
            this.println(">> sending messages : " + message + " to role " + string2 + " of " + string);
        }
        this.thisAgent.sendMessage(string, string2, message);
    }

    public void doBroadcastMessage(String string, String string2, Message message) {
        if (this.getWatchOutMessages()) {
            this.println(">> broadcast messages : " + message + " to role " + string2 + " of " + string);
        }
        this.thisAgent.broadcastMessage(string, string2, message);
    }

    public void doBroadcastMessage(String string, String string2, String string3, Message message) {
        if (this.getWatchOutMessages()) {
            this.println(">> broadcast messages : " + message + " to role " + string3 + " of " + string2 + " from community " + string);
        }
        this.thisAgent.broadcastMessage(string, string2, string3, message);
    }
}

