/*
 * Decompiled with CFR 0.152.
 */
package madkit.distributedbees;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import madkit.distributedbees.InputListener;
import madkit.kernel.OPanel;

public class InputListenerGUI
extends JPanel
implements ActionListener {
    private GridBagLayout gridbag;
    private GridBagConstraints constraints;
    private JButton redViewButton;
    private JButton blueViewButton;
    private JButton greenViewButton;
    private JButton redPlayerButton;
    private JButton bluePlayerButton;
    private JButton greenPlayerButton;
    private ButtonGroup group;
    private boolean blueView = false;
    private boolean redView = false;
    private boolean greenView = false;
    private JRadioButton aleaRadioButton;
    private JRadioButton carreRadioButton;
    private JRadioButton sourisRadioButton;
    private JPanel viewButtonsPanel;
    private JPanel playButtonsPanel;
    private OPanel textDisplay;
    private InputListener myListener;

    public InputListenerGUI(InputListener inputListener) {
        this.myListener = inputListener;
        this.setSize(380, 160);
        this.initialisation();
    }

    public void makebutton(JButton jButton, JPanel jPanel) {
        this.gridbag.setConstraints(jButton, this.constraints);
        jPanel.add(jButton);
    }

    public JRadioButton addRadioButton(JPanel jPanel, ButtonGroup buttonGroup, String string, boolean bl) {
        JRadioButton jRadioButton = new JRadioButton(string, bl);
        jRadioButton.addActionListener(this);
        this.gridbag.setConstraints(jRadioButton, this.constraints);
        buttonGroup.add(jRadioButton);
        jPanel.add(jRadioButton);
        return jRadioButton;
    }

    public void initialisation() {
        this.redViewButton = new JButton("RedViewer");
        this.blueViewButton = new JButton("BlueViewer");
        this.greenViewButton = new JButton("greenViewer");
        this.redPlayerButton = new JButton("redPlayer ");
        this.bluePlayerButton = new JButton("bluePlayer");
        this.greenPlayerButton = new JButton("greenPlayer");
        this.redViewButton.addActionListener(this);
        this.redPlayerButton.addActionListener(this);
        this.blueViewButton.addActionListener(this);
        this.greenViewButton.addActionListener(this);
        this.bluePlayerButton.addActionListener(this);
        this.greenPlayerButton.addActionListener(this);
        this.gridbag = new GridBagLayout();
        this.constraints = new GridBagConstraints();
        this.viewButtonsPanel = new JPanel(this.gridbag);
        Border border = BorderFactory.createEtchedBorder();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, "VIEW");
        this.viewButtonsPanel.setBorder(titledBorder);
        this.constraints.fill = 1;
        this.constraints.anchor = 10;
        this.constraints.weightx = 100.0;
        this.constraints.gridwidth = 3;
        this.makebutton(this.redViewButton, this.viewButtonsPanel);
        this.makebutton(this.blueViewButton, this.viewButtonsPanel);
        this.constraints.gridwidth = 0;
        this.makebutton(this.greenViewButton, this.viewButtonsPanel);
        this.constraints.weightx = 0.0;
        this.playButtonsPanel = new JPanel(this.gridbag);
        Border border2 = BorderFactory.createEtchedBorder();
        TitledBorder titledBorder2 = BorderFactory.createTitledBorder(border2, "PLAYER");
        this.playButtonsPanel.setBorder(titledBorder2);
        this.playButtonsPanel.setLayout(this.gridbag);
        this.constraints.gridwidth = 3;
        this.makebutton(this.redPlayerButton, this.playButtonsPanel);
        this.makebutton(this.bluePlayerButton, this.playButtonsPanel);
        this.constraints.gridwidth = 0;
        this.makebutton(this.greenPlayerButton, this.playButtonsPanel);
        this.group = new ButtonGroup();
        this.constraints.gridwidth = 3;
        this.constraints.fill = 0;
        this.aleaRadioButton = this.addRadioButton(this.playButtonsPanel, this.group, "Random", false);
        this.aleaRadioButton.setEnabled(false);
        this.carreRadioButton = this.addRadioButton(this.playButtonsPanel, this.group, "Square", false);
        this.carreRadioButton.setEnabled(false);
        this.constraints.gridwidth = 0;
        this.sourisRadioButton = this.addRadioButton(this.playButtonsPanel, this.group, "Mouse", false);
        this.sourisRadioButton.setEnabled(false);
        this.textDisplay = new OPanel();
        this.textDisplay.jscrollpane.setHorizontalScrollBarPolicy(31);
        this.textDisplay.jscrollpane.setVerticalScrollBarPolicy(20);
        this.myListener.setOutputWriter(this.textDisplay.getOut());
        this.constraints.fill = 0;
        this.constraints.gridwidth = 3;
        this.constraints.weightx = 0.0;
        this.gridbag.setConstraints(this.viewButtonsPanel, this.constraints);
        this.add((Component)this.viewButtonsPanel, this.constraints);
        this.constraints.gridwidth = 0;
        this.gridbag.setConstraints(this.playButtonsPanel, this.constraints);
        this.add((Component)this.playButtonsPanel, this.constraints);
        this.doLayout();
        this.viewButtonsPanel.doLayout();
        this.playButtonsPanel.doLayout();
    }

    public Dimension getPreferredSize() {
        return this.getSize();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.redViewButton) {
            if (this.redView) {
                this.redViewButton.setBackground(this.viewButtonsPanel.getBackground());
                this.redView = false;
            } else {
                this.redViewButton.setBackground(Color.red);
                this.redView = true;
            }
            this.myListener.changeColoredView(Color.red, this.redView);
            return;
        }
        if (object == this.greenViewButton) {
            if (this.greenView) {
                this.greenViewButton.setBackground(this.viewButtonsPanel.getBackground());
                this.greenView = false;
            } else {
                this.greenViewButton.setBackground(Color.green);
                this.greenView = true;
            }
            this.myListener.changeColoredView(Color.green, this.greenView);
            return;
        }
        if (object == this.blueViewButton) {
            if (this.blueView) {
                this.blueViewButton.setBackground(this.viewButtonsPanel.getBackground());
                this.blueView = false;
            } else {
                this.blueViewButton.setBackground(Color.cyan);
                this.blueView = true;
            }
            this.myListener.changeColoredView(Color.blue, this.blueView);
            return;
        }
        if (object == this.bluePlayerButton) {
            if (this.bluePlayerButton.getBackground() != Color.cyan) {
                this.allJRadioButtonsAtFalse();
            }
            this.bluePlayerButton.setBackground(Color.cyan);
            this.redPlayerButton.setBackground(this.playButtonsPanel.getBackground());
            this.greenPlayerButton.setBackground(this.playButtonsPanel.getBackground());
            this.myListener.changeColoredRole(Color.blue);
        }
        if (object == this.redPlayerButton) {
            if (this.redPlayerButton.getBackground() != Color.red) {
                this.allJRadioButtonsAtFalse();
            }
            this.redPlayerButton.setBackground(Color.red);
            this.bluePlayerButton.setBackground(this.playButtonsPanel.getBackground());
            this.greenPlayerButton.setBackground(this.playButtonsPanel.getBackground());
            this.myListener.changeColoredRole(Color.red);
        }
        if (object == this.greenPlayerButton) {
            if (this.greenPlayerButton.getBackground() != Color.green) {
                this.allJRadioButtonsAtFalse();
            }
            this.greenPlayerButton.setBackground(Color.green);
            this.redPlayerButton.setBackground(this.playButtonsPanel.getBackground());
            this.bluePlayerButton.setBackground(this.playButtonsPanel.getBackground());
            this.myListener.changeColoredRole(Color.green);
        }
        if (object == this.aleaRadioButton) {
            this.myListener.purposeMessage("buzz");
        }
        if (object == this.carreRadioButton) {
            this.myListener.purposeMessage("carre");
        }
        if (object == this.sourisRadioButton) {
            this.myListener.purposeMessage("moveTo");
        }
    }

    public void allJRadioButtonsAtFalse() {
        Enumeration<AbstractButton> enumeration = this.group.getElements();
        while (enumeration.hasMoreElements()) {
            JRadioButton jRadioButton = (JRadioButton)enumeration.nextElement();
            jRadioButton.setEnabled(true);
            jRadioButton.setSelected(false);
        }
    }
}

