/*
 * Decompiled with CFR 0.152.
 */
package madkit.distributedbees;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import madkit.distributedbees.BeeLauncher;
import madkit.kernel.OPanel;

public class BeeLauncherGUI
extends JPanel
implements ActionListener {
    private BeeLauncher myListener;
    JLabel label;
    private OPanel textDisplay;
    Panneau redJPanel;
    Panneau greenJPanel;
    Panneau blueJPanel;
    JButton redLaunchButton;
    JButton blueLaunchButton;
    JButton greenLaunchButton;
    JButton redKillButton;
    JButton blueKillButton;
    JButton greenKillButton;

    public BeeLauncherGUI(BeeLauncher beeLauncher) {
        this.myListener = beeLauncher;
        this.setSize(380, 280);
        this.initialisation();
    }

    public void initialisation() {
        this.setLayout(new GridLayout(2, 1));
        JPanel jPanel = new JPanel();
        this.label = new JLabel("BeeLauncher : " + this.myListener.group + "  ", 0);
        this.label.setFont(new Font("Dialog", 1, 14));
        this.label.setMaximumSize(new Dimension(350, 70));
        this.textDisplay = new OPanel();
        this.textDisplay.jscrollpane.setHorizontalScrollBarPolicy(31);
        this.textDisplay.jscrollpane.setVerticalScrollBarPolicy(20);
        this.myListener.setOutputWriter(this.textDisplay.getOut());
        jPanel.add(this.label);
        jPanel.add((Component)this.textDisplay, -1);
        this.add((Component)jPanel, "North");
        this.redJPanel = new Panneau(Color.red, this);
        this.greenJPanel = new Panneau(Color.green, this);
        this.blueJPanel = new Panneau(Color.blue, this);
        JPanel jPanel2 = new JPanel();
        jPanel2.add("Center", this.redJPanel);
        jPanel2.add("Center", this.blueJPanel);
        jPanel2.add("Center", this.greenJPanel);
        this.add((Component)jPanel2, "South");
        this.redLaunchButton = this.redJPanel.launchButton;
        this.blueLaunchButton = this.blueJPanel.launchButton;
        this.greenLaunchButton = this.greenJPanel.launchButton;
        this.redKillButton = this.redJPanel.killButton;
        this.blueKillButton = this.blueJPanel.killButton;
        this.greenKillButton = this.greenJPanel.killButton;
    }

    public Dimension getPreferredSize() {
        return this.getSize();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.redLaunchButton) {
            this.myListener.setLaunchTheRed(true);
        }
        if (object == this.redKillButton) {
            this.myListener.killTheReds = true;
        }
        if (object == this.blueLaunchButton) {
            this.myListener.setLaunchTheBlue(true);
        }
        if (object == this.blueKillButton) {
            this.myListener.killTheBlues = true;
        }
        if (object == this.greenLaunchButton) {
            this.myListener.setLaunchTheGreen(true);
        }
        if (object == this.greenKillButton) {
            this.myListener.killTheGreens = true;
        }
    }

    public void updateName() {
        this.label.setText("Launcher : " + this.myListener.group.toUpperCase() + "  ");
    }

    class IntTextField
    extends JTextField {
        public IntTextField(int n, int n2) {
            super("" + n, n2);
            this.setHorizontalAlignment(4);
        }

        public boolean isValid() {
            try {
                Integer.parseInt(this.getText());
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }

        public int getValue() {
            try {
                return Integer.parseInt(this.getText());
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }
    }

    class Panneau
    extends JPanel
    implements DocumentListener {
        JButton launchButton;
        JButton killButton;
        IntTextField nbBeesField;
        String couleur;
        BeeLauncher myLauncher;

        public Panneau(Color color, ActionListener actionListener) {
            this.setLayout(new GridLayout(3, 1));
            this.setBackground(color);
            this.nbBeesField = new IntTextField(0, 4);
            this.launchButton = new JButton("Launch");
            this.killButton = new JButton("Kill");
            this.add(this.nbBeesField);
            this.add(this.launchButton);
            this.add(this.killButton);
            this.launchButton.addActionListener(actionListener);
            this.killButton.addActionListener(actionListener);
            this.nbBeesField.getDocument().addDocumentListener(this);
            Border border = BorderFactory.createEtchedBorder();
            if (color == Color.green) {
                this.couleur = "green";
            }
            if (color == Color.red) {
                this.couleur = "red";
            }
            if (color == Color.blue) {
                this.couleur = "blue";
            }
            TitledBorder titledBorder = BorderFactory.createTitledBorder(border, this.couleur + " swarm");
            this.setBorder(titledBorder);
            this.myLauncher = ((BeeLauncherGUI)actionListener).myListener;
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            Document document = documentEvent.getDocument();
            try {
                if (this.couleur.equals("red")) {
                    this.myLauncher.setNumberOfRedBees(this.nbBeesField.getValue());
                }
                if (this.couleur.equals("green")) {
                    this.myLauncher.setNumberOfGreenBees(this.nbBeesField.getValue());
                }
                if (this.couleur.equals("blue")) {
                    this.myLauncher.setNumberOfBlueBees(this.nbBeesField.getValue());
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }
}

