/*
 * Decompiled with CFR 0.152.
 */
package madkit.distributedbees;

import java.awt.Color;
import java.awt.Point;
import madkit.distributedbees.Bee;
import madkit.distributedbees.BeeControler;
import madkit.distributedbees.BeeProbe;
import madkit.distributedbees.ServiceMessage;
import madkit.kernel.Probe;
import madkit.kernel.ReferenceableAgent;
import madkit.kernel.Watcher;

public class BeeEpiphyt
extends Watcher
implements ReferenceableAgent {
    protected ServiceMessage msg = new ServiceMessage();
    protected Point[] redPoints = new Point[0];
    protected Point[] bluePoints = new Point[0];
    protected Point[] greenPoints = new Point[0];
    protected Probe redControler;
    protected Probe blueControler;
    protected Probe greenControler;
    BeeProbe blueQueenProbe;
    BeeProbe redQueenProbe;
    BeeProbe greenQueenProbe;
    boolean active = true;

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public boolean getActive() {
        return this.active;
    }

    public BeeEpiphyt() {
        System.err.println("Starting EpiphyteAgent");
    }

    public void watchBlueQueensPoints() {
        try {
            Bee[] beeArray = this.blueQueenProbe.getBees();
            if (beeArray != null) {
                this.bluePoints = new Point[beeArray.length];
                if (beeArray.length > 0) {
                    for (int i = 0; i < beeArray.length; ++i) {
                        this.bluePoints[i] = beeArray[i].p;
                    }
                }
            }
        }
        catch (Exception exception) {
            System.err.println("Erreur dans watchBlueQueensPoints " + exception);
        }
    }

    public void watchGreenQueensPoints() {
        try {
            Bee[] beeArray = this.greenQueenProbe.getBees();
            if (beeArray != null) {
                this.greenPoints = new Point[beeArray.length];
                if (beeArray.length > 0) {
                    for (int i = 0; i < beeArray.length; ++i) {
                        this.greenPoints[i] = beeArray[i].p;
                    }
                }
            }
        }
        catch (Exception exception) {
            System.err.println("Erreur dans watchGreenQueensPoints " + exception);
        }
    }

    public void watchRedQueensPoints() {
        try {
            Bee[] beeArray = this.redQueenProbe.getBees();
            if (beeArray != null) {
                this.redPoints = new Point[beeArray.length];
                if (beeArray.length > 0) {
                    for (int i = 0; i < beeArray.length; ++i) {
                        this.redPoints[i] = beeArray[i].p;
                    }
                }
            }
        }
        catch (Exception exception) {
            System.err.println("Erreur dans watchRedQueensPoints " + exception);
        }
    }

    public void observe() {
        if (((BeeControler)this.redControler.getAgentNb(0)).getPurposeName().equals("carre")) {
            this.watchRedQueensPoints();
            if (this.redPoints.length > 0) {
                this.msg.setTable(this.redPoints);
                this.broadcastMessage("buzz", "simulation", Color.red.toString() + "Controler", this.msg);
            }
        }
        if (((BeeControler)this.blueControler.getAgentNb(0)).getPurposeName().equals("carre")) {
            this.watchBlueQueensPoints();
            if (this.bluePoints.length > 0) {
                this.msg.setTable(this.bluePoints);
                this.broadcastMessage("buzz", "simulation", Color.blue.toString() + "Controler", this.msg);
            }
        }
        if (((BeeControler)this.greenControler.getAgentNb(0)).getPurposeName().equals("carre")) {
            this.watchGreenQueensPoints();
            if (this.greenPoints.length > 0) {
                this.msg.setTable(this.greenPoints);
                this.broadcastMessage("buzz", "simulation", Color.green.toString() + "Controler", this.msg);
            }
        }
    }

    public void activate() {
        this.requestRole("buzz", "master", "BeeEpiphyt", null);
        this.redControler = new Probe("buzz", this.getAddress().getKernel().toString(), Color.red.toString() + "Controler");
        this.blueControler = new Probe("buzz", this.getAddress().getKernel().toString(), Color.blue.toString() + "Controler");
        this.greenControler = new Probe("buzz", this.getAddress().getKernel().toString(), Color.green.toString() + "Controler");
        this.addProbe(this.blueControler);
        this.addProbe(this.redControler);
        this.addProbe(this.greenControler);
        this.blueQueenProbe = new BeeProbe("bees", Color.blue.toString() + "Queen");
        this.addProbe(this.blueQueenProbe);
        this.greenQueenProbe = new BeeProbe("bees", Color.green.toString() + "Queen");
        this.addProbe(this.greenQueenProbe);
        this.redQueenProbe = new BeeProbe("bees", Color.red.toString() + "Queen");
        this.addProbe(this.redQueenProbe);
        System.err.println("" + this.getAddress() + " Probes OK.");
    }

    public void end() {
        super.end();
        System.err.println("BeeEpiphyt > END");
    }
}

